/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import fuzs.universalenchants.UniversalEnchants;
import fuzs.universalenchants.config.CommonConfig;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;

public class ModEnchantCommand {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"commands.enchant.failed.entity", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"commands.enchant.failed.itemless", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_INCOMPATIBLE = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"commands.enchant.failed.incompatible", (Object[])new Object[]{object}));
    private static final Dynamic2CommandExceptionType ERROR_LEVEL_TOO_HIGH = new Dynamic2CommandExceptionType((object, object2) -> class_2561.method_43469((String)"commands.enchant.failed.level", (Object[])new Object[]{object, object2}));
    private static final SimpleCommandExceptionType ERROR_NOTHING_HAPPENED = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.enchant.failed"));

    public static void register(CommandDispatcher<class_2168> commandDispatcher, class_7157 context) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"enchant").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"enchantment", (ArgumentType)class_7733.method_45603((class_7157)context, (class_5321)class_7924.field_41265)).executes(commandContext -> ModEnchantCommand.enchant((class_2168)commandContext.getSource(), class_2186.method_9317((CommandContext)commandContext, (String)"targets"), (class_6880<class_1887>)class_7733.method_45612((CommandContext)commandContext, (String)"enchantment"), 0)))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enchantment", (ArgumentType)class_7733.method_45603((class_7157)context, (class_5321)class_7924.field_41265)).executes(commandContext -> ModEnchantCommand.enchant((class_2168)commandContext.getSource(), class_2186.method_9317((CommandContext)commandContext, (String)"targets"), (class_6880<class_1887>)class_7733.method_45612((CommandContext)commandContext, (String)"enchantment")))).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)255)).executes(commandContext -> ModEnchantCommand.enchant((class_2168)commandContext.getSource(), class_2186.method_9317((CommandContext)commandContext, (String)"targets"), (class_6880<class_1887>)class_7733.method_45612((CommandContext)commandContext, (String)"enchantment"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"))))))));
    }

    private static int enchant(class_2168 commandSourceStack, Collection<? extends class_1297> collection, class_6880<class_1887> holder) throws CommandSyntaxException {
        return ModEnchantCommand.enchant(commandSourceStack, collection, holder, ((class_1887)holder.comp_349()).method_8183());
    }

    private static int enchant(class_2168 commandSourceStack, Collection<? extends class_1297> collection, class_6880<class_1887> holder, int level) throws CommandSyntaxException {
        class_1887 enchantment = (class_1887)holder.comp_349();
        if (!((CommonConfig)UniversalEnchants.CONFIG.get(CommonConfig.class)).enchantCommand.removeMaxLevelLimit && level > enchantment.method_8183()) {
            throw ERROR_LEVEL_TOO_HIGH.create((Object)level, (Object)enchantment.method_8183());
        }
        if (level > 255) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooHigh().create((Object)level, (Object)255);
        }
        int successes = 0;
        for (class_1297 class_12972 : collection) {
            if (class_12972 instanceof class_1309) {
                class_1309 livingEntity = (class_1309)class_12972;
                class_1799 itemStack = livingEntity.method_6047();
                if (!itemStack.method_7960()) {
                    if (((CommonConfig)UniversalEnchants.CONFIG.get(CommonConfig.class)).enchantCommand.fixEnchantCommand) {
                        class_1799 stack = itemStack;
                        if (stack.method_7947() == 1 && stack.method_31574(class_1802.field_8529)) {
                            stack = new class_1799((class_1935)class_1802.field_8598);
                            class_2487 compoundTag = itemStack.method_7969();
                            if (compoundTag != null) {
                                stack.method_7980(compoundTag.method_10553());
                            }
                        }
                        if ((stack.method_31574(class_1802.field_8598) || enchantment.method_8192(stack)) && class_1890.method_8201(class_1890.method_8222((class_1799)stack).keySet().stream().filter(e -> e != enchantment).toList(), (class_1887)enchantment)) {
                            Map enchantments = class_1890.method_8222((class_1799)stack);
                            if (level > 0) {
                                Integer oldLevel = enchantments.put(enchantment, level);
                                if (oldLevel != null && oldLevel == level && collection.size() == 1) {
                                    throw ERROR_INCOMPATIBLE.create((Object)itemStack.method_7909().method_7864(itemStack).getString());
                                }
                            } else {
                                enchantments.remove(enchantment);
                            }
                            ModEnchantCommand.setEnchantments(enchantments, stack);
                            if (stack.method_31574(class_1802.field_8598) && enchantments.isEmpty()) {
                                stack = new class_1799((class_1935)class_1802.field_8529);
                                class_2487 compoundTag = itemStack.method_7969();
                                if (compoundTag != null) {
                                    stack.method_7980(compoundTag.method_10553());
                                }
                            }
                            livingEntity.method_6122(class_1268.field_5808, stack);
                            ++successes;
                            continue;
                        }
                        if (collection.size() != 1) continue;
                        throw ERROR_INCOMPATIBLE.create((Object)itemStack.method_7909().method_7864(itemStack).getString());
                    }
                    if (enchantment.method_8192(itemStack) && class_1890.method_8201(class_1890.method_8222((class_1799)itemStack).keySet(), (class_1887)enchantment)) {
                        itemStack.method_7978(enchantment, level);
                        ++successes;
                        continue;
                    }
                    if (collection.size() != 1) continue;
                    throw ERROR_INCOMPATIBLE.create((Object)itemStack.method_7909().method_7864(itemStack).getString());
                }
                if (collection.size() != 1) continue;
                throw ERROR_NO_ITEM.create((Object)livingEntity.method_5477().getString());
            }
            if (collection.size() != 1) continue;
            throw ERROR_NOT_LIVING_ENTITY.create((Object)class_12972.method_5477().getString());
        }
        if (successes == 0) {
            throw ERROR_NOTHING_HAPPENED.create();
        }
        if (collection.size() == 1) {
            commandSourceStack.method_9226(() -> level > 0 || !((CommonConfig)UniversalEnchants.CONFIG.get(CommonConfig.class)).enchantCommand.fixEnchantCommand ? class_2561.method_43469((String)"commands.enchant.success.single", (Object[])new Object[]{enchantment.method_8179(level), ((class_1297)collection.iterator().next()).method_5476()}) : class_2561.method_43469((String)"commands.enchant.remove.success.single", (Object[])new Object[]{ModEnchantCommand.getEnchantmentName(enchantment), ((class_1297)collection.iterator().next()).method_5476()}), true);
        } else {
            commandSourceStack.method_9226(() -> level > 0 || !((CommonConfig)UniversalEnchants.CONFIG.get(CommonConfig.class)).enchantCommand.fixEnchantCommand ? class_2561.method_43469((String)"commands.enchant.success.multiple", (Object[])new Object[]{enchantment.method_8179(level), collection.size()}) : class_2561.method_43469((String)"commands.enchant.remove.success.multiple", (Object[])new Object[]{ModEnchantCommand.getEnchantmentName(enchantment), collection.size()}), true);
        }
        return successes;
    }

    private static void setEnchantments(Map<class_1887, Integer> map, class_1799 itemStack) {
        String enchantmentsKey;
        class_2499 list = new class_2499();
        for (Map.Entry<class_1887, Integer> entry : map.entrySet()) {
            class_1887 enchantment = entry.getKey();
            if (enchantment == null) continue;
            list.add((Object)class_1890.method_37426((class_2960)class_1890.method_37423((class_1887)enchantment), (int)entry.getValue()));
        }
        String string = enchantmentsKey = itemStack.method_31574(class_1802.field_8598) ? "StoredEnchantments" : "Enchantments";
        if (list.isEmpty()) {
            itemStack.method_7983(enchantmentsKey);
        } else {
            itemStack.method_7959(enchantmentsKey, (class_2520)list);
        }
    }

    private static class_2561 getEnchantmentName(class_1887 enchantment) {
        class_5250 mutableComponent = class_2561.method_43471((String)enchantment.method_8184());
        if (enchantment.method_8195()) {
            mutableComponent.method_27692(class_124.field_1061);
        } else {
            mutableComponent.method_27692(class_124.field_1080);
        }
        return mutableComponent;
    }
}

