/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import net.coderbot.iris.IrisLogging;
import net.coderbot.iris.UpdateChecker;
import net.coderbot.iris.config.IrisConfig;
import net.coderbot.iris.gl.GLDebug;
import net.coderbot.iris.gl.shader.ShaderCompileException;
import net.coderbot.iris.gl.shader.StandardMacros;
import net.coderbot.iris.gui.debug.DebugLoadFailedGridScreen;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.pipeline.FixedFunctionWorldRenderingPipeline;
import net.coderbot.iris.pipeline.PipelineManager;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline;
import net.coderbot.iris.shaderpack.DimensionId;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.coderbot.iris.shaderpack.discovery.ShaderpackDirectoryManager;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.coderbot.iris.shaderpack.option.OptionSet;
import net.coderbot.iris.shaderpack.option.Profile;
import net.coderbot.iris.shaderpack.option.values.MutableOptionValues;
import net.coderbot.iris.shaderpack.option.values.OptionValues;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_1008;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class Iris {
    public static final String MODID = "iris";
    public static final String MODNAME = "Iris";
    public static final IrisLogging logger = new IrisLogging("Iris");
    private static Path shaderpacksDirectory;
    private static ShaderpackDirectoryManager shaderpacksDirectoryManager;
    private static ShaderPack currentPack;
    private static String currentPackName;
    private static Optional<Exception> storedError;
    private static boolean initialized;
    private static PipelineManager pipelineManager;
    private static IrisConfig irisConfig;
    private static FileSystem zipFileSystem;
    private static class_304 reloadKeybind;
    private static class_304 toggleShadersKeybind;
    private static class_304 shaderpackScreenKeybind;
    private static final Map<String, String> shaderPackOptionQueue;
    private static boolean resetShaderPackOptions;
    private static Version IRIS_VERSION;
    private static UpdateChecker updateChecker;
    private static boolean fallback;
    private static String backupVersionNumber;
    public static NamespacedId lastDimension;

    public void onEarlyInitialize() {
        ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow(() -> new IllegalStateException("Couldn't find the mod container for Iris"));
        IRIS_VERSION = modContainer.getMetadata().getVersion();
        updateChecker = new UpdateChecker(IRIS_VERSION);
        reloadKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("iris.keybind.reload", class_3675.class_307.field_1668, 82, "iris.keybinds"));
        toggleShadersKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("iris.keybind.toggleShaders", class_3675.class_307.field_1668, 75, "iris.keybinds"));
        shaderpackScreenKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("iris.keybind.shaderPackSelection", class_3675.class_307.field_1668, 79, "iris.keybinds"));
        try {
            if (!Files.exists(Iris.getShaderpacksDirectory(), new LinkOption[0])) {
                Files.createDirectories(Iris.getShaderpacksDirectory(), new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            logger.warn("Failed to create the shaderpacks directory!");
            logger.warn("", iOException);
        }
        irisConfig = new IrisConfig(FabricLoader.getInstance().getConfigDir().resolve("iris.properties"));
        try {
            irisConfig.initialize();
        }
        catch (IOException iOException) {
            logger.error("Failed to initialize Iris configuration, default values will be used instead");
            logger.error("", iOException);
        }
        updateChecker.checkForUpdates(irisConfig);
        this.setupCommands(class_310.method_1551());
        initialized = true;
    }

    private void setupCommands(class_310 class_3102) {
    }

    public static void onRenderSystemInit() {
        if (!initialized) {
            logger.warn("Iris::onRenderSystemInit was called, but Iris::onEarlyInitialize was not called. Trying to avoid a crash but this is an odd state.");
            return;
        }
        PBRTextureManager.INSTANCE.init();
        Iris.loadShaderpack();
    }

    public static void duringRenderSystemInit() {
        Iris.setDebug(irisConfig.areDebugOptionsEnabled());
    }

    public static void onLoadingComplete() {
        if (!initialized) {
            logger.warn("Iris::onLoadingComplete was called, but Iris::onEarlyInitialize was not called. Trying to avoid a crash but this is an odd state.");
            return;
        }
        lastDimension = DimensionId.OVERWORLD;
        Iris.getPipelineManager().preparePipeline(DimensionId.OVERWORLD);
    }

    public static void handleKeybinds(class_310 class_3102) {
        block11: {
            if (reloadKeybind.method_1436()) {
                try {
                    Iris.reload();
                    if (class_3102.field_1724 != null) {
                        class_3102.field_1724.method_7353((class_2561)class_2561.method_43471((String)"iris.shaders.reloaded"), false);
                    }
                    break block11;
                }
                catch (Exception exception) {
                    logger.error("Error while reloading Shaders for Iris!", exception);
                    if (class_3102.field_1724 != null) {
                        class_3102.field_1724.method_7353((class_2561)class_2561.method_43469((String)"iris.shaders.reloaded.failure", (Object[])new Object[]{Throwables.getRootCause((Throwable)exception).getMessage()}).method_27692(class_124.field_1061), false);
                    }
                    break block11;
                }
            }
            if (toggleShadersKeybind.method_1436()) {
                try {
                    Iris.toggleShaders(class_3102, !irisConfig.areShadersEnabled());
                }
                catch (Exception exception) {
                    logger.error("Error while toggling shaders!", exception);
                    if (class_3102.field_1724 != null) {
                        class_3102.field_1724.method_7353((class_2561)class_2561.method_43469((String)"iris.shaders.toggled.failure", (Object[])new Object[]{Throwables.getRootCause((Throwable)exception).getMessage()}).method_27692(class_124.field_1061), false);
                    }
                    Iris.setShadersDisabled();
                    fallback = true;
                }
            } else if (shaderpackScreenKeybind.method_1436()) {
                class_3102.method_1507((class_437)new ShaderPackScreen(null));
            }
        }
    }

    public static void toggleShaders(class_310 class_3102, boolean bl) throws IOException {
        irisConfig.setShadersEnabled(bl);
        irisConfig.save();
        Iris.reload();
        if (class_3102.field_1724 != null) {
            class_3102.field_1724.method_7353((class_2561)(bl ? class_2561.method_43469((String)"iris.shaders.toggled", (Object[])new Object[]{currentPackName}) : class_2561.method_43471((String)"iris.shaders.disabled")), false);
        }
    }

    public static void loadShaderpack() {
        if (irisConfig == null) {
            if (!initialized) {
                throw new IllegalStateException("Iris::loadShaderpack was called, but Iris::onInitializeClient wasn't called yet. How did this happen?");
            }
            throw new NullPointerException("Iris.irisConfig was null unexpectedly");
        }
        if (!irisConfig.areShadersEnabled()) {
            logger.info("Shaders are disabled because enableShaders is set to false in iris.properties");
            Iris.setShadersDisabled();
            return;
        }
        Optional<String> optional = irisConfig.getShaderPackName();
        if (optional.isEmpty()) {
            logger.info("Shaders are disabled because no valid shaderpack is selected");
            Iris.setShadersDisabled();
            return;
        }
        if (!Iris.loadExternalShaderpack(optional.get())) {
            logger.warn("Falling back to normal rendering without shaders because the shaderpack could not be loaded");
            Iris.setShadersDisabled();
            fallback = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadExternalShaderpack(String string2) {
        Path path;
        Object object;
        Path path2;
        Path path3;
        try {
            path3 = Iris.getShaderpacksDirectory().resolve(string2);
            path2 = Iris.getShaderpacksDirectory().resolve(string2 + ".txt");
        }
        catch (InvalidPathException invalidPathException) {
            logger.error("Failed to load the shaderpack \"{}\" because it contains invalid characters in its path", string2);
            return false;
        }
        if (!Iris.isValidShaderpack(path3)) {
            logger.error("Pack \"{}\" is not valid! Can't load it.", string2);
            return false;
        }
        if (!Files.isDirectory(path3, new LinkOption[0]) && path3.toString().endsWith(".zip")) {
            try {
                object = Iris.loadExternalZipShaderpack(path3);
            }
            catch (FileSystemNotFoundException | NoSuchFileException exception) {
                logger.error("Failed to load the shaderpack \"{}\" because it does not exist in your shaderpacks folder!", string2);
                return false;
            }
            catch (ZipException zipException) {
                logger.error("The shaderpack \"{}\" appears to be corrupted, please try downloading it again!", string2);
                return false;
            }
            catch (IOException iOException) {
                logger.error("Failed to load the shaderpack \"{}\"!", string2);
                logger.error("", iOException);
                return false;
            }
            if (!((Optional)object).isPresent()) {
                logger.error("Could not load the shaderpack \"{}\" because it appears to lack a \"shaders\" directory", string2);
                return false;
            }
            path = ((Optional)object).get();
        } else {
            if (!Files.exists(path3, new LinkOption[0])) {
                logger.error("Failed to load the shaderpack \"{}\" because it does not exist!", string2);
                return false;
            }
            path = path3.resolve("shaders");
        }
        if (!Files.exists(path, new LinkOption[0])) {
            logger.error("Could not load the shaderpack \"{}\" because it appears to lack a \"shaders\" directory", string2);
            return false;
        }
        object = Iris.tryReadConfigProperties(path2).map(properties -> properties).orElse(new HashMap());
        object.putAll(shaderPackOptionQueue);
        Iris.clearShaderPackOptionQueue();
        if (resetShaderPackOptions) {
            object.clear();
        }
        resetShaderPackOptions = false;
        try {
            currentPack = new ShaderPack(path, (Map<String, String>)object, StandardMacros.createStandardEnvironmentDefines());
            MutableOptionValues mutableOptionValues = currentPack.getShaderPackOptions().getOptionValues().mutableCopy();
            Properties properties2 = new Properties();
            mutableOptionValues.getBooleanValues().forEach((string, bl) -> properties2.setProperty((String)string, Boolean.toString(bl)));
            mutableOptionValues.getStringValues().forEach(properties2::setProperty);
            Iris.tryUpdateConfigPropertiesFile(path2, properties2);
        }
        catch (Exception exception) {
            logger.error("Failed to load the shaderpack \"{}\"!", string2);
            logger.error("", exception);
            return false;
        }
        fallback = false;
        currentPackName = string2;
        logger.info("Using shaderpack: " + string2);
        return true;
    }

    private static Optional<Path> loadExternalZipShaderpack(Path path2) throws IOException {
        FileSystem fileSystem;
        zipFileSystem = fileSystem = FileSystems.newFileSystem(path2, Iris.class.getClassLoader());
        Path path3 = fileSystem.getRootDirectories().iterator().next();
        Path path4 = fileSystem.getPath("shaders", new String[0]);
        if (Files.exists(path4, new LinkOption[0])) {
            return Optional.of(path4);
        }
        try (Stream<Path> stream = Files.walk(path3, new FileVisitOption[0]);){
            Optional<Path> optional = stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).filter(path -> path.endsWith("shaders")).findFirst();
            return optional;
        }
    }

    private static void setShadersDisabled() {
        currentPack = null;
        fallback = false;
        currentPackName = "(off)";
        logger.info("Shaders are disabled");
    }

    public static void setDebug(boolean bl) {
        int n;
        if (bl) {
            n = GLDebug.setupDebugMessageCallback();
        } else {
            class_1008.method_4227((int)class_310.method_1551().field_1690.field_1901, (boolean)false);
            n = 1;
        }
        logger.info("Debug functionality is " + (bl ? "enabled, logging will be more verbose!" : "disabled."));
        if (class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)(n != 0 ? (bl ? "iris.shaders.debug.enabled" : "iris.shaders.debug.disabled") : "iris.shaders.debug.failure")), false);
            if (n == 2) {
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"iris.shaders.debug.restart"), false);
            }
        }
        try {
            irisConfig.setDebugEnabled(bl);
            irisConfig.save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static Optional<Properties> tryReadConfigProperties(Path path) {
        Properties properties = new Properties();
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                return Optional.empty();
            }
        }
        return Optional.of(properties);
    }

    private static void tryUpdateConfigPropertiesFile(Path path, Properties properties) {
        try {
            if (properties.isEmpty()) {
                if (Files.exists(path, new LinkOption[0])) {
                    Files.delete(path);
                }
                return;
            }
            try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
                properties.store(outputStream, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isValidToShowPack(Path path) {
        return Files.isDirectory(path, new LinkOption[0]) || path.toString().endsWith(".zip");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidShaderpack(Path path3) {
        if (Files.isDirectory(path3, new LinkOption[0])) {
            if (path3.equals(Iris.getShaderpacksDirectory())) {
                return false;
            }
            try (Stream<Path> stream = Files.walk(path3, new FileVisitOption[0]);){
                boolean bl = stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).filter(path2 -> !path2.equals(path3)).anyMatch(path -> path.endsWith("shaders"));
                return bl;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (path3.toString().endsWith(".zip")) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(path3, Iris.class.getClassLoader());){
                boolean bl;
                block26: {
                    Path path4 = fileSystem.getRootDirectories().iterator().next();
                    Stream<Path> stream = Files.walk(path4, new FileVisitOption[0]);
                    try {
                        bl = stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).anyMatch(path -> path.endsWith("shaders"));
                        if (stream == null) break block26;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stream.close();
                }
                return bl;
            }
            catch (ZipError zipError) {
                logger.warn("The ZIP at " + String.valueOf(path3) + " is corrupt");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Map<String, String> getShaderPackOptionQueue() {
        return shaderPackOptionQueue;
    }

    public static void queueShaderPackOptionsFromProfile(Profile profile) {
        Iris.getShaderPackOptionQueue().putAll(profile.optionValues);
    }

    public static void queueShaderPackOptionsFromProperties(Properties properties) {
        Iris.queueDefaultShaderPackOptionValues();
        properties.stringPropertyNames().forEach(string -> Iris.getShaderPackOptionQueue().put((String)string, properties.getProperty((String)string)));
    }

    public static void queueDefaultShaderPackOptionValues() {
        Iris.clearShaderPackOptionQueue();
        Iris.getCurrentPack().ifPresent(shaderPack -> {
            OptionSet optionSet = shaderPack.getShaderPackOptions().getOptionSet();
            OptionValues optionValues = shaderPack.getShaderPackOptions().getOptionValues();
            optionSet.getStringOptions().forEach((string, mergedStringOption) -> {
                if (optionValues.getStringValue((String)string).isPresent()) {
                    Iris.getShaderPackOptionQueue().put((String)string, mergedStringOption.getOption().getDefaultValue());
                }
            });
            optionSet.getBooleanOptions().forEach((string, mergedBooleanOption) -> {
                if (optionValues.getBooleanValue((String)string) != OptionalBoolean.DEFAULT) {
                    Iris.getShaderPackOptionQueue().put((String)string, Boolean.toString(mergedBooleanOption.getOption().getDefaultValue()));
                }
            });
        });
    }

    public static void clearShaderPackOptionQueue() {
        Iris.getShaderPackOptionQueue().clear();
    }

    public static void resetShaderPackOptionsOnNextReload() {
        resetShaderPackOptions = true;
    }

    public static boolean shouldResetShaderPackOptionsOnNextReload() {
        return resetShaderPackOptions;
    }

    public static void reload() throws IOException {
        irisConfig.initialize();
        Iris.destroyEverything();
        Iris.loadShaderpack();
        if (class_310.method_1551().field_1687 != null) {
            Iris.getPipelineManager().preparePipeline(Iris.getCurrentDimension());
        }
    }

    private static void destroyEverything() {
        currentPack = null;
        Iris.getPipelineManager().destroyPipeline();
        if (zipFileSystem != null) {
            try {
                zipFileSystem.close();
            }
            catch (NoSuchFileException noSuchFileException) {
                logger.warn("Failed to close the shaderpack zip when reloading because it was deleted, proceeding anyways.");
            }
            catch (IOException iOException) {
                logger.error("Failed to close zip file system?", iOException);
            }
        }
    }

    public static NamespacedId getCurrentDimension() {
        class_638 class_6382 = class_310.method_1551().field_1687;
        if (class_6382 != null) {
            return new NamespacedId(class_6382.method_27983().method_29177().method_12836(), class_6382.method_27983().method_29177().method_12832());
        }
        return lastDimension;
    }

    private static WorldRenderingPipeline createPipeline(NamespacedId namespacedId) {
        if (currentPack == null) {
            return new FixedFunctionWorldRenderingPipeline();
        }
        ProgramSet programSet = currentPack.getProgramSet(namespacedId);
        try {
            return new NewWorldRenderingPipeline(programSet);
        }
        catch (Exception exception) {
            if (irisConfig.areDebugOptionsEnabled()) {
                class_310.method_1551().method_1507((class_437)new DebugLoadFailedGridScreen(class_310.method_1551().field_1755, (class_2561)class_2561.method_43470((String)(exception instanceof ShaderCompileException ? "Failed to compile shaders" : "Exception")), exception));
            } else if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)(exception instanceof ShaderCompileException ? "iris.load.failure.shader" : "iris.load.failure.generic")).method_10852((class_2561)class_2561.method_43470((String)"Copy Info").method_27694(class_25832 -> class_25832.method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1078).method_10958(new class_2558(class_2558.class_2559.field_21462, exception.getMessage())))), false);
            } else {
                storedError = Optional.of(exception);
            }
            logger.error("Failed to create shader rendering pipeline, disabling shaders!", exception);
            fallback = true;
            return new FixedFunctionWorldRenderingPipeline();
        }
    }

    @NotNull
    public static PipelineManager getPipelineManager() {
        if (pipelineManager == null) {
            pipelineManager = new PipelineManager(Iris::createPipeline);
        }
        return pipelineManager;
    }

    public static Optional<Exception> getStoredError() {
        Optional<Exception> optional = storedError;
        storedError = Optional.empty();
        return optional;
    }

    @NotNull
    public static Optional<ShaderPack> getCurrentPack() {
        return Optional.ofNullable(currentPack);
    }

    public static String getCurrentPackName() {
        return currentPackName;
    }

    public static IrisConfig getIrisConfig() {
        return irisConfig;
    }

    public static UpdateChecker getUpdateChecker() {
        return updateChecker;
    }

    public static boolean isFallback() {
        return fallback;
    }

    public static String getVersion() {
        if (IRIS_VERSION == null) {
            return "Version info unknown!";
        }
        return IRIS_VERSION.getFriendlyString();
    }

    public static String getFormattedVersion() {
        class_124 class_1242;
        String string = Iris.getVersion();
        if (string.endsWith("-development-environment")) {
            class_1242 = class_124.field_1065;
            string = string.replace("-development-environment", " (Development Environment)");
        } else {
            class_1242 = string.endsWith("-dirty") || string.contains("unknown") || string.endsWith("-nogit") ? class_124.field_1061 : (string.contains("+rev.") ? class_124.field_1076 : class_124.field_1060);
        }
        return String.valueOf(class_1242) + string;
    }

    public static String getReleaseTarget() {
        return class_155.method_16673().method_48022() ? class_155.method_16673().method_48019() : backupVersionNumber;
    }

    public static String getBackupVersionNumber() {
        return backupVersionNumber;
    }

    public static Path getShaderpacksDirectory() {
        if (shaderpacksDirectory == null) {
            shaderpacksDirectory = FabricLoader.getInstance().getGameDir().resolve("shaderpacks");
        }
        return shaderpacksDirectory;
    }

    public static ShaderpackDirectoryManager getShaderpacksDirectoryManager() {
        if (shaderpacksDirectoryManager == null) {
            shaderpacksDirectoryManager = new ShaderpackDirectoryManager(Iris.getShaderpacksDirectory());
        }
        return shaderpacksDirectoryManager;
    }

    static {
        storedError = Optional.empty();
        shaderPackOptionQueue = new HashMap<String, String>();
        resetShaderPackOptions = false;
        backupVersionNumber = "1.20.3";
        lastDimension = null;
    }
}

