/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.image;

import com.mojang.blaze3d.platform.GlStateManager;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.PixelFormat;
import net.coderbot.iris.gl.texture.PixelType;
import net.coderbot.iris.gl.texture.TextureType;
import org.lwjgl.opengl.ARBClearTexture;

public class GlImage
extends GlResource {
    protected final String name;
    protected final String samplerName;
    protected final TextureType target;
    protected final PixelFormat format;
    protected final InternalTextureFormat internalTextureFormat;
    protected final PixelType pixelType;
    private final boolean clear;

    public GlImage(String string, String string2, TextureType textureType, PixelFormat pixelFormat, InternalTextureFormat internalTextureFormat, PixelType pixelType, boolean bl, int n, int n2, int n3) {
        super(IrisRenderSystem.createTexture(textureType.getGlType()));
        this.name = string;
        this.samplerName = string2;
        this.target = textureType;
        this.format = pixelFormat;
        this.internalTextureFormat = internalTextureFormat;
        this.pixelType = pixelType;
        this.clear = bl;
        IrisRenderSystem.bindTextureForSetup(textureType.getGlType(), this.getGlId());
        textureType.apply(this.getGlId(), n, n2, n3, internalTextureFormat.getGlFormat(), pixelFormat.getGlFormat(), pixelType.getGlFormat(), null);
        int n4 = this.getGlId();
        this.setup(n4, n, n2, n3);
        IrisRenderSystem.bindTextureForSetup(textureType.getGlType(), 0);
    }

    protected void setup(int n, int n2, int n3, int n4) {
        boolean bl = this.internalTextureFormat.getPixelFormat().isInteger();
        IrisRenderSystem.texParameteri(n, this.target.getGlType(), 10241, bl ? 9728 : 9729);
        IrisRenderSystem.texParameteri(n, this.target.getGlType(), 10240, bl ? 9728 : 9729);
        IrisRenderSystem.texParameteri(n, this.target.getGlType(), 10242, 33071);
        if (n3 > 0) {
            IrisRenderSystem.texParameteri(n, this.target.getGlType(), 10243, 33071);
        }
        if (n4 > 0) {
            IrisRenderSystem.texParameteri(n, this.target.getGlType(), 32882, 33071);
        }
        IrisRenderSystem.texParameteri(n, this.target.getGlType(), 33085, 0);
        IrisRenderSystem.texParameteri(n, this.target.getGlType(), 33082, 0);
        IrisRenderSystem.texParameteri(n, this.target.getGlType(), 33083, 0);
        IrisRenderSystem.texParameterf(n, this.target.getGlType(), 34049, 0.0f);
        ARBClearTexture.glClearTexImage((int)n, (int)0, (int)this.format.getGlFormat(), (int)this.pixelType.getGlFormat(), (int[])null);
    }

    public String getName() {
        return this.name;
    }

    public String getSamplerName() {
        return this.samplerName;
    }

    public TextureType getTarget() {
        return this.target;
    }

    public boolean shouldClear() {
        return this.clear;
    }

    public int getId() {
        return this.getGlId();
    }

    public void updateNewSize(int n, int n2) {
    }

    @Override
    protected void destroyInternal() {
        GlStateManager._deleteTexture((int)this.getGlId());
    }

    public InternalTextureFormat getInternalFormat() {
        return this.internalTextureFormat;
    }

    public String toString() {
        return "GlImage name " + this.name + " format " + String.valueOf((Object)this.format) + "internalformat " + String.valueOf((Object)this.internalTextureFormat) + " pixeltype " + String.valueOf((Object)this.pixelType);
    }

    public PixelFormat getFormat() {
        return this.format;
    }

    public PixelType getPixelType() {
        return this.pixelType;
    }

    public static class Relative
    extends GlImage {
        private final float relativeHeight;
        private final float relativeWidth;

        public Relative(String string, String string2, PixelFormat pixelFormat, InternalTextureFormat internalTextureFormat, PixelType pixelType, boolean bl, float f, float f2, int n, int n2) {
            super(string, string2, TextureType.TEXTURE_2D, pixelFormat, internalTextureFormat, pixelType, bl, (int)((float)n * f), (int)((float)n2 * f2), 0);
            this.relativeWidth = f;
            this.relativeHeight = f2;
        }

        @Override
        public void updateNewSize(int n, int n2) {
            IrisRenderSystem.bindTextureForSetup(this.target.getGlType(), this.getGlId());
            this.target.apply(this.getGlId(), (int)((float)n * this.relativeWidth), (int)((float)n2 * this.relativeHeight), 0, this.internalTextureFormat.getGlFormat(), this.format.getGlFormat(), this.pixelType.getGlFormat(), null);
            int n3 = this.getGlId();
            this.setup(n3, n, n2, 0);
            IrisRenderSystem.bindTextureForSetup(this.target.getGlType(), 0);
        }
    }
}

