/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.texture.GlTexture;
import net.coderbot.iris.gl.texture.TextureAccess;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.gl.texture.TextureWrapper;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.mixin.LightTextureAccessor;
import net.coderbot.iris.rendertarget.NativeImageBackedCustomTexture;
import net.coderbot.iris.rendertarget.NativeImageBackedNoiseTexture;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.texture.CustomTextureData;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.pbr.PBRTextureHolder;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.coderbot.iris.texture.pbr.PBRType;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1060;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.io.FilenameUtils;

public class CustomTextureManager {
    private final EnumMap<TextureStage, Object2ObjectMap<String, TextureAccess>> customTextureIdMap = new EnumMap(TextureStage.class);
    private final Object2ObjectMap<String, TextureAccess> irisCustomTextures = new Object2ObjectOpenHashMap();
    private final TextureAccess noise;
    private final List<class_1044> ownedTextures = new ArrayList<class_1044>();
    private final List<GlTexture> ownedRawTextures = new ArrayList<GlTexture>();

    public CustomTextureManager(PackDirectives packDirectives, EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> enumMap, Object2ObjectMap<String, CustomTextureData> object2ObjectMap2, Optional<CustomTextureData> optional) {
        enumMap.forEach((textureStage, object2ObjectMap) -> {
            Object2ObjectOpenHashMap object2ObjectOpenHashMap = new Object2ObjectOpenHashMap();
            object2ObjectMap.forEach((arg_0, arg_1) -> this.lambda$new$0((Object2ObjectMap)object2ObjectOpenHashMap, textureStage, arg_0, arg_1));
            this.customTextureIdMap.put((TextureStage)((Object)textureStage), (Object2ObjectMap<String, TextureAccess>)object2ObjectOpenHashMap);
        });
        object2ObjectMap2.forEach((string, customTextureData) -> {
            try {
                this.irisCustomTextures.put(string, (Object)this.createCustomTexture((CustomTextureData)customTextureData));
            }
            catch (IOException iOException) {
                Iris.logger.error("Unable to parse the image data for the custom texture on sampler " + string, iOException);
            }
        });
        this.noise = optional.flatMap(customTextureData -> {
            try {
                return Optional.of(this.createCustomTexture((CustomTextureData)customTextureData));
            }
            catch (IOException | class_151 throwable) {
                Iris.logger.error("Unable to parse the image data for the custom noise texture", throwable);
                return Optional.empty();
            }
        }).orElseGet(() -> {
            int n = packDirectives.getNoiseTextureResolution();
            NativeImageBackedNoiseTexture nativeImageBackedNoiseTexture = new NativeImageBackedNoiseTexture(n);
            this.ownedTextures.add((class_1044)nativeImageBackedNoiseTexture);
            return nativeImageBackedNoiseTexture;
        });
    }

    private TextureAccess createCustomTexture(CustomTextureData customTextureData) throws IOException, class_151 {
        if (customTextureData instanceof CustomTextureData.PngData) {
            NativeImageBackedCustomTexture nativeImageBackedCustomTexture = new NativeImageBackedCustomTexture((CustomTextureData.PngData)customTextureData);
            this.ownedTextures.add((class_1044)nativeImageBackedCustomTexture);
            return nativeImageBackedCustomTexture;
        }
        if (customTextureData instanceof CustomTextureData.LightmapMarker) {
            return new TextureWrapper(() -> ((class_1043)((LightTextureAccessor)class_310.method_1551().field_1773.method_22974()).getLightTexture()).method_4624(), TextureType.TEXTURE_2D);
        }
        if (customTextureData instanceof CustomTextureData.RawData1D) {
            CustomTextureData.RawData1D rawData1D = (CustomTextureData.RawData1D)customTextureData;
            GlTexture glTexture = new GlTexture(TextureType.TEXTURE_1D, rawData1D.getSizeX(), 0, 0, rawData1D.getInternalFormat().getGlFormat(), rawData1D.getPixelFormat().getGlFormat(), rawData1D.getPixelType().getGlFormat(), rawData1D.getContent(), rawData1D.getFilteringData());
            this.ownedRawTextures.add(glTexture);
            return glTexture;
        }
        if (customTextureData instanceof CustomTextureData.RawDataRect) {
            CustomTextureData.RawDataRect rawDataRect = (CustomTextureData.RawDataRect)customTextureData;
            GlTexture glTexture = new GlTexture(TextureType.TEXTURE_RECTANGLE, rawDataRect.getSizeX(), rawDataRect.getSizeY(), 0, rawDataRect.getInternalFormat().getGlFormat(), rawDataRect.getPixelFormat().getGlFormat(), rawDataRect.getPixelType().getGlFormat(), rawDataRect.getContent(), rawDataRect.getFilteringData());
            this.ownedRawTextures.add(glTexture);
            return glTexture;
        }
        if (customTextureData instanceof CustomTextureData.RawData2D) {
            CustomTextureData.RawData2D rawData2D = (CustomTextureData.RawData2D)customTextureData;
            GlTexture glTexture = new GlTexture(TextureType.TEXTURE_2D, rawData2D.getSizeX(), rawData2D.getSizeY(), 0, rawData2D.getInternalFormat().getGlFormat(), rawData2D.getPixelFormat().getGlFormat(), rawData2D.getPixelType().getGlFormat(), rawData2D.getContent(), rawData2D.getFilteringData());
            this.ownedRawTextures.add(glTexture);
            return glTexture;
        }
        if (customTextureData instanceof CustomTextureData.RawData3D) {
            CustomTextureData.RawData3D rawData3D = (CustomTextureData.RawData3D)customTextureData;
            GlTexture glTexture = new GlTexture(TextureType.TEXTURE_3D, rawData3D.getSizeX(), rawData3D.getSizeY(), rawData3D.getSizeZ(), rawData3D.getInternalFormat().getGlFormat(), rawData3D.getPixelFormat().getGlFormat(), rawData3D.getPixelType().getGlFormat(), rawData3D.getContent(), rawData3D.getFilteringData());
            this.ownedRawTextures.add(glTexture);
            return glTexture;
        }
        if (customTextureData instanceof CustomTextureData.ResourceData) {
            CustomTextureData.ResourceData resourceData = (CustomTextureData.ResourceData)customTextureData;
            String string = resourceData.getNamespace();
            Object object = resourceData.getLocation();
            int n = FilenameUtils.indexOfExtension((String)object);
            Object object2 = n != -1 ? ((String)object).substring(0, n) : object;
            PBRType pBRType = PBRType.fromFileLocation((String)object2);
            class_1060 class_10602 = class_310.method_1551().method_1531();
            if (pBRType == null) {
                class_2960 class_29602 = new class_2960(string, (String)object);
                return new TextureWrapper(() -> {
                    class_1044 class_10442 = class_10602.method_4619(class_29602);
                    return class_10442 != null ? class_10442.method_4624() : class_1047.method_4540().method_4624();
                }, TextureType.TEXTURE_2D);
            }
            object = ((String)object).substring(0, n - pBRType.getSuffix().length()) + ((String)object).substring(n);
            class_2960 class_29603 = new class_2960(string, (String)object);
            return new TextureWrapper(() -> {
                class_1044 class_10442 = class_10602.method_4619(class_29603);
                if (class_10442 != null) {
                    int n = class_10442.method_4624();
                    PBRTextureHolder pBRTextureHolder = PBRTextureManager.INSTANCE.getOrLoadHolder(n);
                    class_1044 class_10443 = switch (pBRType) {
                        case PBRType.NORMAL -> pBRTextureHolder.getNormalTexture();
                        case PBRType.SPECULAR -> pBRTextureHolder.getSpecularTexture();
                        default -> throw new Error("Unknown PBRType '" + String.valueOf((Object)pBRType) + "'");
                    };
                    TextureFormat textureFormat = TextureFormatLoader.getFormat();
                    if (textureFormat != null) {
                        int n2 = GlStateManagerAccessor.getTEXTURES()[GlStateManagerAccessor.getActiveTexture()].field_5167;
                        GlStateManager._bindTexture((int)class_10443.method_4624());
                        textureFormat.setupTextureParameters(pBRType, class_10443);
                        GlStateManager._bindTexture((int)n2);
                    }
                    return class_10443.method_4624();
                }
                return class_1047.method_4540().method_4624();
            }, TextureType.TEXTURE_2D);
        }
        throw new IllegalArgumentException("Don't know texture type!");
    }

    public EnumMap<TextureStage, Object2ObjectMap<String, TextureAccess>> getCustomTextureIdMap() {
        return this.customTextureIdMap;
    }

    public Object2ObjectMap<String, TextureAccess> getCustomTextureIdMap(TextureStage textureStage) {
        return this.customTextureIdMap.getOrDefault((Object)textureStage, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap());
    }

    public Object2ObjectMap<String, TextureAccess> getIrisCustomTextures() {
        return this.irisCustomTextures;
    }

    public TextureAccess getNoiseTexture() {
        return this.noise;
    }

    public void destroy() {
        this.ownedTextures.forEach(class_1044::close);
        this.ownedRawTextures.forEach(GlResource::destroy);
    }

    private /* synthetic */ void lambda$new$0(Object2ObjectMap object2ObjectMap, TextureStage textureStage, String string, CustomTextureData customTextureData) {
        try {
            object2ObjectMap.put((Object)string, (Object)this.createCustomTexture(customTextureData));
        }
        catch (IOException | class_151 throwable) {
            Iris.logger.error("Unable to parse the image data for the custom texture on stage " + String.valueOf((Object)textureStage) + ", sampler " + string, throwable);
        }
    }
}

