/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.block_rendering.BlockMaterialMapping;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.compat.dh.DHCompat;
import net.coderbot.iris.features.FeatureFlags;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gbuffer_overrides.matching.ProgramTable;
import net.coderbot.iris.gbuffer_overrides.matching.RenderCondition;
import net.coderbot.iris.gbuffer_overrides.matching.SpecialCondition;
import net.coderbot.iris.gbuffer_overrides.state.RenderTargetStateListener;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.AlphaTestOverride;
import net.coderbot.iris.gl.blending.AlphaTestStorage;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.blending.BufferBlendOverride;
import net.coderbot.iris.gl.buffer.ShaderStorageBufferHolder;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.ComputeProgram;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.shader.ShaderCompileException;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.pipeline.ClearPassCreator;
import net.coderbot.iris.pipeline.CustomTextureManager;
import net.coderbot.iris.pipeline.HandRenderer;
import net.coderbot.iris.pipeline.HorizonRenderer;
import net.coderbot.iris.pipeline.ShaderPrinter;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.postprocess.BufferFlipper;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.CompositeRenderer;
import net.coderbot.iris.postprocess.FinalPassRenderer;
import net.coderbot.iris.rendertarget.Blaze3dRenderTargetExt;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.CloudSetting;
import net.coderbot.iris.shaderpack.ComputeSource;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ParticleRenderingSettings;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramFallbackResolver;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.loading.ProgramId;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.ShadowCompositeRenderer;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.texture.TextureInfoCache;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.pbr.PBRTextureHolder;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.minecraft.class_1044;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5294;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector4f;

public class DeferredWorldRenderingPipeline
implements WorldRenderingPipeline,
RenderTargetStateListener {
    private final RenderTargets renderTargets;
    private final ShadowCompositeRenderer shadowCompositeRenderer;
    @Nullable
    private ShadowRenderTargets shadowRenderTargets;
    @Nullable
    private ComputeProgram[] shadowComputes;
    private final Supplier<ShadowRenderTargets> shadowTargetsSupplier;
    private final ProgramTable<Pass> table;
    private ImmutableList<ClearPass> clearPassesFull;
    private ImmutableList<ClearPass> clearPasses;
    private ImmutableList<ClearPass> shadowClearPasses;
    private ImmutableList<ClearPass> shadowClearPassesFull;
    private final CompositeRenderer prepareRenderer;
    @Nullable
    private final ShadowRenderer shadowRenderer;
    private final int shadowMapResolution;
    private final CompositeRenderer deferredRenderer;
    private final CompositeRenderer compositeRenderer;
    private final FinalPassRenderer finalPassRenderer;
    private final CustomTextureManager customTextureManager;
    private final class_1044 whitePixel;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final ImmutableSet<Integer> flippedBeforeShadow;
    private final ImmutableSet<Integer> flippedAfterPrepare;
    private final ImmutableSet<Integer> flippedAfterTranslucent;
    private final SodiumTerrainPipeline sodiumTerrainPipeline;
    private final HorizonRenderer horizonRenderer = new HorizonRenderer();
    private final float sunPathRotation;
    private final CloudSetting cloudSetting;
    private final boolean shouldRenderUnderwaterOverlay;
    private final boolean shouldRenderVignette;
    private final boolean shouldRenderSun;
    private final boolean shouldRenderMoon;
    private final boolean shouldWriteRainAndSnowToDepthBuffer;
    private final boolean shouldRenderParticlesBeforeDeferred;
    private final boolean shouldRenderPrepareBeforeShadow;
    private final boolean oldLighting;
    private final boolean allowConcurrentCompute;
    private final OptionalInt forcedShadowRenderDistanceChunks;
    private Pass current = null;
    private WorldRenderingPhase overridePhase = null;
    private WorldRenderingPhase phase = WorldRenderingPhase.NONE;
    private boolean isBeforeTranslucent;
    private boolean isRenderingShadow = false;
    private InputAvailability inputs = new InputAvailability(false, false, false);
    private SpecialCondition special = null;
    private ShaderStorageBufferHolder shaderStorageBufferHolder;
    private boolean showSSBOError = false;
    private boolean shouldBindPBR;
    private int currentNormalTexture;
    private int currentSpecularTexture;
    private PackDirectives packDirectives;
    private final CustomUniforms customUniforms;
    private Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> customTextureMap;
    private ParticleRenderingSettings particleRenderingSettings;
    private boolean isPostChain;
    private boolean isMainBound = true;
    private boolean isRenderingWorld = false;
    private boolean isRenderingFullScreenPass = false;
    boolean sodiumTerrainRendering = false;

    public DeferredWorldRenderingPipeline(ProgramSet programSet) {
        Object object;
        Objects.requireNonNull(programSet);
        this.cloudSetting = programSet.getPackDirectives().getCloudSetting();
        this.shouldRenderUnderwaterOverlay = programSet.getPackDirectives().underwaterOverlay();
        this.shouldRenderVignette = programSet.getPackDirectives().vignette();
        this.shouldRenderSun = programSet.getPackDirectives().shouldRenderSun();
        this.shouldRenderMoon = programSet.getPackDirectives().shouldRenderMoon();
        this.shouldWriteRainAndSnowToDepthBuffer = programSet.getPackDirectives().rainDepth();
        this.shouldRenderParticlesBeforeDeferred = false;
        this.allowConcurrentCompute = programSet.getPackDirectives().getConcurrentCompute();
        this.shouldRenderPrepareBeforeShadow = programSet.getPackDirectives().isPrepareBeforeShadow();
        this.oldLighting = programSet.getPackDirectives().isOldLighting();
        this.updateNotifier = new FrameUpdateNotifier();
        this.customTextureMap = programSet.getPackDirectives().getTextureMap();
        this.packDirectives = programSet.getPackDirectives();
        this.particleRenderingSettings = programSet.getPackDirectives().getParticleRenderingSettings().orElseGet(() -> {
            if (programSet.getDeferred().length > 0) {
                return ParticleRenderingSettings.AFTER;
            }
            return ParticleRenderingSettings.MIXED;
        });
        if (!programSet.getPackDirectives().getBufferObjects().isEmpty()) {
            if (IrisRenderSystem.supportsSSBO()) {
                this.shaderStorageBufferHolder.setupBuffers();
            } else {
                Iris.logger.fatal("Shader storage buffers/immutable buffer storage is not supported on this graphics card, however the shaderpack requested them? Let's hope it's not a problem.");
                this.showSSBOError = true;
                for (var2_2 = 0; var2_2 < 16; ++var2_2) {
                    IrisRenderSystem.bindBufferBase(37074, var2_2, var2_2);
                }
            }
        } else {
            for (var2_2 = 0; var2_2 < 16; ++var2_2) {
                IrisRenderSystem.bindBufferBase(37074, var2_2, var2_2);
            }
        }
        class_276 class_2762 = class_310.method_1551().method_1522();
        int n2 = class_2762.method_30278();
        int n3 = TextureInfoCache.INSTANCE.getInfo(n2).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(n3);
        this.renderTargets = new RenderTargets(class_2762.field_1482, class_2762.field_1481, n2, ((Blaze3dRenderTargetExt)class_2762).iris$getDepthBufferVersion(), depthBufferFormat, programSet.getPackDirectives().getRenderTargetDirectives().getRenderTargetSettings(), programSet.getPackDirectives());
        this.sunPathRotation = programSet.getPackDirectives().getSunPathRotation();
        PackShadowDirectives packShadowDirectives = programSet.getPackDirectives().getShadowDirectives();
        this.forcedShadowRenderDistanceChunks = packShadowDirectives.isDistanceRenderMulExplicit() ? ((double)packShadowDirectives.getDistanceRenderMul() >= 0.0 ? OptionalInt.of(((int)(packShadowDirectives.getDistance() * packShadowDirectives.getDistanceRenderMul()) + 15) / 16) : OptionalInt.of(-1)) : OptionalInt.empty();
        BlockRenderingSettings.INSTANCE.setBlockStateIds(BlockMaterialMapping.createBlockStateIdMap(programSet.getPack().getIdMap().getBlockProperties()));
        BlockRenderingSettings.INSTANCE.setBlockTypeIds(BlockMaterialMapping.createBlockTypeMap(programSet.getPack().getIdMap().getBlockRenderTypeMap()));
        BlockRenderingSettings.INSTANCE.setEntityIds(programSet.getPack().getIdMap().getEntityIdMap());
        BlockRenderingSettings.INSTANCE.setAmbientOcclusionLevel(programSet.getPackDirectives().getAmbientOcclusionLevel());
        BlockRenderingSettings.INSTANCE.setDisableDirectionalShading(this.shouldDisableDirectionalShading());
        BlockRenderingSettings.INSTANCE.setUseSeparateAo(programSet.getPackDirectives().shouldUseSeparateAo());
        BlockRenderingSettings.INSTANCE.setUseExtendedVertexFormat(true);
        GlStateManager.glActiveTexture((int)33986);
        this.customTextureManager = new CustomTextureManager(programSet.getPackDirectives(), programSet.getPack().getCustomTextureDataMap(), programSet.getPack().getIrisCustomTextureDataMap(), programSet.getPack().getCustomNoiseTexture());
        this.whitePixel = new NativeImageBackedSingleColorTexture(255, 255, 255, 255);
        GlStateManager.glActiveTexture((int)33984);
        this.flippedBeforeShadow = ImmutableSet.of();
        this.customUniforms = programSet.getPack().customUniforms.build(uniformHolder -> CommonUniforms.addNonDynamicUniforms(uniformHolder, programSet.getPack().getIdMap(), programSet.getPackDirectives(), this.updateNotifier));
        BufferFlipper bufferFlipper = new BufferFlipper();
        this.centerDepthSampler = new CenterDepthSampler(() -> this.getRenderTargets().getDepthTexture(), programSet.getPackDirectives().getCenterDepthHalfLife());
        this.shadowMapResolution = programSet.getPackDirectives().getShadowDirectives().getResolution();
        this.shadowTargetsSupplier = () -> {
            if (this.shadowRenderTargets == null) {
                this.shadowRenderTargets = new ShadowRenderTargets(this, this.shadowMapResolution, packShadowDirectives);
            }
            return this.shadowRenderTargets;
        };
        ShaderPrinter.resetPrintState();
        this.prepareRenderer = new CompositeRenderer(this, programSet.getPackDirectives(), programSet.getPrepare(), programSet.getPrepareCompute(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, this.shadowTargetsSupplier, TextureStage.PREPARE, this.customTextureManager.getCustomTextureIdMap(TextureStage.PREPARE), this.customTextureManager.getIrisCustomTextures(), null, programSet.getPackDirectives().getExplicitFlips("prepare_pre"), this.customUniforms);
        this.flippedAfterPrepare = bufferFlipper.snapshot();
        this.deferredRenderer = new CompositeRenderer(this, programSet.getPackDirectives(), programSet.getDeferred(), programSet.getDeferredCompute(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, this.shadowTargetsSupplier, TextureStage.DEFERRED, this.customTextureManager.getCustomTextureIdMap(TextureStage.DEFERRED), this.customTextureManager.getIrisCustomTextures(), null, programSet.getPackDirectives().getExplicitFlips("deferred_pre"), this.customUniforms);
        this.flippedAfterTranslucent = bufferFlipper.snapshot();
        this.compositeRenderer = new CompositeRenderer(this, programSet.getPackDirectives(), programSet.getComposite(), programSet.getCompositeCompute(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, this.shadowTargetsSupplier, TextureStage.COMPOSITE_AND_FINAL, this.customTextureManager.getCustomTextureIdMap(TextureStage.COMPOSITE_AND_FINAL), this.customTextureManager.getIrisCustomTextures(), null, programSet.getPackDirectives().getExplicitFlips("composite_pre"), this.customUniforms);
        this.finalPassRenderer = new FinalPassRenderer(this, programSet, this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, bufferFlipper.snapshot(), this.centerDepthSampler, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.COMPOSITE_AND_FINAL), this.customTextureManager.getIrisCustomTextures(), null, this.compositeRenderer.getFlippedAtLeastOnceFinal(), this.customUniforms);
        ProgramId[] programIdArray = new ProgramId[]{ProgramId.Basic, ProgramId.Textured, ProgramId.TexturedLit, ProgramId.SkyBasic, ProgramId.SkyTextured, ProgramId.SkyTextured, null, null, ProgramId.Terrain, null, null, ProgramId.Water, null, ProgramId.Clouds, ProgramId.Clouds, null, ProgramId.DamagedBlock, ProgramId.DamagedBlock, ProgramId.Block, ProgramId.Block, ProgramId.Block, ProgramId.BeaconBeam, ProgramId.BeaconBeam, ProgramId.BeaconBeam, ProgramId.Entities, ProgramId.Entities, ProgramId.Entities, ProgramId.EntitiesTrans, ProgramId.EntitiesTrans, ProgramId.EntitiesTrans, null, ProgramId.ArmorGlint, ProgramId.ArmorGlint, null, ProgramId.SpiderEyes, ProgramId.SpiderEyes, ProgramId.Hand, ProgramId.Hand, ProgramId.Hand, ProgramId.HandWater, ProgramId.HandWater, ProgramId.HandWater, null, null, ProgramId.Weather, null, ProgramId.TexturedLit, ProgramId.TexturedLit, ProgramId.Shadow, ProgramId.Shadow, ProgramId.Shadow};
        if (programIdArray.length != RenderCondition.values().length * 3) {
            throw new IllegalStateException("Program ID table length mismatch");
        }
        ProgramFallbackResolver programFallbackResolver = new ProgramFallbackResolver(programSet);
        HashMap hashMap = new HashMap();
        this.shadowComputes = this.createShadowComputes(programSet.getShadowCompute(), programSet);
        this.table = new ProgramTable<Pass>((renderCondition, inputAvailability) -> {
            int n = inputAvailability.texture && inputAvailability.lightmap ? 2 : (inputAvailability.texture ? 1 : 0);
            ProgramId programId = programIdArray[renderCondition.ordinal() * 3 + n];
            if (programId == null) {
                programId = programIdArray[n];
            }
            ProgramId programId2 = programId;
            return hashMap.computeIfAbsent(new Pair((Object)programId, inputAvailability), pair -> {
                ProgramSource programSource = programFallbackResolver.resolveNullable((ProgramId)((Object)((Object)((Object)pair.getFirst()))));
                if (renderCondition == RenderCondition.SHADOW) {
                    if (!packShadowDirectives.isShadowEnabled().orElse(this.shadowRenderTargets != null)) {
                        return null;
                    }
                    if (programSource == null) {
                        GlFramebuffer glFramebuffer = this.shadowTargetsSupplier.get().createShadowFramebuffer(this.shadowRenderTargets.snapshot(), new int[]{0});
                        return new Pass(null, glFramebuffer, glFramebuffer, null, BlendModeOverride.OFF, Collections.emptyList(), true);
                    }
                }
                if (programSource == null) {
                    return this.createDefaultPass();
                }
                try {
                    return this.createPass(programSource, (InputAvailability)inputAvailability, renderCondition == RenderCondition.SHADOW, programId2);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to create pass for " + programSource.getName() + " for rendering condition " + String.valueOf(renderCondition) + " specialized to input availability " + String.valueOf(inputAvailability), exception);
                }
            });
        });
        if (this.shadowRenderTargets == null && packShadowDirectives.isShadowEnabled() == OptionalBoolean.TRUE) {
            this.shadowRenderTargets = new ShadowRenderTargets(this, this.shadowMapResolution, packShadowDirectives);
        }
        if (this.shadowRenderTargets != null) {
            this.shadowClearPasses = ClearPassCreator.createShadowClearPasses(this.shadowRenderTargets, false, packShadowDirectives);
            this.shadowClearPassesFull = ClearPassCreator.createShadowClearPasses(this.shadowRenderTargets, true, packShadowDirectives);
            if (programSet.getPackDirectives().getShadowDirectives().isShadowEnabled().orElse(true)) {
                object = this.table.match(RenderCondition.SHADOW, new InputAvailability(true, true, true)).getProgram();
                this.shadowCompositeRenderer = new ShadowCompositeRenderer(this, programSet.getPackDirectives(), programSet.getShadowComposite(), programSet.getShadowCompCompute(), this.shadowRenderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.customTextureManager.getCustomTextureIdMap(TextureStage.SHADOWCOMP), null, programSet.getPackDirectives().getExplicitFlips("shadowcomp_pre"), this.customTextureManager.getIrisCustomTextures(), this.customUniforms);
                this.shadowRenderer = new ShadowRenderer(programSet.getShadow().orElse(null), programSet.getPackDirectives(), this.shadowRenderTargets, this.shadowCompositeRenderer, this.customUniforms, false);
            } else {
                this.shadowCompositeRenderer = null;
                this.shadowRenderer = null;
            }
        } else {
            this.shadowClearPasses = ImmutableList.of();
            this.shadowClearPassesFull = ImmutableList.of();
            this.shadowCompositeRenderer = null;
            this.shadowRenderer = null;
        }
        this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, programSet.getPackDirectives().getRenderTargetDirectives());
        this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, programSet.getPackDirectives().getRenderTargetDirectives());
        object = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        IntFunction<ProgramSamplers> intFunction = arg_0 -> this.lambda$new$7((Supplier)object, arg_0);
        IntFunction<ProgramImages> intFunction2 = arg_0 -> this.lambda$new$8((Supplier)object, arg_0);
        IntFunction<ProgramSamplers> intFunction3 = n -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(n, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(TextureStage.GBUFFERS_AND_SHADOW));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> this.flippedAfterPrepare, this.renderTargets, false);
            IrisSamplers.addCustomTextures(builder, this.customTextureManager.getIrisCustomTextures());
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets), null, false);
            }
            return builder.build();
        };
        IntFunction<ProgramImages> intFunction4 = n -> {
            ProgramImages.Builder builder = ProgramImages.builder(n);
            IrisImages.addRenderTargetImages(builder, () -> this.flippedAfterPrepare, this.renderTargets);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets), null);
            }
            return builder.build();
        };
        this.sodiumTerrainPipeline = new SodiumTerrainPipeline(this, programSet, intFunction, this.shadowRenderTargets == null ? null : intFunction3, intFunction2, intFunction4, this.renderTargets, this.flippedAfterPrepare, this.flippedAfterTranslucent, this.shadowRenderTargets != null ? this.shadowRenderTargets.createShadowFramebuffer(this.shadowRenderTargets.snapshot(), new int[]{0, 1}) : null, this.customUniforms);
        this.customUniforms.optimise();
    }

    private RenderTargets getRenderTargets() {
        return this.renderTargets;
    }

    private void checkWorld() {
        if (class_310.method_1551().field_1687 == null) {
            this.isRenderingWorld = false;
            this.current = null;
        }
    }

    @Override
    public boolean shouldDisableVanillaEntityShadows() {
        return this.shadowRenderer != null;
    }

    @Override
    public boolean shouldDisableDirectionalShading() {
        return !this.oldLighting;
    }

    @Override
    public boolean shouldDisableFrustumCulling() {
        return false;
    }

    @Override
    public CloudSetting getCloudSetting() {
        return this.cloudSetting;
    }

    @Override
    public boolean shouldRenderUnderwaterOverlay() {
        return this.shouldRenderUnderwaterOverlay;
    }

    @Override
    public boolean shouldRenderVignette() {
        return this.shouldRenderVignette;
    }

    @Override
    public boolean shouldRenderSun() {
        return this.shouldRenderSun;
    }

    @Override
    public boolean shouldRenderMoon() {
        return this.shouldRenderMoon;
    }

    @Override
    public boolean shouldWriteRainAndSnowToDepthBuffer() {
        return this.shouldWriteRainAndSnowToDepthBuffer;
    }

    @Override
    public ParticleRenderingSettings getParticleRenderingSettings() {
        return this.particleRenderingSettings;
    }

    @Override
    public boolean allowConcurrentCompute() {
        return this.allowConcurrentCompute;
    }

    @Override
    public boolean hasFeature(FeatureFlags featureFlags) {
        return false;
    }

    @Override
    public float getSunPathRotation() {
        return this.sunPathRotation;
    }

    @Override
    public DHCompat getDHCompat() {
        return null;
    }

    private RenderCondition getCondition(WorldRenderingPhase worldRenderingPhase) {
        if (this.isRenderingShadow) {
            return RenderCondition.SHADOW;
        }
        if (this.special != null) {
            if (this.special == SpecialCondition.BEACON_BEAM) {
                return RenderCondition.BEACON_BEAM;
            }
            if (this.special == SpecialCondition.ENTITY_EYES) {
                return RenderCondition.ENTITY_EYES;
            }
            if (this.special == SpecialCondition.GLINT) {
                return RenderCondition.GLINT;
            }
        }
        switch (worldRenderingPhase) {
            case NONE: 
            case OUTLINE: 
            case DEBUG: 
            case PARTICLES: {
                return RenderCondition.DEFAULT;
            }
            case SKY: 
            case SUNSET: 
            case CUSTOM_SKY: 
            case SUN: 
            case MOON: 
            case STARS: 
            case VOID: {
                return RenderCondition.SKY;
            }
            case TERRAIN_SOLID: 
            case TERRAIN_CUTOUT: 
            case TERRAIN_CUTOUT_MIPPED: {
                return RenderCondition.TERRAIN_OPAQUE;
            }
            case ENTITIES: {
                if (GlStateManagerAccessor.getBLEND().field_5049 == GlStateManager.class_4535.SRC_ALPHA.value && GlStateManagerAccessor.getBLEND().field_5048 == GlStateManager.class_4535.ONE_MINUS_SRC_ALPHA.value && GlStateManagerAccessor.getBLEND().field_5047 == GlStateManager.class_4535.ONE.value && GlStateManagerAccessor.getBLEND().field_5046 == GlStateManager.class_4535.ONE_MINUS_SRC_ALPHA.value) {
                    return RenderCondition.ENTITIES_TRANSLUCENT;
                }
                return RenderCondition.ENTITIES;
            }
            case BLOCK_ENTITIES: {
                return RenderCondition.BLOCK_ENTITIES;
            }
            case DESTROY: {
                return RenderCondition.DESTROY;
            }
            case HAND_SOLID: {
                return RenderCondition.HAND_OPAQUE;
            }
            case TERRAIN_TRANSLUCENT: 
            case TRIPWIRE: {
                return RenderCondition.TERRAIN_TRANSLUCENT;
            }
            case CLOUDS: {
                return RenderCondition.CLOUDS;
            }
            case RAIN_SNOW: {
                return RenderCondition.RAIN_SNOW;
            }
            case HAND_TRANSLUCENT: {
                return RenderCondition.HAND_TRANSLUCENT;
            }
            case WORLD_BORDER: {
                return RenderCondition.WORLD_BORDER;
            }
        }
        throw new IllegalStateException("Unknown render phase " + String.valueOf((Object)worldRenderingPhase));
    }

    private void matchPass() {
        if (!this.isRenderingWorld || this.isRenderingFullScreenPass || this.isPostChain || !this.isMainBound) {
            return;
        }
        if (this.sodiumTerrainRendering) {
            this.beginPass(this.table.match(this.getCondition(this.getPhase()), new InputAvailability(true, true, false)));
            return;
        }
        this.beginPass(this.table.match(this.getCondition(this.getPhase()), this.inputs));
    }

    public void beginPass(Pass pass) {
        if (this.current == pass) {
            return;
        }
        if (this.current != null) {
            this.current.stopUsing();
        }
        this.current = pass;
        if (pass != null) {
            pass.use();
        } else {
            Program.unbind();
        }
    }

    private Pass createDefaultPass() {
        GlFramebuffer glFramebuffer = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, new int[]{0});
        GlFramebuffer glFramebuffer2 = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, new int[]{0});
        return new Pass(null, glFramebuffer, glFramebuffer2, null, null, Collections.emptyList(), false);
    }

    private Pass createPass(ProgramSource programSource, InputAvailability inputAvailability, boolean bl, ProgramId programId) {
        Map map = null;
        String string = (String)map.get((Object)PatchShaderType.VERTEX);
        String string2 = (String)map.get((Object)PatchShaderType.GEOMETRY);
        String string3 = (String)map.get((Object)PatchShaderType.FRAGMENT);
        ShaderPrinter.printProgram(programSource.getName()).addSources(map).print();
        ProgramBuilder programBuilder = ProgramBuilder.begin(programSource.getName(), string, string2, string3, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
        return this.createPassInner(programBuilder, programSource.getParent().getPack().getIdMap(), programSource.getDirectives(), programSource.getParent().getPackDirectives(), inputAvailability, bl, programId);
    }

    private Pass createPassInner(ProgramBuilder programBuilder, IdMap idMap, ProgramDirectives programDirectives, PackDirectives packDirectives, InputAvailability inputAvailability, boolean bl, ProgramId programId) {
        GlFramebuffer glFramebuffer;
        GlFramebuffer glFramebuffer2;
        CommonUniforms.addDynamicUniforms(programBuilder, FogMode.PER_VERTEX);
        this.customUniforms.assignTo(programBuilder);
        Supplier<Object> supplier = bl ? () -> this.shouldRenderPrepareBeforeShadow ? this.flippedAfterPrepare : this.flippedBeforeShadow : () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(programBuilder, this.customTextureManager.getCustomTextureIdMap(textureStage));
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, supplier, this.renderTargets, false);
        IrisSamplers.addCustomTextures(programBuilder, this.customTextureManager.getIrisCustomTextures());
        IrisImages.addRenderTargetImages(programBuilder, supplier, this.renderTargets);
        if (!this.shouldBindPBR) {
            this.shouldBindPBR = IrisSamplers.hasPBRSamplers(customTextureSamplerInterceptor);
        }
        IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, this.whitePixel, inputAvailability);
        if (!bl) {
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
        }
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            if (!bl) {
                this.shadowTargetsSupplier.get();
            }
            if (this.shadowRenderTargets != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowRenderTargets, null, false);
                IrisImages.addShadowColorImages(programBuilder, this.shadowRenderTargets, null);
            }
        }
        if (bl) {
            glFramebuffer = glFramebuffer2 = this.shadowTargetsSupplier.get().createShadowFramebuffer(this.shadowRenderTargets.snapshot(), new int[]{0, 1});
        } else {
            glFramebuffer2 = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, programDirectives.getDrawBuffers());
            glFramebuffer = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, programDirectives.getDrawBuffers());
        }
        programBuilder.bindAttributeLocation(11, "mc_Entity");
        programBuilder.bindAttributeLocation(12, "mc_midTexCoord");
        programBuilder.bindAttributeLocation(13, "at_tangent");
        programBuilder.bindAttributeLocation(14, "at_midBlock");
        AlphaTest alphaTest = programDirectives.getAlphaTestOverride().orElse(null);
        ArrayList<BufferBlendOverride> arrayList = new ArrayList<BufferBlendOverride>();
        programDirectives.getBufferBlendOverrides().forEach(bufferBlendInformation -> {
            int n = Ints.indexOf((int[])programDirectives.getDrawBuffers(), (int)bufferBlendInformation.getIndex());
            if (n > -1) {
                arrayList.add(new BufferBlendOverride(n, bufferBlendInformation.getBlendMode()));
            }
        });
        Pass pass = new Pass(programBuilder.build(), glFramebuffer2, glFramebuffer, alphaTest, programDirectives.getBlendModeOverride().orElse(programId.getBlendModeOverride()), arrayList, bl);
        this.customUniforms.mapholderToPass(programBuilder, pass);
        return pass;
    }

    @Override
    public void beginPostChain() {
        this.isPostChain = true;
        this.beginPass(null);
    }

    @Override
    public void endPostChain() {
        this.isPostChain = false;
    }

    @Override
    public void setIsMainBound(boolean bl) {
        this.isMainBound = bl;
        if (!this.isRenderingWorld || this.isRenderingFullScreenPass || this.isPostChain) {
            return;
        }
        if (bl) {
            this.current = null;
        } else {
            this.beginPass(null);
        }
    }

    @Override
    public Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> getTextureMap() {
        return this.customTextureMap;
    }

    @Override
    public void destroy() {
        BlendModeOverride.restore();
        AlphaTestOverride.restore();
        DeferredWorldRenderingPipeline.destroyPasses(this.table);
        this.compositeRenderer.destroy();
        this.deferredRenderer.destroy();
        this.finalPassRenderer.destroy();
        this.centerDepthSampler.destroy();
        this.horizonRenderer.destroy();
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
        GlStateManager._glBindFramebuffer((int)36009, (int)0);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
        class_310.method_1551().method_1522().method_1235(false);
        this.renderTargets.destroy();
        if (this.shadowRenderTargets != null) {
            this.shadowRenderTargets.destroy();
        }
        this.customTextureManager.destroy();
        this.whitePixel.method_4528();
        if (this.shaderStorageBufferHolder != null) {
            this.shaderStorageBufferHolder.destroyBuffers();
        }
    }

    private static void destroyPasses(ProgramTable<Pass> programTable) {
        HashSet hashSet = new HashSet();
        programTable.forEach(pass -> {
            if (pass == null) {
                return;
            }
            if (hashSet.contains(pass)) {
                return;
            }
            pass.destroy();
            hashSet.add(pass);
        });
    }

    private void prepareRenderTargets() {
        ImmutableList<ClearPass> immutableList;
        ImmutableList<ClearPass> immutableList2;
        Object object3;
        Object object22;
        RenderSystem.activeTexture((int)33984);
        Vector4f vector4f = new Vector4f(1.0f);
        if (this.shadowRenderTargets != null) {
            if (this.packDirectives.getShadowDirectives().isShadowEnabled() == OptionalBoolean.FALSE) {
                if (this.shadowRenderTargets.isFullClearRequired()) {
                    this.shadowRenderTargets.onFullClear();
                    for (Object object22 : this.shadowClearPassesFull) {
                        ((ClearPass)object22).execute(vector4f);
                    }
                }
            } else {
                this.shadowRenderTargets.getDepthSourceFb().bind();
                RenderSystem.clear((int)256, (boolean)class_310.field_1703);
                for (Object object3 : this.shadowComputes) {
                    if (object3 == null) continue;
                    ((ComputeProgram)object3).use();
                    this.customUniforms.push(object3);
                    ((ComputeProgram)object3).dispatch(this.shadowMapResolution, this.shadowMapResolution);
                }
                if (this.shadowRenderTargets.isFullClearRequired()) {
                    immutableList2 = this.shadowClearPassesFull;
                    this.shadowRenderTargets.onFullClear();
                } else {
                    immutableList2 = this.shadowClearPasses;
                }
                for (ClearPass clearPass2 : immutableList2) {
                    clearPass2.execute(vector4f);
                }
            }
        }
        immutableList2 = class_310.method_1551().method_1522();
        object22 = (ComputeProgram[])immutableList2;
        int n = immutableList2.method_30278();
        int n2 = TextureInfoCache.INSTANCE.getInfo(n).getInternalFormat();
        object3 = DepthBufferFormat.fromGlEnumOrDefault(n2);
        boolean bl = this.renderTargets.resizeIfNeeded(object22.iris$getDepthBufferVersion(), n, immutableList2.field_1482, immutableList2.field_1481, (DepthBufferFormat)((Object)object3), this.packDirectives);
        if (bl) {
            this.prepareRenderer.recalculateSizes();
            this.deferredRenderer.recalculateSizes();
            this.compositeRenderer.recalculateSizes();
            this.finalPassRenderer.recalculateSwapPassSize();
            this.clearPassesFull.forEach(clearPass -> this.renderTargets.destroyFramebuffer(clearPass.getFramebuffer()));
            this.clearPasses.forEach(clearPass -> this.renderTargets.destroyFramebuffer(clearPass.getFramebuffer()));
            this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, this.packDirectives.getRenderTargetDirectives());
            this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, this.packDirectives.getRenderTargetDirectives());
        }
        if (this.renderTargets.isFullClearRequired()) {
            this.renderTargets.onFullClear();
            immutableList = this.clearPassesFull;
        } else {
            immutableList = this.clearPasses;
        }
        Vector3d vector3d = CapturedRenderingState.INSTANCE.getFogColor();
        Vector4f vector4f2 = new Vector4f((float)vector3d.x, (float)vector3d.y, (float)vector3d.z, 1.0f);
        for (ClearPass clearPass3 : immutableList) {
            clearPass3.execute(vector4f2);
        }
        class_310.method_1551().method_1522().method_1235(true);
    }

    private ComputeProgram[] createShadowComputes(ComputeSource[] computeSourceArray, ProgramSet programSet) {
        ComputeProgram[] computeProgramArray = new ComputeProgram[computeSourceArray.length];
        for (int i = 0; i < computeProgramArray.length; ++i) {
            ProgramBuilder programBuilder;
            ComputeSource computeSource = computeSourceArray[i];
            if (computeSource == null || !computeSource.getSource().isPresent()) continue;
            try {
                programBuilder = ProgramBuilder.beginCompute(computeSource.getName(), computeSource.getSource().orElse(null), IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            }
            catch (ShaderCompileException shaderCompileException) {
                throw shaderCompileException;
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeException("Shader compilation failed!", runtimeException);
            }
            CommonUniforms.addDynamicUniforms(programBuilder, FogMode.OFF);
            this.customUniforms.assignTo(programBuilder);
            Supplier<ImmutableSet<Integer>> supplier = () -> this.flippedBeforeShadow;
            TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(programBuilder, this.customTextureManager.getCustomTextureIdMap(textureStage));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, supplier, this.renderTargets, false);
            IrisSamplers.addCustomTextures(programBuilder, this.customTextureManager.getIrisCustomTextures());
            IrisImages.addRenderTargetImages(programBuilder, supplier, this.renderTargets);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor) && this.shadowRenderTargets != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowRenderTargets, null, false);
                IrisImages.addShadowColorImages(programBuilder, this.shadowRenderTargets, null);
            }
            computeProgramArray[i] = programBuilder.buildCompute();
            this.customUniforms.mapholderToPass(programBuilder, computeProgramArray[i]);
            computeProgramArray[i].setWorkGroupInfo(computeSource.getWorkGroupRelative(), computeSource.getWorkGroups());
        }
        return computeProgramArray;
    }

    @Override
    public void beginHand() {
        this.renderTargets.copyPreHandDepth();
    }

    @Override
    public void beginTranslucents() {
        this.isBeforeTranslucent = false;
        this.renderTargets.copyPreTranslucentDepth();
        this.beginPass(null);
        this.isRenderingFullScreenPass = true;
        this.deferredRenderer.renderAll();
        RenderSystem.enableBlend();
        this.isRenderingFullScreenPass = false;
    }

    @Override
    public void renderShadows(LevelRendererAccessor levelRendererAccessor, class_4184 class_41842) {
        if (this.shouldRenderPrepareBeforeShadow) {
            this.isRenderingFullScreenPass = true;
            this.prepareRenderer.renderAll();
            this.isRenderingFullScreenPass = false;
        }
        if (this.shadowRenderer != null) {
            this.isRenderingShadow = true;
            this.shadowRenderer.renderShadows(levelRendererAccessor, class_41842);
            this.beginPass(null);
            this.isRenderingShadow = false;
        }
        if (!this.shouldRenderPrepareBeforeShadow) {
            this.isRenderingFullScreenPass = true;
            this.prepareRenderer.renderAll();
            this.isRenderingFullScreenPass = false;
        }
    }

    @Override
    public void addDebugText(List<String> list) {
        list.add("");
        if (this.shadowRenderer != null) {
            this.shadowRenderer.addDebugText(list);
        } else {
            list.add("[Iris] Shadow Maps: not used by shader pack");
        }
    }

    @Override
    public OptionalInt getForcedShadowRenderDistanceChunksForDisplay() {
        return this.forcedShadowRenderDistanceChunks;
    }

    @Override
    public void onShadowBufferChange() {
    }

    @Override
    public void beginLevelRendering() {
        this.isRenderingFullScreenPass = false;
        this.isRenderingWorld = true;
        this.isBeforeTranslucent = true;
        this.isMainBound = true;
        this.isPostChain = false;
        this.phase = WorldRenderingPhase.NONE;
        this.overridePhase = null;
        HandRenderer.INSTANCE.getBufferSource().resetDrawCalls();
        this.checkWorld();
        if (!this.isRenderingWorld) {
            Iris.logger.warn("beginWorldRender was called but we are not currently rendering a world?");
            return;
        }
        if (this.current != null) {
            throw new IllegalStateException("Called beginLevelRendering but level rendering appears to still be in progress?");
        }
        if (this.showSSBOError) {
            this.showSSBOError = false;
            if (class_310.method_1551().field_1724 != null) {
                // empty if block
            }
        }
        this.updateNotifier.onNewFrame();
        this.prepareRenderTargets();
        this.customUniforms.update();
        this.setPhase(WorldRenderingPhase.SKY);
        class_5294.class_5401 class_54012 = class_310.method_1551().field_1687.method_28103().method_29992();
        if (class_54012 == class_5294.class_5401.field_25640) {
            RenderSystem.depthMask((boolean)false);
            Vector3d vector3d = CapturedRenderingState.INSTANCE.getFogColor();
            RenderSystem.setShaderColor((float)((float)vector3d.x), (float)((float)vector3d.y), (float)((float)vector3d.z), (float)1.0f);
            this.horizonRenderer.renderHorizon(CapturedRenderingState.INSTANCE.getGbufferModelView(), CapturedRenderingState.INSTANCE.getGbufferProjection(), class_757.method_34539());
            RenderSystem.depthMask((boolean)true);
        }
    }

    @Override
    public void finalizeLevelRendering() {
        this.checkWorld();
        if (!this.isRenderingWorld) {
            Iris.logger.warn("finalizeWorldRendering was called but we are not currently rendering a world?");
            return;
        }
        this.beginPass(null);
        this.isRenderingWorld = false;
        this.phase = WorldRenderingPhase.NONE;
        this.overridePhase = null;
        this.isRenderingFullScreenPass = true;
        this.centerDepthSampler.sampleCenterDepth();
        this.compositeRenderer.renderAll();
        this.finalPassRenderer.renderFinalPass();
        this.isRenderingFullScreenPass = false;
    }

    @Override
    public void finalizeGameRendering() {
    }

    @Override
    public SodiumTerrainPipeline getSodiumTerrainPipeline() {
        return this.sodiumTerrainPipeline;
    }

    @Override
    public FrameUpdateNotifier getFrameUpdateNotifier() {
        return this.updateNotifier;
    }

    @Override
    public WorldRenderingPhase getPhase() {
        if (this.overridePhase != null) {
            return this.overridePhase;
        }
        return this.phase;
    }

    public void syncProgram() {
        this.matchPass();
    }

    @Override
    public void beginSodiumTerrainRendering() {
        this.sodiumTerrainRendering = true;
        this.syncProgram();
    }

    @Override
    public void endSodiumTerrainRendering() {
        this.sodiumTerrainRendering = false;
        this.current = null;
        this.syncProgram();
    }

    @Override
    public void setOverridePhase(WorldRenderingPhase worldRenderingPhase) {
        this.overridePhase = worldRenderingPhase;
        GbufferPrograms.runPhaseChangeNotifier();
    }

    @Override
    public void setPhase(WorldRenderingPhase worldRenderingPhase) {
        this.phase = worldRenderingPhase;
        GbufferPrograms.runPhaseChangeNotifier();
    }

    public void setInputs(InputAvailability inputAvailability) {
        this.inputs = inputAvailability;
    }

    @Override
    public void setSpecialCondition(SpecialCondition specialCondition) {
        this.special = specialCondition;
    }

    @Override
    public RenderTargetStateListener getRenderTargetStateListener() {
        return this;
    }

    @Override
    public int getCurrentNormalTexture() {
        return this.currentNormalTexture;
    }

    @Override
    public int getCurrentSpecularTexture() {
        return this.currentSpecularTexture;
    }

    @Override
    public void onSetShaderTexture(int n) {
        if (this.shouldBindPBR && this.isRenderingWorld) {
            PBRTextureHolder pBRTextureHolder = PBRTextureManager.INSTANCE.getOrLoadHolder(n);
            this.currentNormalTexture = pBRTextureHolder.getNormalTexture().method_4624();
            this.currentSpecularTexture = pBRTextureHolder.getSpecularTexture().method_4624();
            TextureFormat textureFormat = TextureFormatLoader.getFormat();
            if (textureFormat != null) {
                textureFormat.setupTextureParameters(PBRType.NORMAL, pBRTextureHolder.getNormalTexture());
                textureFormat.setupTextureParameters(PBRType.SPECULAR, pBRTextureHolder.getSpecularTexture());
            }
            PBRTextureManager.notifyPBRTexturesChanged();
        }
    }

    private /* synthetic */ ProgramImages lambda$new$8(Supplier supplier, int n) {
        ProgramImages.Builder builder = ProgramImages.builder(n);
        IrisImages.addRenderTargetImages(builder, supplier, this.renderTargets);
        if (IrisImages.hasShadowImages(builder)) {
            IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets), null);
        }
        return builder.build();
    }

    private /* synthetic */ ProgramSamplers lambda$new$7(Supplier supplier, int n) {
        ProgramSamplers.Builder builder = ProgramSamplers.builder(n, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(TextureStage.GBUFFERS_AND_SHADOW));
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, supplier, this.renderTargets, false);
        IrisSamplers.addCustomTextures(builder, this.customTextureManager.getIrisCustomTextures());
        IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, this.whitePixel, new InputAvailability(true, true, false));
        IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets), null, false);
        }
        return builder.build();
    }

    private final class Pass {
        @Nullable
        private final Program program;
        private final GlFramebuffer framebufferBeforeTranslucents;
        private final GlFramebuffer framebufferAfterTranslucents;
        @Nullable
        private final AlphaTest alphaTestOverride;
        @Nullable
        private final BlendModeOverride blendModeOverride;
        @Nullable
        private final List<BufferBlendOverride> bufferBlendOverrides;
        private final boolean shadowViewport;

        private Pass(Program program, GlFramebuffer glFramebuffer, @Nullable GlFramebuffer glFramebuffer2, @Nullable AlphaTest alphaTest, @Nullable BlendModeOverride blendModeOverride, List<BufferBlendOverride> list, boolean bl) {
            this.program = program;
            this.framebufferBeforeTranslucents = glFramebuffer;
            this.framebufferAfterTranslucents = glFramebuffer2;
            this.alphaTestOverride = alphaTest;
            this.blendModeOverride = blendModeOverride;
            this.bufferBlendOverrides = list;
            this.shadowViewport = bl;
        }

        public void use() {
            if (DeferredWorldRenderingPipeline.this.isBeforeTranslucent) {
                this.framebufferBeforeTranslucents.bind();
            } else {
                this.framebufferAfterTranslucents.bind();
            }
            if (this.shadowViewport) {
                RenderSystem.viewport((int)0, (int)0, (int)DeferredWorldRenderingPipeline.this.shadowMapResolution, (int)DeferredWorldRenderingPipeline.this.shadowMapResolution);
            } else {
                class_276 class_2762 = class_310.method_1551().method_1522();
                RenderSystem.viewport((int)0, (int)0, (int)class_2762.field_1482, (int)class_2762.field_1481);
            }
            if (this.program != null) {
                this.program.use();
            }
            DeferredWorldRenderingPipeline.this.customUniforms.push(this);
            if (this.alphaTestOverride != null) {
                AlphaTestStorage.overrideAlphaTest(this.alphaTestOverride);
            } else {
                AlphaTestStorage.restoreAlphaTest();
            }
            if (this.blendModeOverride != null) {
                this.blendModeOverride.apply();
            } else {
                BlendModeOverride.restore();
            }
            if (this.bufferBlendOverrides != null && !this.bufferBlendOverrides.isEmpty()) {
                this.bufferBlendOverrides.forEach(BufferBlendOverride::apply);
            }
        }

        public void stopUsing() {
            if (this.alphaTestOverride != null) {
                AlphaTestStorage.restoreAlphaTest();
            }
            if (this.blendModeOverride != null || this.bufferBlendOverrides != null && !this.bufferBlendOverrides.isEmpty()) {
                BlendModeOverride.restore();
            }
        }

        @Nullable
        public Program getProgram() {
            return this.program;
        }

        public void destroy() {
            if (this.program != null) {
                this.program.destroy();
            }
        }
    }
}

