/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.ComputeSource;
import net.coderbot.iris.shaderpack.ConstDirectiveParser;
import org.joml.Vector2f;
import org.joml.Vector3i;

public class ComputeDirectiveParser {
    public static void setComputeWorkGroups(ComputeSource computeSource, ConstDirectiveParser.ConstDirective constDirective) {
        String string;
        if (!constDirective.getValue().startsWith("ivec3")) {
            Iris.logger.error("Failed to process " + String.valueOf(constDirective) + ": value was not a valid ivec3 constructor");
        }
        if (!(string = constDirective.getValue().substring("ivec3".length()).trim()).startsWith("(") || !string.endsWith(")")) {
            Iris.logger.error("Failed to process " + String.valueOf(constDirective) + ": value was not a valid ivec3 constructor");
        }
        string = string.substring(1, string.length() - 1);
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        if (stringArray.length != 3) {
            Iris.logger.error("Failed to process " + String.valueOf(constDirective) + ": expected 3 arguments to a ivec3 constructor, got " + stringArray.length);
        }
        try {
            computeSource.setWorkGroups(new Vector3i(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2])));
        }
        catch (NumberFormatException numberFormatException) {
            Iris.logger.error("Failed to process " + String.valueOf(constDirective), numberFormatException);
        }
    }

    public static void setComputeWorkGroupsRelative(ComputeSource computeSource, ConstDirectiveParser.ConstDirective constDirective) {
        String string;
        if (!constDirective.getValue().startsWith("vec2")) {
            Iris.logger.error("Failed to process " + String.valueOf(constDirective) + ": value was not a valid vec2 constructor");
        }
        if (!(string = constDirective.getValue().substring("vec2".length()).trim()).startsWith("(") || !string.endsWith(")")) {
            Iris.logger.error("Failed to process " + String.valueOf(constDirective) + ": value was not a valid vec2 constructor");
        }
        string = string.substring(1, string.length() - 1);
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        if (stringArray.length != 2) {
            Iris.logger.error("Failed to process " + String.valueOf(constDirective) + ": expected 2 arguments to a vec2 constructor, got " + stringArray.length);
        }
        try {
            computeSource.setWorkGroupRelative(new Vector2f(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1])));
        }
        catch (NumberFormatException numberFormatException) {
            Iris.logger.error("Failed to process " + String.valueOf(constDirective), numberFormatException);
        }
    }
}

