/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.format;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import net.coderbot.iris.Iris;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public class TextureFormatLoader {
    public static final class_2960 LOCATION = new class_2960("optifine/texture.properties");
    private static TextureFormat format;

    @Nullable
    public static TextureFormat getFormat() {
        return format;
    }

    public static void reload(class_3300 class_33002) {
        TextureFormat textureFormat = TextureFormatLoader.loadFormat(class_33002);
        boolean bl = !Objects.equals(format, textureFormat);
        format = textureFormat;
        if (bl) {
            TextureFormatLoader.onFormatChange();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static TextureFormat loadFormat(class_3300 class_33002) {
        Optional optional = class_33002.method_14486(LOCATION);
        if (!optional.isPresent()) return null;
        try (InputStream inputStream = ((class_3298)optional.get()).method_14482();){
            Properties properties = new Properties();
            properties.load(inputStream);
            String string2 = properties.getProperty("format");
            if (string2 == null) return null;
            if (string2.isEmpty()) return null;
            String[] stringArray = string2.split("/");
            if (stringArray.length <= 0) return null;
            String string = stringArray[0];
            TextureFormat.Factory factory = TextureFormatRegistry.INSTANCE.getFactory(string);
            if (factory != null) {
                String string3 = stringArray.length > 1 ? stringArray[1] : null;
                TextureFormat textureFormat = factory.createFormat(string, string3);
                return textureFormat;
            }
            Iris.logger.warn("Invalid texture format '" + string + "' in file '" + String.valueOf(LOCATION) + "'");
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            Iris.logger.error("Failed to load texture format from file '" + String.valueOf(LOCATION) + "'", exception);
        }
        return null;
    }

    private static void onFormatChange() {
        try {
            Iris.reload();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

