/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.config.blocksound;

import com.sonicether.soundphysics.Loggers;
import com.sonicether.soundphysics.config.blocksound.BlockDefinition;
import com.sonicether.soundphysics.config.blocksound.BlockIdDefinition;
import com.sonicether.soundphysics.config.blocksound.BlockSoundTypeDefinition;
import com.sonicether.soundphysics.config.blocksound.BlockTagDefinition;
import de.maxhenkel.sound_physics_remastered.configbuilder.CommentedProperties;
import de.maxhenkel.sound_physics_remastered.configbuilder.CommentedPropertyConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public abstract class BlockSoundConfigBase
extends CommentedPropertyConfig {
    private Map<BlockDefinition, Float> configMap;
    @Nullable
    private Map<class_6862<class_2248>, Float> blockTagCache;
    @Nullable
    private Map<class_2248, Float> blockCache;
    @Nullable
    private Map<class_2498, Float> soundTypeCache;

    public BlockSoundConfigBase(Path path) {
        super(new CommentedProperties(false));
        this.path = path;
        this.reload();
    }

    @Override
    public void load() throws IOException {
        this.configMap = new LinkedHashMap<BlockDefinition, Float>();
        this.addDefaults(this.configMap);
        super.load();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            float value;
            String key = entry.getKey();
            try {
                value = Float.parseFloat(entry.getValue());
            }
            catch (NumberFormatException e) {
                Loggers.LOGGER.warn("Failed to parse value of {}", (Object)key);
                continue;
            }
            BlockDefinition blockDefinition = BlockSoundConfigBase.loadBlockDefinition(key);
            if (blockDefinition == null) {
                Loggers.LOGGER.warn("Block definition {} not found", (Object)key);
                continue;
            }
            this.configMap.put(blockDefinition, Float.valueOf(value));
        }
        this.invalidateCaches();
        this.saveSync();
    }

    public static BlockDefinition loadBlockDefinition(String configString) {
        BlockDefinition blockDefinition = BlockTagDefinition.fromConfigString(configString);
        if (blockDefinition != null) {
            return blockDefinition;
        }
        blockDefinition = BlockIdDefinition.fromConfigString(configString);
        if (blockDefinition != null) {
            return blockDefinition;
        }
        blockDefinition = BlockSoundTypeDefinition.fromConfigString(configString);
        return blockDefinition;
    }

    @Override
    public void saveSync() {
        this.properties.clear();
        this.properties.setHeaderComments(List.of("Values for blocks can be defined as follows:", "", "By sound type:", "WOOD=1.0", "", "By block tag:", "\\#minecraft\\:logs=1.0", "", "By block ID:", "minecraft\\:oak_log=1.0"));
        for (Map.Entry<BlockDefinition, Float> entry : this.configMap.entrySet()) {
            String configKey = entry.getKey().getConfigString();
            this.properties.set(configKey, String.valueOf(entry.getValue()), new String[0]);
            String configComment = entry.getKey().getConfigComment();
            if (configComment != null) {
                this.properties.setComments(configKey, Collections.singletonList(configComment));
                continue;
            }
            this.properties.setComments(configKey, Collections.emptyList());
        }
        super.saveSync();
    }

    public Map<BlockDefinition, Float> getBlockDefinitions() {
        return Collections.unmodifiableMap(this.configMap);
    }

    public float getBlockDefinitionValue(class_2680 blockState) {
        Float value = this.getBlocks().get(blockState.method_26204());
        if (value != null) {
            return value.floatValue();
        }
        for (Map.Entry<class_6862<class_2248>, Float> entry : this.getBlockTags().entrySet()) {
            if (!BlockSoundConfigBase.isTagIn(entry.getKey(), blockState.method_26204())) continue;
            return entry.getValue().floatValue();
        }
        value = this.getSoundTypes().get(blockState.method_26231());
        if (value != null) {
            return value.floatValue();
        }
        return this.getDefaultValue().floatValue();
    }

    public static <T> boolean isTagIn(class_6862<T> tagKey, T entry) {
        class_2378 registry;
        Optional maybeKey;
        Optional registryOptional = class_7923.field_41167.method_17966(tagKey.comp_326().method_29177());
        if (registryOptional.isPresent() && tagKey.method_41007(((class_2378)registryOptional.get()).method_30517()) && (maybeKey = (registry = (class_2378)registryOptional.get()).method_29113(entry)).isPresent()) {
            return registry.method_40290((class_5321)maybeKey.get()).method_40220(tagKey);
        }
        return false;
    }

    private void invalidateCaches() {
        this.blockTagCache = null;
        this.blockCache = null;
        this.soundTypeCache = null;
    }

    private Map<class_6862<class_2248>, Float> getBlockTags() {
        if (this.blockTagCache == null) {
            this.blockTagCache = new LinkedHashMap<class_6862<class_2248>, Float>();
            for (Map.Entry<BlockDefinition, Float> entry : this.configMap.entrySet()) {
                BlockDefinition blockDefinition = entry.getKey();
                if (!(blockDefinition instanceof BlockTagDefinition)) continue;
                BlockTagDefinition def = (BlockTagDefinition)blockDefinition;
                this.blockTagCache.put(def.getBlockTag(), entry.getValue());
            }
        }
        return this.blockTagCache;
    }

    private Map<class_2248, Float> getBlocks() {
        if (this.blockCache == null) {
            this.blockCache = new LinkedHashMap<class_2248, Float>();
            for (Map.Entry<BlockDefinition, Float> entry : this.configMap.entrySet()) {
                BlockDefinition blockDefinition = entry.getKey();
                if (!(blockDefinition instanceof BlockIdDefinition)) continue;
                BlockIdDefinition def = (BlockIdDefinition)blockDefinition;
                this.blockCache.put(def.getBlock(), entry.getValue());
            }
        }
        return this.blockCache;
    }

    private Map<class_2498, Float> getSoundTypes() {
        if (this.soundTypeCache == null) {
            this.soundTypeCache = new LinkedHashMap<class_2498, Float>();
            for (Map.Entry<BlockDefinition, Float> entry : this.configMap.entrySet()) {
                BlockDefinition blockDefinition = entry.getKey();
                if (!(blockDefinition instanceof BlockSoundTypeDefinition)) continue;
                BlockSoundTypeDefinition def = (BlockSoundTypeDefinition)blockDefinition;
                this.soundTypeCache.put(def.getSoundType(), entry.getValue());
            }
        }
        return this.soundTypeCache;
    }

    public BlockSoundConfigBase setBlockDefinitionValue(BlockDefinition blockDefinition, float value) {
        this.configMap.put(blockDefinition, Float.valueOf(value));
        this.invalidateCaches();
        return this;
    }

    public abstract void addDefaults(Map<BlockDefinition, Float> var1);

    public abstract Float getDefaultValue();

    protected static void putSoundType(Map<BlockDefinition, Float> map, class_2498 soundType, float value) {
        map.put(new BlockSoundTypeDefinition(soundType), Float.valueOf(value));
    }
}

