/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import me.pepperbell.continuity.api.client.CTMPropertiesFactory;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.properties.BaseCTMProperties;

public interface TileAmountValidator<T extends BaseCTMProperties> {
    public boolean validateTileAmount(int var1, T var2);

    public static <T extends BaseCTMProperties> CTMPropertiesFactory<T> wrapFactory(CTMPropertiesFactory<T> factory, TileAmountValidator<T> validator) {
        return (properties, id, pack, packPriority, resourceManager, method) -> {
            BaseCTMProperties ctmProperties = (BaseCTMProperties)factory.createProperties(properties, id, pack, packPriority, resourceManager, method);
            if (ctmProperties == null) {
                return null;
            }
            if (validator.validateTileAmount(ctmProperties.getTileAmount(), ctmProperties)) {
                return ctmProperties;
            }
            return null;
        };
    }

    public static class AtLeast<T extends BaseCTMProperties>
    implements TileAmountValidator<T> {
        protected final int targetAmount;

        public AtLeast(int targetAmount) {
            this.targetAmount = targetAmount;
        }

        @Override
        public boolean validateTileAmount(int amount, T properties) {
            if (amount >= this.targetAmount) {
                return true;
            }
            ContinuityClient.LOGGER.error("Method '" + ((BaseCTMProperties)properties).getMethod() + "' requires at least " + this.targetAmount + " tiles but only " + amount + " were provided in file '" + ((BaseCTMProperties)properties).getId() + "' in pack '" + ((BaseCTMProperties)properties).getPackName() + "'");
            return false;
        }
    }

    public static class Exactly<T extends BaseCTMProperties>
    implements TileAmountValidator<T> {
        protected final int targetAmount;

        public Exactly(int targetAmount) {
            this.targetAmount = targetAmount;
        }

        @Override
        public boolean validateTileAmount(int amount, T properties) {
            if (amount == this.targetAmount) {
                return true;
            }
            ContinuityClient.LOGGER.error("Method '" + ((BaseCTMProperties)properties).getMethod() + "' requires exactly " + this.targetAmount + " tiles but " + amount + " were provided in file '" + ((BaseCTMProperties)properties).getId() + "' in pack '" + ((BaseCTMProperties)properties).getPackName() + "'");
            return false;
        }
    }
}

