/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu;

import de.keksuccino.fancymenu.FancyMenu;
import net.minecraft.class_4071;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Compat {
    private static final Logger LOGGER = LogManager.getLogger();

    public static boolean isRRLSOverlay(class_4071 overlay) {
        try {
            Class<?> c = Class.forName("com.github.dimadencep.mods.rrls.accessor.SplashAccessor");
            if (c.isInstance(overlay)) {
                return (Boolean)c.getMethod("isAttached", new Class[0]).invoke((Object)overlay, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isRRLSLoaded() {
        try {
            Class.forName("com.github.dimadencep.mods.rrls.Rrls", false, FancyMenu.class.getClassLoader());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isOptiFineLoaded() {
        try {
            Class.forName("optifine.Installer", false, FancyMenu.class.getClassLoader());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAudioExtensionLoaded() {
        try {
            Class.forName("de.keksuccino.fmaudio.FmAudio", false, FancyMenu.class.getClassLoader());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void printInfoLog() {
        if (Compat.isOptiFineLoaded()) {
            LOGGER.info("[FANCYMENU] OptiFine found! Will try to fix incompatibilities!");
        }
        if (Compat.isRRLSLoaded()) {
            LOGGER.info("[FANCYMENU] RemoveReloadingScreen found! Will try to fix incompatibilities!");
        }
    }
}

