/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu;

import de.keksuccino.fancymenu.Compat;
import de.keksuccino.fancymenu.Options;
import de.keksuccino.fancymenu.Test;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.customlocals.CustomLocalsHandler;
import de.keksuccino.fancymenu.customization.server.ServerCache;
import de.keksuccino.fancymenu.platform.Services;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.file.type.types.FileTypes;
import de.keksuccino.fancymenu.util.rendering.text.color.colors.TextColorFormatters;
import de.keksuccino.fancymenu.util.rendering.ui.cursor.CursorHandler;
import de.keksuccino.fancymenu.util.rendering.ui.theme.themes.UIColorThemes;
import de.keksuccino.fancymenu.util.window.WindowHandler;
import java.io.File;
import net.minecraft.class_155;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class FancyMenu {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String VERSION = "3.0.6";
    public static final String MOD_LOADER = Services.PLATFORM.getPlatformName();
    public static final String MOD_ID = "fancymenu";
    public static final File MOD_DIR = FancyMenu.createDirectory(new File(GameDirectoryUtils.getGameDirectory(), "/config/fancymenu"));
    public static final File INSTANCE_DATA_DIR = FancyMenu.createDirectory(new File(GameDirectoryUtils.getGameDirectory(), "/fancymenu_data"));
    public static final File TEMP_DATA_DIR = FancyMenu.createDirectory(new File(INSTANCE_DATA_DIR, "/.fancymenu_temp"));
    public static final File CACHE_DIR = FancyMenu.createDirectory(new File(INSTANCE_DATA_DIR, "/cached_data"));
    private static Options options;

    public static void init() {
        if (Services.PLATFORM.isOnClient()) {
            LOGGER.info("[FANCYMENU] Loading v3.0.6 in client-side mode on " + MOD_LOADER.toUpperCase() + "!");
        } else {
            LOGGER.info("[FANCYMENU] Loading v3.0.6 in server-side mode on " + MOD_LOADER.toUpperCase() + "!");
        }
        FileTypes.registerAll();
        if (Services.PLATFORM.isOnClient()) {
            UIColorThemes.registerAll();
            TextColorFormatters.registerAll();
            ScreenCustomization.init();
            EventHandler.INSTANCE.registerListenersOf(new Test());
        }
        Compat.printInfoLog();
    }

    public static void lateClientInit() {
        LOGGER.info("[FANCYMENU] Starting late client initialization phase..");
        WindowHandler.updateCustomWindowIcon();
        WindowHandler.handleForceFullscreen();
        CursorHandler.init();
        CustomLocalsHandler.loadLocalizations();
        ServerCache.init();
    }

    public static Options getOptions() {
        if (options == null) {
            FancyMenu.reloadOptions();
        }
        return options;
    }

    public static void reloadOptions() {
        options = new Options();
    }

    public static String getMinecraftVersion() {
        return class_155.method_16673().method_48019();
    }

    private static File createDirectory(@NotNull File directory) {
        return FileUtils.createDirectory(directory);
    }
}

