/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiHandler;
import de.keksuccino.fancymenu.customization.screen.ScreenInstanceFactory;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.konkrete.command.CommandUtils;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class OpenGuiScreenCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> d) {
        d.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"openguiscreen").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"screen_identifier", (ArgumentType)StringArgumentType.string()).executes(stack -> OpenGuiScreenCommand.openGui((FabricClientCommandSource)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"screen_identifier")))).suggests((context, provider) -> CommandUtils.getStringSuggestions((SuggestionsBuilder)provider, (String[])new String[]{"<screen_identifier>"})).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"target_players", (ArgumentType)class_2186.method_9308()).requires(stack -> stack.method_9259(2))).executes(stack -> OpenGuiScreenCommand.openGui((FabricClientCommandSource)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"screen_identifier"))))));
    }

    private static int openGui(FabricClientCommandSource stack, String menuIdentifierOrCustomGuiName) {
        try {
            if (CustomGuiHandler.guiExists(menuIdentifierOrCustomGuiName)) {
                MainThreadTaskExecutor.executeInMainThread(() -> class_310.method_1551().method_1507((class_437)CustomGuiHandler.constructInstance(menuIdentifierOrCustomGuiName, class_310.method_1551().field_1755, null)), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
            } else {
                class_437 s = ScreenInstanceFactory.tryConstruct(ScreenIdentifierHandler.getBestIdentifier(menuIdentifierOrCustomGuiName));
                if (s != null) {
                    MainThreadTaskExecutor.executeInMainThread(() -> class_310.method_1551().method_1507(s), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                } else {
                    stack.sendError((class_2561)class_2561.method_43469((String)"fancymenu.commmands.openguiscreen.unable_to_open_gui", (Object[])new Object[]{menuIdentifierOrCustomGuiName}));
                }
            }
        }
        catch (Exception e) {
            stack.sendError((class_2561)class_2561.method_43471((String)"fancymenu.commands.openguiscreen.error"));
            e.printStackTrace();
        }
        return 1;
    }
}

