/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.keksuccino.fancymenu.customization.variables.VariableHandler;
import de.keksuccino.fancymenu.events.ticking.ClientTickEvent;
import de.keksuccino.fancymenu.networking.packets.command.commands.variable.ServerboundVariableCommandSuggestionsPacketHandler;
import de.keksuccino.fancymenu.networking.packets.command.commands.variable.VariableCommandSuggestionsPacketMessage;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.konkrete.command.CommandUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1074;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;

public class VariableCommand {
    protected static class_437 lastScreen = null;
    protected static boolean initialized = false;

    public static void register(CommandDispatcher<FabricClientCommandSource> d) {
        if (!initialized) {
            EventHandler.INSTANCE.registerListenersOf(new VariableCommand());
            initialized = true;
        }
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"fmvariable").then(ClientCommandManager.literal((String)"get").then(ClientCommandManager.argument((String)"variable_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CommandUtils.getStringSuggestions((SuggestionsBuilder)builder, (String[])VariableCommand.getVariableNameSuggestions())).executes(stack -> VariableCommand.getVariable((FabricClientCommandSource)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"variable_name")))))).then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"variable_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CommandUtils.getStringSuggestions((SuggestionsBuilder)builder, (String[])VariableCommand.getVariableNameSuggestions())).then(ClientCommandManager.argument((String)"send_chat_feedback", (ArgumentType)BoolArgumentType.bool()).then(ClientCommandManager.argument((String)"set_to_value", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> CommandUtils.getStringSuggestions((SuggestionsBuilder)builder, (String[])new String[]{"<set_to_value>"})).executes(stack -> VariableCommand.setVariable((FabricClientCommandSource)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"variable_name"), StringArgumentType.getString((CommandContext)stack, (String)"set_to_value"), BoolArgumentType.getBool((CommandContext)stack, (String)"send_chat_feedback"))))))));
    }

    private static String[] getVariableNameSuggestions() {
        List<String> l = VariableHandler.getVariableNames();
        if (l.isEmpty()) {
            l.add("<no_variables_found>");
        }
        return l.toArray(new String[0]);
    }

    private static int getVariable(FabricClientCommandSource stack, String variableName) {
        MainThreadTaskExecutor.executeInMainThread(() -> {
            try {
                String s;
                String string = s = VariableHandler.variableExists(variableName) ? Objects.requireNonNull(VariableHandler.getVariable(variableName)).getValue() : null;
                if (s != null) {
                    stack.sendFeedback((class_2561)class_2561.method_43470((String)class_1074.method_4662((String)"fancymenu.commands.variable.get.success", (Object[])new Object[]{s})));
                } else {
                    stack.sendError((class_2561)class_2561.method_43470((String)class_1074.method_4662((String)"fancymenu.commands.variable.not_found", (Object[])new Object[0])));
                }
            }
            catch (Exception e) {
                stack.sendError((class_2561)class_2561.method_43470((String)"Error while executing command!"));
                e.printStackTrace();
            }
        }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
        return 1;
    }

    private static int setVariable(FabricClientCommandSource stack, String variableName, String setToValue, boolean sendFeedback) {
        MainThreadTaskExecutor.executeInMainThread(() -> {
            try {
                VariableHandler.setVariable(variableName, setToValue);
                if (sendFeedback) {
                    stack.sendFeedback((class_2561)class_2561.method_43470((String)class_1074.method_4662((String)"fancymenu.commands.variable.set.success", (Object[])new Object[]{setToValue})));
                }
            }
            catch (Exception e) {
                stack.sendError((class_2561)class_2561.method_43470((String)"Error while executing command!"));
                e.printStackTrace();
            }
        }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
        return 1;
    }

    @EventListener
    public void onClientTickPre(ClientTickEvent.Pre e) {
        class_437 s = class_310.method_1551().field_1755;
        if (s instanceof class_408 && (lastScreen == null || lastScreen != s)) {
            VariableCommandSuggestionsPacketMessage msg = new VariableCommandSuggestionsPacketMessage();
            msg.direction = "server";
            msg.variableNameSuggestions.addAll(Arrays.asList(VariableCommand.getVariableNameSuggestions()));
            ClientPlayNetworking.send((class_2960)ServerboundVariableCommandSuggestionsPacketHandler.PACKET_ID, (class_2540)ServerboundVariableCommandSuggestionsPacketHandler.writeToByteBuf(msg));
        }
        lastScreen = s;
    }
}

