/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.file;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.io.File;
import net.minecraft.class_2561;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyFileAction
extends Action {
    public CopyFileAction() {
        super("copyfile");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value != null && value.contains(";")) {
            try {
                String from = CopyFileAction.cleanPath(value.split(";", 2)[0]);
                String to = CopyFileAction.cleanPath(value.split(";", 2)[1]);
                File toFile = new File(to);
                File fromFile = new File(from);
                if (fromFile.isFile()) {
                    FileUtils.copyFile((File)fromFile, (File)toFile);
                } else if (fromFile.isDirectory()) {
                    FileUtils.copyDirectory((File)fromFile, (File)toFile);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static String cleanPath(String path) {
        int i = 0;
        for (char c : path.toCharArray()) {
            if (c != ' ') break;
            ++i;
        }
        if (i <= path.length()) {
            return path.substring(i).replace("\\", "/");
        }
        return "";
    }

    @Override
    @NotNull
    public class_2561 getActionDisplayName() {
        return class_2561.method_43471((String)"fancymenu.editor.custombutton.config.actiontype.copyfile");
    }

    @Override
    @NotNull
    public class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.editor.custombutton.config.actiontype.copyfile.desc", new String[0]);
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43471((String)"fancymenu.editor.custombutton.config.actiontype.copyfile.desc.value");
    }

    @Override
    public String getValueExample() {
        return "some/path/example.png;target/path/example.png";
    }
}

