/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.file;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.WebUtils;
import de.keksuccino.konkrete.input.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import net.minecraft.class_2561;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadFileAction
extends Action {
    public DownloadFileAction() {
        super("downloadfile");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value != null && value.contains(";")) {
            try {
                String url = StringUtils.convertFormatCodes((String)DownloadFileAction.cleanPath(value.split(";", 2)[0]), (String)"\u00a7", (String)"&");
                if (!WebUtils.isValidUrl(url)) {
                    return;
                }
                String path = DownloadFileAction.cleanPath(value.split(";", 2)[1]);
                File downloadTo = new File(path);
                InputStream in = new URL(url).openStream();
                FileUtils.copyInputStreamToFile((InputStream)in, (File)downloadTo);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static String cleanPath(String path) {
        int i = 0;
        for (char c : path.toCharArray()) {
            if (c != ' ') break;
            ++i;
        }
        if (i <= path.length()) {
            return path.substring(i).replace("\\", "/");
        }
        return "";
    }

    @Override
    @NotNull
    public class_2561 getActionDisplayName() {
        return class_2561.method_43471((String)"fancymenu.editor.custombutton.config.actiontype.downloadfile");
    }

    @Override
    @NotNull
    public class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.editor.custombutton.config.actiontype.downloadfile.desc", new String[0]);
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43471((String)"fancymenu.editor.custombutton.config.actiontype.downloadfile.desc.value");
    }

    @Override
    public String getValueExample() {
        return "some/path/example.png;new_name.png";
    }
}

