/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.file;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.io.File;
import net.minecraft.class_2561;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameFileAction
extends Action {
    public RenameFileAction() {
        super("renamefile");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value != null && value.contains(";")) {
            try {
                String path = RenameFileAction.cleanPath(value.split(";", 2)[0]);
                String name = value.split(";", 2)[1];
                File f = new File(path);
                if (f.exists()) {
                    String parent = f.getParent();
                    File renameTo = new File(name);
                    if (parent != null) {
                        renameTo = new File(parent + "/" + name);
                    }
                    if (renameTo.exists()) {
                        return;
                    }
                    if (f.isFile()) {
                        FileUtils.moveFile((File)f, (File)renameTo);
                    } else if (f.isDirectory()) {
                        FileUtils.moveDirectory((File)f, (File)renameTo);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static String cleanPath(String path) {
        int i = 0;
        for (char c : path.toCharArray()) {
            if (c != ' ') break;
            ++i;
        }
        if (i <= path.length()) {
            return path.substring(i).replace("\\", "/");
        }
        return "";
    }

    @Override
    @NotNull
    public class_2561 getActionDisplayName() {
        return class_2561.method_43471((String)"fancymenu.editor.custombutton.config.actiontype.renamefile");
    }

    @Override
    @NotNull
    public class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.editor.custombutton.config.actiontype.renamefile.desc", new String[0]);
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43471((String)"fancymenu.editor.custombutton.config.actiontype.renamefile.desc.value");
    }

    @Override
    public String getValueExample() {
        return "some/path/example.png;new_name.png";
    }
}

