/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.other;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.util.CloseableUtils;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecuteTerminalCommandAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();

    public ExecuteTerminalCommandAction() {
        super("runcmd");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value != null) {
            ExecuteTerminalCommandAction.handleCommandValue(value);
        }
    }

    protected static void handleCommandValue(@NotNull String commandValue) {
        try {
            if ((commandValue.contains("[windows:") || commandValue.contains("[macos:") || commandValue.contains("[linux:")) && commandValue.contains("];")) {
                String command = ExecuteTerminalCommandAction.isMacOS() ? ExecuteTerminalCommandAction.getOSCommand(commandValue, "macos") : (ExecuteTerminalCommandAction.isWindows() ? ExecuteTerminalCommandAction.getOSCommand(commandValue, "windows") : ExecuteTerminalCommandAction.getOSCommand(commandValue, "linux"));
                if (command != null) {
                    ExecuteTerminalCommandAction.executeTerminalCommand(command);
                } else {
                    LOGGER.error("[FANCYMENU] Failed to execute Terminal/CMD command via action! Missing OS name!");
                }
            } else {
                ExecuteTerminalCommandAction.executeTerminalCommand(commandValue);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Nullable
    protected static String getOSCommand(@NotNull String value, @NotNull String osId) {
        String s;
        value = value.replace("];", "&%e%&;");
        if ((value = value.replace("[" + osId + ":", "&%s%&" + osId + ":")).contains("&%s%&") && value.contains("&%e%&;") && value.contains("&%s%&" + osId + ":") && (s = value.split("&%s%&" + osId + ":", 2)[1]).contains("&%e%&;")) {
            if ((s = s.split("&%e%&;", 2)[0]).replace(" ", "").isEmpty()) {
                return null;
            }
            return s;
        }
        return null;
    }

    private static void executeTerminalCommand(@NotNull String command) {
        new Thread(() -> {
            BufferedReader reader = null;
            Logger logger = LogManager.getLogger();
            try {
                Process process = Runtime.getRuntime().exec(command);
                if (process != null) {
                    String output;
                    logger.info("[FANCYMENU] Executing Terminal/CMD command via action: " + command);
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((output = reader.readLine()) != null) {
                        logger.info("[FANCYMENU] TERMINAL OUT: " + output);
                    }
                    logger.info("[FANCYMENU] Finished executing Terminal/CMD command.");
                }
            }
            catch (Exception ex) {
                logger.error("[FANCYMENU] Failed to execute terminal command!", (Throwable)ex);
            }
            CloseableUtils.closeQuietly(reader);
        }).start();
    }

    private static boolean isMacOS() {
        return class_310.field_1703;
    }

    private static boolean isWindows() {
        String s = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        return s.contains("win");
    }

    @Override
    @NotNull
    public class_2561 getActionDisplayName() {
        return class_2561.method_43471((String)"fancymenu.editor.custombutton.config.actiontype.runcmd");
    }

    @Override
    @NotNull
    public class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.editor.custombutton.config.actiontype.runcmd.desc", new String[0]);
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43473();
    }

    @Override
    public String getValueExample() {
        return "[windows:run.bat]; [macos:./Run]; [linux:./run.sh];";
    }

    @Override
    public void editValue(@NotNull class_437 parentScreen, @NotNull ActionInstance instance) {
        ExecuteTerminalCommandActionValueScreen s = new ExecuteTerminalCommandActionValueScreen(Objects.requireNonNullElse(instance.value, this.getValueExample()), value -> {
            if (value != null) {
                instance.value = value;
            }
            class_310.method_1551().method_1507(parentScreen);
        });
        class_310.method_1551().method_1507((class_437)s);
    }

    public static class ExecuteTerminalCommandActionValueScreen
    extends StringBuilderScreen {
        @NotNull
        protected String windowsCommand;
        @NotNull
        protected String macOsCommand;
        @NotNull
        protected String linuxCommand;

        protected ExecuteTerminalCommandActionValueScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((class_2561)class_2561.method_43471((String)"fancymenu.editor.actions.execute_terminal_command.edit"), callback);
            this.windowsCommand = ExecuteTerminalCommandAction.getOSCommand(value, "windows");
            this.macOsCommand = ExecuteTerminalCommandAction.getOSCommand(value, "macos");
            this.linuxCommand = ExecuteTerminalCommandAction.getOSCommand(value, "linux");
            if (this.windowsCommand == null && this.macOsCommand == null && this.linuxCommand == null) {
                this.windowsCommand = value;
                this.macOsCommand = value;
                this.linuxCommand = value;
            }
            if (this.windowsCommand == null) {
                this.windowsCommand = "";
            }
            if (this.macOsCommand == null) {
                this.macOsCommand = "";
            }
            if (this.linuxCommand == null) {
                this.linuxCommand = "";
            }
        }

        @Override
        protected void initCells() {
            this.addSpacerCell(20);
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.editor.actions.execute_terminal_command.edit.desc.line1"));
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.editor.actions.execute_terminal_command.edit.desc.line2"));
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.editor.actions.execute_terminal_command.edit.desc.line3"));
            this.addDescriptionEndSeparatorCell();
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.editor.actions.execute_terminal_command.windows"));
            this.addTextInputCell(null, true, true).setEditListener(s -> {
                this.windowsCommand = s;
            }).setText(this.windowsCommand);
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.editor.actions.execute_terminal_command.macos"));
            this.addTextInputCell(null, true, true).setEditListener(s -> {
                this.macOsCommand = s;
            }).setText(this.macOsCommand);
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.editor.actions.execute_terminal_command.linux"));
            this.addTextInputCell(null, true, true).setEditListener(s -> {
                this.linuxCommand = s;
            }).setText(this.linuxCommand);
            this.addSpacerCell(20);
        }

        @Override
        @NotNull
        public String buildString() {
            return "[windows:" + this.windowsCommand + "]; [macos:" + this.macOsCommand + "]; [linux:" + this.linuxCommand + "];";
        }
    }
}

