/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.background;

import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.background.SerializedMenuBackground;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MenuBackgroundBuilder<T extends MenuBackground> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String identifier;

    public MenuBackgroundBuilder(String uniqueIdentifier) {
        this.identifier = uniqueIdentifier;
    }

    public boolean isDeprecated() {
        return false;
    }

    public abstract void buildNewOrEditInstance(@Nullable class_437 var1, @Nullable T var2, @NotNull Consumer<T> var3);

    public void buildNewOrEditInstanceInternal(@Nullable class_437 currentScreen, @Nullable MenuBackground backgroundToEdit, Consumer<MenuBackground> backgroundConsumer) {
        try {
            this.buildNewOrEditInstance(currentScreen, backgroundToEdit, backgroundConsumer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public abstract T deserializeBackground(SerializedMenuBackground var1);

    @Nullable
    public T deserializeBackgroundInternal(SerializedMenuBackground serializedMenuBackground) {
        try {
            return this.deserializeBackground(serializedMenuBackground);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to deserialize menu background: " + this.getIdentifier());
            ex.printStackTrace();
            return null;
        }
    }

    public abstract SerializedMenuBackground serializedBackground(T var1);

    @Nullable
    public SerializedMenuBackground serializedBackgroundInternal(MenuBackground background) {
        try {
            SerializedMenuBackground b = this.serializedBackground(background);
            b.putProperty("background_type", this.getIdentifier());
            return b;
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to serialize menu background: " + this.getIdentifier());
            ex.printStackTrace();
            return null;
        }
    }

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public abstract class_2561 getDisplayName();

    @Nullable
    public abstract class_2561[] getDescription();
}

