/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.audio;

import de.keksuccino.fancymenu.customization.element.elements.audio.AudioElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.resource.ResourceChooserScreen;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageAudiosScreen
extends CellScreen {
    @NotNull
    protected List<AudioElement.AudioInstance> audios;
    @NotNull
    protected AudioElement element;
    @NotNull
    protected List<AudioElement.AudioInstance> tempAudios;
    protected LayoutEditorScreen editor;
    @Nullable
    protected String lastSelectedSource;

    protected ManageAudiosScreen(@NotNull AudioElement element, @NotNull List<AudioElement.AudioInstance> audios, @NotNull LayoutEditorScreen editor) {
        super((class_2561)class_2561.method_43471((String)"fancymenu.elements.audio.manage_audios"));
        this.audios = Objects.requireNonNull(audios);
        this.tempAudios = new ArrayList<AudioElement.AudioInstance>(audios);
        this.element = element;
        this.editor = editor;
    }

    @Override
    protected void initCells() {
        this.addSpacerCell(10);
        for (AudioElement.AudioInstance instance : this.tempAudios) {
            class_5250 sourceName = class_2561.method_43470((String)"[").method_10852((class_2561)instance.supplier.getSourceType().getValueComponent().method_10862(class_2583.field_24360)).method_27693("] ").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
            class_5250 name = class_2561.method_43470((String)instance.supplier.getSourceWithoutPrefix()).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
            CellScreen.RenderCell cell = this.addLabelCell((class_2561)sourceName.method_10852((class_2561)name)).putMemoryValue("source", instance.supplier.getSourceWithPrefix()).setHeight(80).setSelectable(true);
            if (this.lastSelectedSource == null || !instance.supplier.getSourceWithPrefix().equals(this.lastSelectedSource)) continue;
            cell.setSelected(true);
            this.lastSelectedSource = null;
        }
        this.addStartEndSpacerCell();
    }

    @Override
    protected void updateSelectedCell() {
        super.updateSelectedCell();
        CellScreen.RenderCell selected = this.getSelectedCell();
        this.lastSelectedSource = selected != null ? selected.getMemoryValue("source") : null;
    }

    @Override
    protected void initRightSideWidgets() {
        this.addRightSideButton(20, (class_2561)class_2561.method_43471((String)"fancymenu.elements.audio.manage_audios.add_audio"), button -> class_310.method_1551().method_1507(ResourceChooserScreen.audio(null, s -> {
            if (s != null) {
                this.addAudio((String)s);
            }
            class_310.method_1551().method_1507((class_437)this);
        })));
        this.addRightSideDefaultSpacer();
        this.addRightSideButton(20, (class_2561)class_2561.method_43471((String)"fancymenu.elements.audio.manage_audios.remove_audio"), extendedButton -> {
            String source;
            CellScreen.RenderCell selected = this.getSelectedCell();
            if (selected != null && (source = selected.getMemoryValue("source")) != null) {
                class_310.method_1551().method_1507((class_437)ConfirmationScreen.warning(aBoolean -> {
                    if (aBoolean.booleanValue()) {
                        this.removeAudio(source);
                    }
                    class_310.method_1551().method_1507((class_437)this);
                }, LocalizationUtils.splitLocalizedLines("fancymenu.elements.audio.manage_audios.remove_audio.confirm", new String[0])));
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedCell() != null);
        this.addRightSideDefaultSpacer();
        this.addRightSideButton(20, (class_2561)class_2561.method_43471((String)"fancymenu.elements.audio.manage_audios.move_up"), extendedButton -> {
            String source;
            CellScreen.RenderCell selected = this.getSelectedCell();
            if (selected != null && (source = selected.getMemoryValue("source")) != null) {
                this.moveAudioUp(source);
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedCell() != null);
        this.addRightSideButton(20, (class_2561)class_2561.method_43471((String)"fancymenu.elements.audio.manage_audios.move_down"), extendedButton -> {
            String source;
            CellScreen.RenderCell selected = this.getSelectedCell();
            if (selected != null && (source = selected.getMemoryValue("source")) != null) {
                this.moveAudioDown(source);
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedCell() != null);
    }

    protected void removeAudio(@NotNull String source) {
        this.tempAudios.removeIf(audioInstance -> audioInstance.supplier.getSourceWithPrefix().equals(source));
        this.rebuild();
    }

    protected void addAudio(@NotNull String source) {
        this.tempAudios.add(new AudioElement.AudioInstance(ResourceSupplier.audio(source)));
        this.rebuild();
    }

    protected void moveAudioUp(@NotNull String source) {
        AudioElement.AudioInstance instance = this.findAudio(source);
        if (instance != null) {
            ListUtils.offsetIndexOf(this.tempAudios, instance, -1);
        }
        this.rebuild();
    }

    protected void moveAudioDown(@NotNull String source) {
        AudioElement.AudioInstance instance = this.findAudio(source);
        if (instance != null) {
            ListUtils.offsetIndexOf(this.tempAudios, instance, 1);
        }
        this.rebuild();
    }

    @Nullable
    protected AudioElement.AudioInstance findAudio(@NotNull String source) {
        for (AudioElement.AudioInstance instance : this.tempAudios) {
            if (!instance.supplier.getSourceWithPrefix().equals(source)) continue;
            return instance;
        }
        return null;
    }

    @Override
    protected void onCancel() {
        class_310.method_1551().method_1507((class_437)this.editor);
    }

    @Override
    protected void onDone() {
        this.audios.clear();
        this.audios.addAll(this.tempAudios);
        this.element.resetAudioElementKeepAudios();
        class_310.method_1551().method_1507((class_437)this.editor);
    }
}

