/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.button.custombutton;

import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.customization.animation.AnimationHandler;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.ExecutableElement;
import de.keksuccino.fancymenu.customization.element.elements.button.custombutton.ButtonEditorElement;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinButton;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.resource.RenderableResource;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButtonElement
extends AbstractElement
implements ExecutableElement {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private class_339 widget;
    public ResourceSupplier<IAudio> clickSound;
    public ResourceSupplier<IAudio> hoverSound;
    @Nullable
    public String label;
    @Nullable
    public String hoverLabel;
    public String tooltip;
    public ResourceSupplier<ITexture> backgroundTextureNormal;
    public ResourceSupplier<ITexture> backgroundTextureHover;
    public ResourceSupplier<ITexture> backgroundTextureInactive;
    public String backgroundAnimationNormal;
    public String backgroundAnimationHover;
    public String backgroundAnimationInactive;
    public boolean loopBackgroundAnimations = true;
    public boolean restartBackgroundAnimationsOnHover = true;
    @NotNull
    public GenericExecutableBlock actionExecutor = new GenericExecutableBlock();

    public ButtonElement(ElementBuilder<ButtonElement, ButtonEditorElement> builder) {
        super(builder);
    }

    @Override
    public void tick() {
        if (this.getWidget() == null) {
            return;
        }
        this.updateWidget();
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.getWidget() == null) {
            return;
        }
        this.updateWidget();
        if (!this.shouldRender()) {
            return;
        }
        if (ButtonElement.isEditor()) {
            class_339 class_3392 = this.getWidget();
            if (class_3392 instanceof ExtendedButton) {
                ExtendedButton e = (ExtendedButton)class_3392;
                e.setPressAction(button -> {});
            } else {
                class_3392 = this.getWidget();
                if (class_3392 instanceof class_4185) {
                    class_4185 b = (class_4185)class_3392;
                    ((IMixinButton)b).setPressActionFancyMenu(button -> {});
                }
            }
            this.getWidget().field_22764 = true;
            this.getWidget().field_22763 = true;
            this.getWidget().method_47400(null);
        }
        this.renderElementWidget(graphics, mouseX, mouseY, partial);
        RenderingUtils.resetShaderColor(graphics);
    }

    protected void renderElementWidget(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.getWidget() != null) {
            this.getWidget().method_25394(graphics, mouseX, mouseY, partial);
        }
    }

    @Override
    @Nullable
    public List<class_364> getWidgetsToRegister() {
        if (this.getWidget() == null) {
            return null;
        }
        return List.of(this.getWidget());
    }

    public void updateWidget() {
        this.updateWidgetVisibility();
        this.updateWidgetAlpha();
        this.updateWidgetTooltip();
        this.updateWidgetLabels();
        this.updateWidgetHoverSound();
        this.updateWidgetClickSound();
        this.updateWidgetTexture();
        this.updateWidgetSize();
        this.updateWidgetPosition();
    }

    public void updateWidgetVisibility() {
        class_339 class_3392 = this.getWidget();
        if (class_3392 instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)class_3392;
            w.setHiddenFancyMenu(!this.shouldRender());
        }
    }

    public void updateWidgetAlpha() {
        if (this.getWidget() == null) {
            return;
        }
        this.getWidget().method_25350(this.opacity);
    }

    public void updateWidgetPosition() {
        if (this.getWidget() == null) {
            return;
        }
        this.getWidget().method_46421(this.getAbsoluteX());
        this.getWidget().method_46419(this.getAbsoluteY());
    }

    public void updateWidgetSize() {
        if (this.getWidget() == null) {
            return;
        }
        this.getWidget().method_25358(this.getAbsoluteWidth());
        ((IMixinAbstractWidget)this.getWidget()).setHeightFancyMenu(this.getAbsoluteHeight());
    }

    public void updateWidgetTooltip() {
        if (this.tooltip != null && this.getWidget() != null && this.getWidget().method_49606() && !ButtonElement.isEditor()) {
            String tooltip = this.tooltip.replace("%n%", "\n");
            TooltipHandler.INSTANCE.addWidgetTooltip(this.getWidget(), Tooltip.of(StringUtils.splitLines((String)PlaceholderParser.replacePlaceholders(tooltip), (String)"\n")), false, true);
        }
    }

    public void updateWidgetLabels() {
        if (this.getWidget() == null) {
            return;
        }
        if (this.label != null) {
            this.getWidget().method_25355(ButtonElement.buildComponent(this.label));
        } else {
            this.getWidget().method_25355((class_2561)class_2561.method_43473());
        }
        if (this.hoverLabel != null && this.getWidget().method_25367() && this.getWidget().field_22763) {
            this.getWidget().method_25355(ButtonElement.buildComponent(this.hoverLabel));
        }
    }

    public void updateWidgetHoverSound() {
        class_339 class_3392 = this.getWidget();
        if (class_3392 instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)class_3392;
            w.setHoverSoundFancyMenu(this.hoverSound != null ? this.hoverSound.get() : null);
        }
    }

    public void updateWidgetClickSound() {
        class_339 class_3392 = this.getWidget();
        if (class_3392 instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)class_3392;
            w.setCustomClickSoundFancyMenu(this.clickSound != null ? this.clickSound.get() : null);
        }
    }

    public void updateWidgetTexture() {
        class_339 class_3392;
        AdvancedAnimation a;
        IAnimationRenderer r;
        RenderableResource backNormal = null;
        RenderableResource backHover = null;
        RenderableResource backInactive = null;
        if (this.backgroundAnimationNormal != null && AnimationHandler.animationExists(this.backgroundAnimationNormal) && (r = AnimationHandler.getAnimation(this.backgroundAnimationNormal)) instanceof AdvancedAnimation) {
            a = (AdvancedAnimation)r;
            a.setLooped(this.loopBackgroundAnimations);
            backNormal = a;
        }
        if (backNormal == null && this.backgroundTextureNormal != null) {
            backNormal = this.backgroundTextureNormal.get();
        }
        if (this.backgroundAnimationHover != null && AnimationHandler.animationExists(this.backgroundAnimationHover) && (r = AnimationHandler.getAnimation(this.backgroundAnimationHover)) instanceof AdvancedAnimation) {
            a = (AdvancedAnimation)r;
            a.setLooped(this.loopBackgroundAnimations);
            backHover = a;
        }
        if (backHover == null && this.backgroundTextureHover != null) {
            backHover = this.backgroundTextureHover.get();
        }
        if (this.backgroundAnimationInactive != null && AnimationHandler.animationExists(this.backgroundAnimationInactive) && (r = AnimationHandler.getAnimation(this.backgroundAnimationInactive)) instanceof AdvancedAnimation) {
            a = (AdvancedAnimation)r;
            a.setLooped(this.loopBackgroundAnimations);
            backInactive = a;
        }
        if (backInactive == null && this.backgroundTextureInactive != null) {
            backInactive = this.backgroundTextureInactive.get();
        }
        if ((class_3392 = this.getWidget()) instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)class_3392;
            w.setCustomBackgroundNormalFancyMenu(backNormal);
            w.setCustomBackgroundHoverFancyMenu(backHover);
            w.setCustomBackgroundInactiveFancyMenu(backInactive);
            w.setCustomBackgroundResetBehaviorFancyMenu(this.restartBackgroundAnimationsOnHover ? CustomizableWidget.CustomBackgroundResetBehavior.RESET_ON_HOVER : CustomizableWidget.CustomBackgroundResetBehavior.RESET_NEVER);
        }
    }

    @Nullable
    public class_339 getWidget() {
        return this.widget;
    }

    public void setWidget(@Nullable class_339 widget) {
        this.widget = widget;
    }

    @Override
    @NotNull
    public GenericExecutableBlock getExecutableBlock() {
        return this.actionExecutor;
    }
}

