/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.customization.animation.AnimationHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseAnimationScreen
extends class_437 {
    protected Consumer<String> callback;
    protected String selectedAnimationName = null;
    protected IAnimationRenderer selectedAnimation = null;
    protected ScrollArea animationListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton doneButton;
    protected ExtendedButton cancelButton;

    public ChooseAnimationScreen(@Nullable String preSelectedAnimation, @NotNull Consumer<String> callback) {
        super((class_2561)class_2561.method_43471((String)"fancymenu.animation.choose"));
        this.callback = callback;
        this.updateAnimationScrollAreaContent();
        if (preSelectedAnimation != null) {
            for (ScrollAreaEntry e : this.animationListScrollArea.getEntries()) {
                if (!(e instanceof AnimationScrollEntry)) continue;
                AnimationScrollEntry a = (AnimationScrollEntry)e;
                if (!a.animation.equals(preSelectedAnimation)) continue;
                a.setSelected(true);
                this.setSelectedAnimation(a);
                break;
            }
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.doneButton = new ExtendedButton(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.guicomponents.done"), button -> this.callback.accept(this.selectedAnimationName)){

            @Override
            public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
                if (ChooseAnimationScreen.this.selectedAnimationName == null) {
                    TooltipHandler.INSTANCE.addWidgetTooltip((class_339)this, Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.animation.choose.no_animation_selected", new String[0])).setDefaultStyle(), false, true);
                    this.field_22763 = false;
                } else {
                    this.field_22763 = true;
                }
                super.method_48579(graphics, mouseX, mouseY, partial);
            }
        };
        this.method_25429((class_364)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
        this.cancelButton = new ExtendedButton(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.guicomponents.cancel"), button -> this.callback.accept(null));
        this.method_25429((class_364)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
    }

    public void method_25419() {
        this.callback.accept(null);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        RenderSystem.enableBlend();
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        class_5250 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        graphics.method_51439(this.field_22793, (class_2561)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"fancymenu.animation.choose.available_animations"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.animationListScrollArea.setWidth(this.field_22789 / 2 - 40, true);
        this.animationListScrollArea.setHeight(this.field_22790 - 85, true);
        this.animationListScrollArea.setX(20, true);
        this.animationListScrollArea.setY(65, true);
        this.animationListScrollArea.render(graphics, mouseX, mouseY, partial);
        class_5250 previewLabel = class_2561.method_43471((String)"fancymenu.animation.choose.preview");
        int previewLabelWidth = this.field_22793.method_27525((class_5348)previewLabel);
        graphics.method_51439(this.field_22793, (class_2561)previewLabel, this.field_22789 - 20 - previewLabelWidth, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        if (this.selectedAnimation != null) {
            int aniW = this.field_22789 / 2 - 40;
            int aniH = this.field_22790 / 2;
            AspectRatio ratio = new AspectRatio(this.selectedAnimation.getWidth(), this.selectedAnimation.getHeight());
            int[] size = ratio.getAspectRatioSizeByMaximumSize(aniW, aniH);
            aniW = size[0];
            aniH = size[1];
            int aniX = this.field_22789 - 20 - aniW;
            int aniY = 65;
            boolean cachedLooped = this.selectedAnimation.isGettingLooped();
            graphics.method_25294(aniX, aniY, aniX + aniW, aniY + aniH, UIBase.getUIColorTheme().area_background_color.getColorInt());
            this.selectedAnimation.setLooped(false);
            this.selectedAnimation.setPosX(aniX);
            this.selectedAnimation.setPosY(aniY);
            this.selectedAnimation.setWidth(aniW);
            this.selectedAnimation.setHeight(aniH);
            this.selectedAnimation.render(graphics);
            this.selectedAnimation.setLooped(cachedLooped);
            UIBase.renderBorder(graphics, aniX, aniY, aniX + aniW, aniY + aniH, 1, UIBase.getUIColorTheme().element_border_color_normal.getColor(), true, true, true, true);
        }
        this.doneButton.method_46421(this.field_22789 - 20 - this.doneButton.method_25368());
        this.doneButton.method_46419(this.field_22790 - 20 - 20);
        this.doneButton.method_25394(graphics, mouseX, mouseY, partial);
        this.cancelButton.method_46421(this.field_22789 - 20 - this.cancelButton.method_25368());
        this.cancelButton.method_46419(this.doneButton.method_46427() - 5 - 20);
        this.cancelButton.method_25394(graphics, mouseX, mouseY, partial);
        super.method_25394(graphics, mouseX, mouseY, partial);
    }

    protected void setSelectedAnimation(@Nullable AnimationScrollEntry entry) {
        if (this.selectedAnimation != null) {
            this.selectedAnimation.resetAnimation();
            if (this.selectedAnimation instanceof AdvancedAnimation) {
                ((AdvancedAnimation)this.selectedAnimation).stopAudio();
                ((AdvancedAnimation)this.selectedAnimation).resetAudio();
            }
        }
        if (entry == null) {
            this.selectedAnimation = null;
            this.selectedAnimationName = null;
            return;
        }
        this.selectedAnimationName = entry.animation;
        this.selectedAnimation = AnimationHandler.getAnimation(entry.animation);
        if (this.selectedAnimation != null) {
            this.selectedAnimation.resetAnimation();
            if (this.selectedAnimation instanceof AdvancedAnimation) {
                ((AdvancedAnimation)this.selectedAnimation).stopAudio();
                ((AdvancedAnimation)this.selectedAnimation).resetAudio();
            }
        }
    }

    protected void updateAnimationScrollAreaContent() {
        this.animationListScrollArea.clearEntries();
        for (String s : AnimationHandler.getExternalAnimationNames()) {
            ScrollAreaEntry e = new AnimationScrollEntry(this.animationListScrollArea, s, entry -> this.setSelectedAnimation((AnimationScrollEntry)entry));
            this.animationListScrollArea.addEntry(e);
        }
        if (this.animationListScrollArea.getEntries().isEmpty()) {
            this.animationListScrollArea.addEntry(new TextScrollAreaEntry(this.animationListScrollArea, (class_2561)class_2561.method_43471((String)"fancymenu.animation.choose.no_animations"), entry -> {}));
        }
        int totalWidth = this.animationListScrollArea.getTotalEntryWidth();
        for (ScrollAreaEntry e : this.animationListScrollArea.getEntries()) {
            e.setWidth(totalWidth);
        }
    }

    public boolean method_25404(int button, int $$1, int $$2) {
        if (button == 257 && this.selectedAnimationName != null) {
            this.callback.accept(this.selectedAnimationName);
            return true;
        }
        return super.method_25404(button, $$1, $$2);
    }

    public static class AnimationScrollEntry
    extends TextListScrollAreaEntry {
        public String animation;

        public AnimationScrollEntry(ScrollArea parent, @NotNull String animation, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, (class_2561)class_2561.method_43470((String)animation).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.animation = animation;
        }
    }
}

