/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.overlay;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.overlay.CustomizationOverlayUI;
import de.keksuccino.fancymenu.customization.overlay.DebugOverlay;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.events.screen.ScreenKeyPressedEvent;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.util.rendering.ui.menubar.v2.MenuBar;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CustomizableScreen;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class CustomizationOverlay {
    private static final Logger LOGGER = LogManager.getLogger();
    private static MenuBar overlayMenuBar;
    private static DebugOverlay debugOverlay;

    public static void init() {
        EventHandler.INSTANCE.registerListenersOf(new CustomizationOverlay());
    }

    public static void rebuildOverlay() {
        overlayMenuBar = CustomizationOverlayUI.buildMenuBar(overlayMenuBar == null || overlayMenuBar.isExpanded());
        CustomizationOverlay.rebuildDebugOverlay();
    }

    public static void rebuildDebugOverlay() {
        if (debugOverlay != null) {
            debugOverlay.resetOverlay();
        }
        debugOverlay = CustomizationOverlayUI.buildDebugOverlay(overlayMenuBar);
    }

    @Nullable
    public static MenuBar getCurrentMenuBarInstance() {
        return overlayMenuBar;
    }

    @Nullable
    public static DebugOverlay getCurrentDebugOverlayInstance() {
        return debugOverlay;
    }

    @EventListener(priority=-1000)
    public void onInitScreenPost(InitOrResizeScreenCompletedEvent e) {
        CustomizableScreen c;
        CustomizationOverlay.rebuildOverlay();
        e.getWidgets().add(0, overlayMenuBar);
        class_437 class_4372 = e.getScreen();
        if (class_4372 instanceof CustomizableScreen) {
            c = (CustomizableScreen)class_4372;
            c.removeOnInitChildrenFancyMenu().add(overlayMenuBar);
        }
        e.getWidgets().add(1, (class_364)debugOverlay);
        class_4372 = e.getScreen();
        if (class_4372 instanceof CustomizableScreen) {
            c = (CustomizableScreen)class_4372;
            c.removeOnInitChildrenFancyMenu().add((class_364)debugOverlay);
        }
    }

    @EventListener(priority=-1)
    public void onRenderPost(RenderScreenEvent.Post e) {
        if (!ScreenCustomization.isScreenBlacklisted(e.getScreen().getClass().getName()) && overlayMenuBar != null && debugOverlay != null) {
            if (FancyMenu.getOptions().showDebugOverlay.getValue().booleanValue()) {
                debugOverlay.method_25394(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
            }
            if (FancyMenu.getOptions().showCustomizationOverlay.getValue().booleanValue()) {
                overlayMenuBar.method_25394(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
            }
        }
    }

    @EventListener
    public void onScreenKeyPressed(ScreenKeyPressedEvent e) {
        if (!ScreenCustomization.isScreenBlacklisted(e.getScreen().getClass().getName())) {
            String keyName = e.getKeyName();
            if (keyName.equals("c") && class_437.method_25441() && class_437.method_25443()) {
                FancyMenu.getOptions().showCustomizationOverlay.setValue(FancyMenu.getOptions().showCustomizationOverlay.getValue() == false);
                ScreenCustomization.reInitCurrentScreen();
            }
            if (keyName.equals("d") && class_437.method_25441() && class_437.method_25443()) {
                FancyMenu.getOptions().showDebugOverlay.setValue(FancyMenu.getOptions().showDebugOverlay.getValue() == false);
                ScreenCustomization.reInitCurrentScreen();
            }
            if (keyName.equals("r") && class_437.method_25441() && class_437.method_25443()) {
                ScreenCustomization.reloadFancyMenu();
            }
        }
    }
}

