/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.screen;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.screen.identifier.UniversalScreenIdentifierRegistry;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1076;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_437;
import net.minecraft.class_5375;
import net.minecraft.class_632;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenInstanceFactory {
    private static final Map<Class<?>, Object> DEFAULT_PARAMETERS = new HashMap();
    private static final Map<String, Supplier<? extends class_437>> SCREEN_INSTANCE_PROVIDERS = new HashMap<String, Supplier<? extends class_437>>();

    public static void registerScreenProvider(@NotNull String screenClassPath, @NotNull Supplier<? extends class_437> provider) {
        SCREEN_INSTANCE_PROVIDERS.put(screenClassPath, provider);
    }

    @Nullable
    public static Supplier<? extends class_437> getScreenProvider(@NotNull String screenClassPath) {
        return SCREEN_INSTANCE_PROVIDERS.get(screenClassPath);
    }

    @Nullable
    public static class_437 tryConstruct(@NotNull String screenClassPathOrIdentifier) {
        try {
            Constructor<?>[] constructors;
            Supplier<? extends class_437> screenProvider;
            String nonUniversal;
            if (UniversalScreenIdentifierRegistry.universalIdentifierExists(screenClassPathOrIdentifier) && (nonUniversal = UniversalScreenIdentifierRegistry.getScreenForUniversalIdentifier(screenClassPathOrIdentifier)) != null) {
                screenClassPathOrIdentifier = nonUniversal;
            }
            if (ScreenCustomization.isScreenBlacklisted(screenClassPathOrIdentifier = ScreenIdentifierHandler.tryFixInvalidIdentifierWithNonUniversal(screenClassPathOrIdentifier))) {
                return null;
            }
            DEFAULT_PARAMETERS.put(class_437.class, class_310.method_1551().field_1755);
            DEFAULT_PARAMETERS.put(class_1657.class, class_310.method_1551().field_1724);
            if (class_310.method_1551().field_1724 != null) {
                DEFAULT_PARAMETERS.put(class_632.class, class_310.method_1551().field_1724.field_3944.method_2869());
            }
            if ((screenProvider = ScreenInstanceFactory.getScreenProvider(screenClassPathOrIdentifier)) != null) {
                return screenProvider.get();
            }
            Class<?> screenClass = Class.forName(screenClassPathOrIdentifier, false, ScreenInstanceFactory.class.getClassLoader());
            if (class_437.class.isAssignableFrom(screenClass) && (constructors = screenClass.getConstructors()).length > 0) {
                Constructor<?> constructor = null;
                for (Constructor<?> c : constructors) {
                    if (c.getParameterTypes().length != 0) continue;
                    constructor = c;
                    break;
                }
                if (constructor == null) {
                    for (Constructor<?> c : constructors) {
                        if (!ScreenInstanceFactory.allParametersSupported(c.getParameterTypes())) continue;
                        constructor = c;
                        break;
                    }
                }
                if (constructor != null) {
                    Class<?>[] parameters = constructor.getParameterTypes();
                    ArrayList<Object> parameterInstances = new ArrayList<Object>();
                    for (Class<?> p : parameters) {
                        parameterInstances.add(DEFAULT_PARAMETERS.get(p));
                    }
                    return ScreenInstanceFactory.createInstance(constructor, parameterInstances);
                }
                return null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static boolean allParametersSupported(Class<?>[] parameters) {
        for (Class<?> par : parameters) {
            if (DEFAULT_PARAMETERS.containsKey(par)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static class_437 createInstance(@NotNull Constructor<?> constructor, @Nullable List<Object> parameters) {
        try {
            if (parameters == null || parameters.isEmpty()) {
                return (class_437)constructor.newInstance(new Object[0]);
            }
            return (class_437)constructor.newInstance(parameters.toArray(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        DEFAULT_PARAMETERS.put(class_310.class, class_310.method_1551());
        DEFAULT_PARAMETERS.put(class_437.class, null);
        DEFAULT_PARAMETERS.put(class_315.class, class_310.method_1551().field_1690);
        DEFAULT_PARAMETERS.put(class_1076.class, class_310.method_1551().method_1526());
        DEFAULT_PARAMETERS.put(class_1657.class, null);
        DEFAULT_PARAMETERS.put(String.class, "");
        DEFAULT_PARAMETERS.put(class_632.class, null);
        DEFAULT_PARAMETERS.put(class_2561.class, class_2561.method_43473());
        DEFAULT_PARAMETERS.put(Boolean.TYPE, true);
        DEFAULT_PARAMETERS.put(Integer.TYPE, 0);
        DEFAULT_PARAMETERS.put(Long.TYPE, 0L);
        DEFAULT_PARAMETERS.put(Double.TYPE, 0.0);
        DEFAULT_PARAMETERS.put(Float.TYPE, Float.valueOf(0.0f));
        DEFAULT_PARAMETERS.put(Boolean.class, true);
        DEFAULT_PARAMETERS.put(Integer.class, 0);
        DEFAULT_PARAMETERS.put(Long.class, 0L);
        DEFAULT_PARAMETERS.put(Double.class, 0.0);
        DEFAULT_PARAMETERS.put(Float.class, Float.valueOf(0.0f));
        ScreenInstanceFactory.registerScreenProvider(class_5375.class.getName(), () -> new class_5375(class_310.method_1551().method_1520(), repo -> {
            class_310.method_1551().field_1690.method_49598(repo);
            class_310.method_1551().method_1507(class_310.method_1551().field_1755);
        }, class_310.method_1551().method_1479(), (class_2561)class_2561.method_43471((String)"resourcePack.title")));
    }
}

