/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.slideshow;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.properties.PropertiesParser;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.fancymenu.util.properties.PropertyContainerSet;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class ExternalTextureSlideshowRenderer {
    protected List<ResourceSupplier<ITexture>> images = new ArrayList<ResourceSupplier<ITexture>>();
    protected ResourceSupplier<ITexture> overlayTexture;
    protected String name = null;
    public String dir;
    protected boolean prepared = false;
    protected double imageDuration = 10.0;
    protected float fadeSpeed = 1.0f;
    protected int originalWidth = 10;
    protected int originalHeight = 10;
    public int width = 50;
    public int height = 50;
    public int x = 0;
    public int y = 0;
    protected float opacity = 1.0f;
    protected int imageTick = -1;
    protected long opacityTick = -1L;
    protected long lastChange = -1L;
    protected boolean firstLoop = true;
    public float slideshowOpacity = 1.0f;
    protected ResourceSupplier<ITexture> previous;
    protected ResourceSupplier<ITexture> current;

    public ExternalTextureSlideshowRenderer(String slideshowDir) {
        List<PropertyContainer> l;
        PropertyContainerSet s;
        this.dir = slideshowDir;
        File props = new File(this.dir + "/properties.txt");
        if (!props.isFile()) {
            props = new File(this.dir + "/properties.txt.txt");
        }
        if (props.exists() && (s = PropertiesParser.deserializeSetFromFile(props.getPath())) != null && !(l = s.getContainersOfType("slideshow-meta")).isEmpty()) {
            String sh;
            String sw;
            String sy;
            String sx;
            String fs;
            this.name = l.get(0).getValue("name");
            String dur = l.get(0).getValue("duration");
            if (dur != null && MathUtils.isDouble((String)dur)) {
                this.imageDuration = Double.parseDouble(dur);
            }
            if ((fs = l.get(0).getValue("fadespeed")) != null && MathUtils.isFloat((String)fs)) {
                float f = Float.parseFloat(fs);
                if (f < 0.0f) {
                    f = 0.0f;
                }
                this.fadeSpeed = f;
            }
            if ((sx = l.get(0).getValue("x")) != null && MathUtils.isInteger((String)sx)) {
                this.x = Integer.parseInt(sx);
            }
            if ((sy = l.get(0).getValue("y")) != null && MathUtils.isInteger((String)sy)) {
                this.y = Integer.parseInt(sy);
            }
            if ((sw = l.get(0).getValue("width")) != null && MathUtils.isInteger((String)sw)) {
                this.width = Integer.parseInt(sw);
            }
            if ((sh = l.get(0).getValue("height")) != null && MathUtils.isInteger((String)sh)) {
                this.height = Integer.parseInt(sh);
            }
        }
    }

    public void prepareSlideshow() {
        File imagesDir;
        if (!this.prepared && this.name != null && (imagesDir = new File(GameDirectoryUtils.getAbsoluteGameDirectoryPath(this.dir + "/images"))).exists() && imagesDir.isDirectory()) {
            ArrayList images;
            String[] list = imagesDir.list();
            ArrayList arrayList = images = list != null ? Arrays.asList(list) : new ArrayList();
            if (!images.isEmpty()) {
                File overlay;
                ITexture t;
                images.sort(String.CASE_INSENSITIVE_ORDER);
                for (String s : images) {
                    File f = new File(imagesDir.getPath() + "/" + s);
                    if (!f.exists() || !f.isFile() || !f.getPath().toLowerCase().endsWith(".jpg") && !f.getPath().toLowerCase().endsWith(".png")) continue;
                    this.images.add(ResourceSupplier.image(f.getPath()));
                }
                if (!this.images.isEmpty() && (t = this.images.get(0).get()) != null) {
                    t.waitForReady(5000L);
                    this.originalWidth = t.getWidth();
                    this.originalHeight = t.getHeight();
                }
                if ((overlay = new File(this.dir + "/overlay.png")).exists()) {
                    this.overlayTexture = ResourceSupplier.image(overlay.getPath());
                }
            }
            this.prepared = true;
        }
    }

    public void render(class_332 graphics) {
        try {
            if (!this.images.isEmpty()) {
                this.tick();
                this.renderCurrent(graphics);
                this.renderPrevious(graphics);
                this.renderOverlay(graphics);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void tick() {
        if (!this.images.isEmpty()) {
            long time = System.currentTimeMillis();
            long duration = (long)(1000.0 * this.imageDuration);
            long opacityTickSpeed = 25L;
            if (this.firstLoop) {
                duration /= 2L;
            }
            if (this.previous == null && this.lastChange + duration < time) {
                ++this.imageTick;
                if (this.imageTick > this.images.size() - 1) {
                    this.imageTick = 0;
                }
                this.lastChange = time;
                this.opacity = 1.0f;
                this.previous = this.current;
                this.current = this.images.get(this.imageTick);
            }
            if (this.previous != null && this.opacity > 0.0f) {
                this.firstLoop = false;
                if (this.opacityTick + opacityTickSpeed < time) {
                    this.opacityTick = time;
                    this.opacity -= 0.005f * this.fadeSpeed;
                    if (this.opacity < 0.0f) {
                        this.opacity = 0.0f;
                    }
                }
            } else {
                this.previous = null;
            }
        }
    }

    protected void renderPrevious(class_332 graphics) {
        if (this.previous != null && this.current != this.previous) {
            class_2960 loc;
            graphics.method_51448().method_22903();
            RenderSystem.enableBlend();
            float o = this.opacity;
            if (o > this.slideshowOpacity) {
                o = this.slideshowOpacity;
            }
            graphics.method_51422(1.0f, 1.0f, 1.0f, o);
            ITexture t = this.previous.get();
            class_2960 class_29602 = loc = t != null ? t.getResourceLocation() : null;
            if (loc != null) {
                graphics.method_25290(loc, this.x, this.y, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
            graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.method_51448().method_22909();
        }
    }

    protected void renderCurrent(class_332 graphics) {
        if (this.current != null) {
            class_2960 loc;
            RenderSystem.enableBlend();
            graphics.method_51422(1.0f, 1.0f, 1.0f, this.slideshowOpacity);
            ITexture t = this.current.get();
            class_2960 class_29602 = loc = t != null ? t.getResourceLocation() : null;
            if (loc != null) {
                graphics.method_25290(loc, this.x, this.y, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        }
    }

    protected void renderOverlay(class_332 graphics) {
        if (this.overlayTexture != null) {
            class_2960 loc;
            RenderSystem.enableBlend();
            graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            ITexture t = this.overlayTexture.get();
            class_2960 class_29602 = loc = t != null ? t.getResourceLocation() : null;
            if (loc != null) {
                graphics.method_25290(loc, this.x, this.y, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setDuration(double duration) {
        this.imageDuration = duration;
    }

    public void setFadeSpeed(float speed) {
        if (speed < 0.0f) {
            speed = 0.0f;
        }
        this.fadeSpeed = speed;
    }

    public boolean isReady() {
        return this.prepared;
    }

    public int getImageWidth() {
        return this.originalWidth;
    }

    public int getImageHeight() {
        return this.originalHeight;
    }

    public int getImageCount() {
        return this.images.size();
    }
}

