/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.widget;

import de.keksuccino.fancymenu.customization.widget.WidgetMeta;
import de.keksuccino.fancymenu.customization.widget.identification.WidgetIdentifierHandler;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ScreenWidgetDiscoverer {
    private static final Logger LOGGER = LogManager.getLogger();

    @NotNull
    public static List<WidgetMeta> getWidgetsOfScreen(@NotNull class_437 screen, boolean updateScreenSize, boolean firstInit) {
        int newWidth = screen.field_22789;
        int newHeight = screen.field_22790;
        if (updateScreenSize) {
            newWidth = class_310.method_1551().method_22683().method_4486();
            newHeight = class_310.method_1551().method_22683().method_4502();
        }
        return ScreenWidgetDiscoverer.getWidgetsOfScreen(screen, newWidth, newHeight, firstInit);
    }

    @NotNull
    public static List<WidgetMeta> getWidgetsOfScreen(@NotNull class_437 screen, int newWidth, int newHeight, boolean firstInit) {
        LinkedHashMap<Long, WidgetMeta> widgetMetas = new LinkedHashMap<Long, WidgetMeta>();
        try {
            List<WidgetMeta> ids = ScreenWidgetDiscoverer.getWidgetsOfScreenInternal(screen, 1000, 1000, firstInit);
            List<WidgetMeta> buttons = ScreenWidgetDiscoverer.getWidgetsOfScreenInternal(screen, newWidth, newHeight, firstInit);
            if (buttons.size() == ids.size()) {
                int i = 0;
                for (WidgetMeta id : ids) {
                    WidgetMeta button = buttons.get(i);
                    if (!widgetMetas.containsKey(id.getLongIdentifier())) {
                        widgetMetas.put(id.getLongIdentifier(), new WidgetMeta(button.getWidget(), id.getLongIdentifier(), screen));
                    }
                    ++i;
                }
            }
            ArrayList<String> universalIdentifiers = new ArrayList<String>();
            for (WidgetMeta meta : widgetMetas.values()) {
                WidgetIdentifierHandler.setUniversalIdentifierOfWidgetMeta(meta);
                if (universalIdentifiers.contains(meta.getUniversalIdentifier())) {
                    meta.setUniversalIdentifier(null);
                    continue;
                }
                universalIdentifiers.add(meta.getUniversalIdentifier());
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to get widgets of screen!", (Throwable)ex);
        }
        return new ArrayList<WidgetMeta>(widgetMetas.values());
    }

    @NotNull
    private static List<WidgetMeta> getWidgetsOfScreenInternal(@NotNull class_437 screen, int screenWidth, int screenHeight, boolean firstInit) {
        ArrayList<WidgetMeta> widgetMetaList = new ArrayList<WidgetMeta>();
        ArrayList ids = new ArrayList();
        try {
            if (firstInit) {
                screen.method_25423(class_310.method_1551(), screenWidth, screenHeight);
            } else {
                screen.method_25410(class_310.method_1551(), screenWidth, screenHeight);
            }
            ((IMixinScreen)screen).getRenderablesFancyMenu().forEach(renderable -> ScreenWidgetDiscoverer.visitWidget(renderable, ids, widgetMetaList, screen));
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to get widgets of screen!", (Throwable)ex);
        }
        return widgetMetaList;
    }

    private static void visitWidget(@NotNull Object widget, @NotNull List<Long> ids, @NotNull List<WidgetMeta> widgetMetaList, @NotNull class_437 screen) {
        if (widget instanceof class_339) {
            class_339 w = (class_339)widget;
            String idRaw = "" + w.method_46426() + w.method_46427();
            long id = 0L;
            if (MathUtils.isLong((String)idRaw)) {
                id = ScreenWidgetDiscoverer.getAvailableIdFromBaseId(Long.parseLong(idRaw), ids);
            }
            ids.add(id);
            widgetMetaList.add(new WidgetMeta(w, id, screen));
        }
    }

    private static Long getAvailableIdFromBaseId(long baseId, List<Long> ids) {
        String newId;
        if (ids.contains(baseId) && MathUtils.isLong((String)(newId = baseId + "1"))) {
            return ScreenWidgetDiscoverer.getAvailableIdFromBaseId(Long.parseLong(newId), ids);
        }
        return baseId;
    }
}

