/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.tooltip;

import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.class_339;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TooltipHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final TooltipHandler INSTANCE = new TooltipHandler();
    private final List<HandledTooltip> tooltips = new ArrayList<HandledTooltip>();
    private final Map<class_339, HandledTooltip> widgetTooltips = new HashMap<class_339, HandledTooltip>();

    public TooltipHandler() {
        EventHandler.INSTANCE.registerListenersOf(this);
    }

    @EventListener(priority=-1000)
    public void onScreenRenderPost(RenderScreenEvent.Post e) {
        HandledTooltip renderTooltip = null;
        for (HandledTooltip t : new ArrayList<HandledTooltip>(this.tooltips)) {
            if (t.shouldRender.getAsBoolean()) {
                renderTooltip = t;
            }
            if (!t.removeAfterScreenRender) continue;
            t.remove();
        }
        if (renderTooltip != null) {
            renderTooltip.tooltip.method_25394(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
        }
    }

    @EventListener(priority=1000)
    public void onScreenInitResizePre(InitOrResizeScreenEvent.Pre e) {
        for (HandledTooltip t : new ArrayList<HandledTooltip>(this.tooltips)) {
            if (!t.removeOnScreenInitOrResize) continue;
            t.remove();
        }
    }

    public HandledTooltip addWidgetTooltip(@NotNull class_339 widget, @NotNull Tooltip tooltip) {
        return this.addWidgetTooltip(widget, tooltip, true, false);
    }

    public HandledTooltip addWidgetTooltip(@NotNull class_339 widget, @NotNull Tooltip tooltip, boolean removeOnScreenInitOrResize, boolean removeAfterScreenRender) {
        if (this.widgetTooltips.containsKey(widget)) {
            this.removeTooltip(this.widgetTooltips.get(widget));
        }
        HandledTooltip t = this.addTooltip(tooltip, () -> ((class_339)widget).method_49606(), removeOnScreenInitOrResize, removeAfterScreenRender);
        t.widget = widget;
        this.widgetTooltips.put(widget, t);
        return t;
    }

    public HandledTooltip addTooltip(@NotNull Tooltip tooltip, @NotNull BooleanSupplier shouldRender, boolean removeOnScreenInitOrResize, boolean removeAfterScreenRender) {
        HandledTooltip t = new HandledTooltip(this, tooltip, shouldRender, removeOnScreenInitOrResize, removeAfterScreenRender);
        this.tooltips.add(t);
        return t;
    }

    public void removeTooltip(HandledTooltip tooltip) {
        this.tooltips.remove(tooltip);
        if (tooltip.widget != null) {
            this.widgetTooltips.remove(tooltip.widget);
        }
    }

    public static class HandledTooltip {
        private final TooltipHandler parent;
        public final Tooltip tooltip;
        public final BooleanSupplier shouldRender;
        public final boolean removeOnScreenInitOrResize;
        public final boolean removeAfterScreenRender;
        protected class_339 widget = null;

        private HandledTooltip(TooltipHandler parent, Tooltip tooltip, BooleanSupplier shouldRender, boolean removeOnScreenInitOrResize, boolean removeAfterScreenRender) {
            this.parent = parent;
            this.tooltip = tooltip;
            this.shouldRender = shouldRender;
            this.removeOnScreenInitOrResize = removeOnScreenInitOrResize;
            this.removeAfterScreenRender = removeAfterScreenRender;
        }

        public void remove() {
            this.parent.removeTooltip(this);
        }
    }
}

