/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.resource.resources.texture;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.util.CloseableUtils;
import de.keksuccino.fancymenu.util.ObjectHolder;
import de.keksuccino.fancymenu.util.WebUtils;
import de.keksuccino.fancymenu.util.input.TextValidators;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.resource.PlayableResource;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.konkrete.rendering.GifDecoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GifTexture
implements ITexture,
PlayableResource {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    protected volatile List<GifFrame> frames = new ArrayList<GifFrame>();
    @Nullable
    protected volatile GifFrame current = null;
    @NotNull
    protected volatile AspectRatio aspectRatio = new AspectRatio(10, 10);
    protected volatile int width = 10;
    protected volatile int height = 10;
    protected volatile long lastResourceLocationCall = -1L;
    protected final AtomicBoolean tickerThreadRunning = new AtomicBoolean(false);
    protected final AtomicBoolean decoded = new AtomicBoolean(false);
    protected volatile boolean allFramesDecoded = false;
    protected class_2960 sourceLocation;
    protected File sourceFile;
    protected String sourceURL;
    protected final AtomicBoolean loadingCompleted = new AtomicBoolean(false);
    protected final AtomicBoolean loadingFailed = new AtomicBoolean(false);
    protected final String uniqueId = ScreenCustomization.generateUniqueIdentifier();
    protected int frameRegistrationCounter = 0;
    protected final AtomicBoolean closed = new AtomicBoolean(false);

    @NotNull
    public static GifTexture location(@NotNull class_2960 location) {
        return GifTexture.location(location, null);
    }

    @NotNull
    public static GifTexture location(@NotNull class_2960 location, @Nullable GifTexture writeTo) {
        Objects.requireNonNull(location);
        GifTexture texture = writeTo != null ? writeTo : new GifTexture();
        texture.sourceLocation = location;
        try {
            GifTexture.of(class_310.method_1551().method_1478().open(location), location.toString(), texture);
        }
        catch (Exception ex) {
            texture.loadingFailed.set(true);
            LOGGER.error("[FANCYMENU] Failed to read GIF image from ResourceLocation: " + location, (Throwable)ex);
        }
        return texture;
    }

    @NotNull
    public static GifTexture local(@NotNull File gif) {
        return GifTexture.local(gif, null);
    }

    @NotNull
    public static GifTexture local(@NotNull File gif, @Nullable GifTexture writeTo) {
        Objects.requireNonNull(gif);
        GifTexture texture = writeTo != null ? writeTo : new GifTexture();
        texture.sourceFile = gif;
        if (!gif.isFile()) {
            texture.loadingFailed.set(true);
            LOGGER.error("[FANCYMENU] Failed to read GIF image from file! File not found: " + gif.getPath());
            return texture;
        }
        new Thread(() -> {
            try {
                FileInputStream in = new FileInputStream(gif);
                GifTexture.of(in, gif.getPath(), texture);
            }
            catch (Exception ex) {
                texture.loadingFailed.set(true);
                LOGGER.error("[FANCYMENU] Failed to read GIF image from file: " + gif.getPath(), (Throwable)ex);
            }
        }).start();
        return texture;
    }

    @NotNull
    public static GifTexture web(@NotNull String gifUrl) {
        return GifTexture.web(gifUrl, null);
    }

    @NotNull
    public static GifTexture web(@NotNull String gifUrl, @Nullable GifTexture writeTo) {
        Objects.requireNonNull(gifUrl);
        GifTexture texture = writeTo != null ? writeTo : new GifTexture();
        texture.sourceURL = gifUrl;
        if (!TextValidators.BASIC_URL_TEXT_VALIDATOR.get(Objects.requireNonNull(gifUrl)).booleanValue()) {
            texture.loadingFailed.set(true);
            LOGGER.error("[FANCYMENU] Failed to read GIF image from URL! Invalid URL: " + gifUrl);
            return texture;
        }
        new Thread(() -> {
            InputStream in = null;
            ByteArrayInputStream byteIn = null;
            try {
                in = WebUtils.openResourceStream(gifUrl);
                if (in == null) {
                    throw new NullPointerException("Web resource input stream was NULL!");
                }
                byteIn = new ByteArrayInputStream(in.readAllBytes());
            }
            catch (Exception ex) {
                texture.loadingFailed.set(true);
                LOGGER.error("[FANCYMENU] Failed to read GIF image from URL: " + gifUrl, (Throwable)ex);
            }
            if (byteIn != null) {
                GifTexture.of(byteIn, gifUrl, texture);
            }
            CloseableUtils.closeQuietly(in);
        }).start();
        return texture;
    }

    @NotNull
    public static GifTexture of(@NotNull InputStream in) {
        return GifTexture.of(in, null, null);
    }

    @NotNull
    public static GifTexture of(@NotNull InputStream in, @Nullable String gifTextureName, @Nullable GifTexture writeTo) {
        Objects.requireNonNull(in);
        GifTexture texture = writeTo != null ? writeTo : new GifTexture();
        new Thread(() -> {
            String name = gifTextureName != null ? gifTextureName : "[Generic InputStream Source]";
            GifTexture.populateTexture(texture, in, name);
            if (texture.closed.get()) {
                MainThreadTaskExecutor.executeInMainThread(texture::close, MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK);
            }
        }).start();
        return texture;
    }

    protected static void populateTexture(@NotNull GifTexture texture, @NotNull InputStream in, @NotNull String gifTextureName) {
        if (!texture.closed.get()) {
            try {
                DecodedGifImage decodedImage = GifTexture.decodeGif(in);
                ObjectHolder<Boolean> sizeSet = ObjectHolder.of(false);
                GifTexture.deliverFrames(decodedImage.image, gifTextureName, frame -> {
                    if (frame != null) {
                        try {
                            frame.nativeImage = class_1011.method_4309((InputStream)frame.frameInputStream);
                            texture.frames.add((GifFrame)frame);
                            if (!((Boolean)sizeSet.get()).booleanValue()) {
                                texture.width = frame.nativeImage.method_4307();
                                texture.height = frame.nativeImage.method_4323();
                                texture.aspectRatio = new AspectRatio(frame.nativeImage.method_4307(), frame.nativeImage.method_4323());
                                texture.decoded.set(true);
                                sizeSet.set(true);
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.error("[FANCYMENU] Failed to read frame of GIF image into NativeImage: " + gifTextureName, (Throwable)ex);
                        }
                        CloseableUtils.closeQuietly(frame.closeAfterLoading);
                        CloseableUtils.closeQuietly(frame.frameInputStream);
                    }
                });
                texture.loadingCompleted.set(true);
                texture.allFramesDecoded = true;
            }
            catch (Exception ex) {
                texture.loadingFailed.set(true);
                LOGGER.error("[FANCYMENU] Failed to decode GIF image: " + gifTextureName, (Throwable)ex);
            }
        }
        texture.decoded.set(true);
        CloseableUtils.closeQuietly(in);
    }

    protected GifTexture() {
    }

    protected void startTickerIfNeeded() {
        if (!(this.tickerThreadRunning.get() || this.frames.isEmpty() || this.closed.get())) {
            this.tickerThreadRunning.set(true);
            this.lastResourceLocationCall = System.currentTimeMillis();
            new Thread(() -> {
                while (this.lastResourceLocationCall + 10000L > System.currentTimeMillis() && !this.frames.isEmpty() && !this.closed.get()) {
                    boolean sleep = false;
                    try {
                        boolean cachedAllDecoded = this.allFramesDecoded;
                        ArrayList<GifFrame> cachedFrames = new ArrayList<GifFrame>(this.frames);
                        if (!cachedFrames.isEmpty()) {
                            GifFrame cachedCurrent;
                            if (this.current == null) {
                                this.current = (GifFrame)cachedFrames.get(0);
                                Thread.sleep(Math.max(20L, (long)((GifFrame)cachedFrames.get((int)0)).delay * 10L));
                            }
                            if ((cachedCurrent = this.current) != null) {
                                GifFrame newCurrent = null;
                                if (cachedCurrent.index + 1 < cachedFrames.size()) {
                                    newCurrent = (GifFrame)cachedFrames.get(cachedCurrent.index + 1);
                                } else if (cachedAllDecoded) {
                                    newCurrent = (GifFrame)cachedFrames.get(0);
                                }
                                if (newCurrent != null) {
                                    this.current = newCurrent;
                                }
                                Thread.sleep(Math.max(20L, newCurrent != null ? (long)newCurrent.delay * 10L : 100L));
                            } else {
                                sleep = true;
                            }
                        } else {
                            sleep = true;
                        }
                    }
                    catch (Exception ex) {
                        sleep = true;
                        ex.printStackTrace();
                    }
                    if (!sleep) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                    }
                }
                this.tickerThreadRunning.set(false);
            }).start();
        }
    }

    @Override
    @Nullable
    public class_2960 getResourceLocation() {
        if (this.closed.get()) {
            return FULLY_TRANSPARENT_TEXTURE;
        }
        this.lastResourceLocationCall = System.currentTimeMillis();
        this.startTickerIfNeeded();
        GifFrame frame = this.current;
        if (frame != null) {
            if (frame.resourceLocation == null && !frame.loaded && frame.nativeImage != null) {
                try {
                    ++this.frameRegistrationCounter;
                    frame.dynamicTexture = new class_1043(frame.nativeImage);
                    frame.resourceLocation = class_310.method_1551().method_1531().method_4617("fancymenu_gif_frame_" + this.uniqueId + "_" + this.frameRegistrationCounter, frame.dynamicTexture);
                }
                catch (Exception ex) {
                    LOGGER.error("[FANCYMENU] Failed to register GIF frame to Minecraft's TextureManager!", (Throwable)ex);
                }
                frame.loaded = true;
            }
            return frame.resourceLocation != null ? frame.resourceLocation : FULLY_TRANSPARENT_TEXTURE;
        }
        return null;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public AspectRatio getAspectRatio() {
        return this.aspectRatio;
    }

    @Override
    @Nullable
    public InputStream open() throws IOException {
        if (this.sourceURL != null) {
            return WebUtils.openResourceStream(this.sourceURL);
        }
        if (this.sourceFile != null) {
            return new FileInputStream(this.sourceFile);
        }
        if (this.sourceLocation != null) {
            return class_310.method_1551().method_1478().open(this.sourceLocation);
        }
        return null;
    }

    @Override
    public boolean isReady() {
        return this.decoded.get();
    }

    @Override
    public boolean isLoadingCompleted() {
        return !this.closed.get() && !this.loadingFailed.get() && this.loadingCompleted.get();
    }

    @Override
    public boolean isLoadingFailed() {
        return this.loadingFailed.get();
    }

    @Override
    public void reset() {
        this.current = null;
        ArrayList<GifFrame> l = new ArrayList<GifFrame>(this.frames);
        if (!l.isEmpty()) {
            this.current = (GifFrame)l.get(0);
        }
    }

    @Override
    public void play() {
    }

    @Override
    public void pause() {
    }

    @Override
    public boolean isPaused() {
        return false;
    }

    @Override
    public void stop() {
        this.reset();
    }

    @Override
    public boolean isPlaying() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        this.closed.set(true);
        this.sourceLocation = null;
        for (GifFrame frame : new ArrayList<GifFrame>(this.frames)) {
            try {
                if (frame.dynamicTexture != null) {
                    frame.dynamicTexture.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to close DynamicTexture of GIF frame!", (Throwable)ex);
            }
            try {
                if (frame.nativeImage != null) {
                    frame.nativeImage.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to close NativeImage of GIF frame!", (Throwable)ex);
            }
            frame.dynamicTexture = null;
            frame.nativeImage = null;
        }
        this.frames = new ArrayList<GifFrame>();
        this.current = null;
    }

    @NotNull
    public static DecodedGifImage decodeGif(@NotNull InputStream in) throws IOException {
        GifDecoder.GifImage gif = GifDecoder.read((InputStream)in);
        return new DecodedGifImage(gif);
    }

    public static void deliverFrames(@NotNull GifDecoder.GifImage gif, @NotNull String gifName, @NotNull Consumer<GifFrame> frameDelivery) {
        int gifFrameCount = gif.getFrameCount();
        int index = 0;
        for (int i = 0; i < gifFrameCount; ++i) {
            try {
                int delay = gif.getDelay(i);
                BufferedImage image = gif.getFrame(i);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "PNG", os);
                ByteArrayInputStream bis = new ByteArrayInputStream(os.toByteArray());
                frameDelivery.accept(new GifFrame(index, bis, delay, os));
                ++index;
                continue;
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to get frame '" + i + "' of GIF image '" + gifName + "!", (Throwable)ex);
            }
        }
    }

    public record DecodedGifImage(@NotNull GifDecoder.GifImage image) {
    }

    public static class GifFrame {
        protected final int index;
        protected final ByteArrayInputStream frameInputStream;
        protected final int delay;
        protected final ByteArrayOutputStream closeAfterLoading;
        protected volatile class_1011 nativeImage;
        protected class_1043 dynamicTexture;
        protected class_2960 resourceLocation;
        protected boolean loaded = false;

        protected GifFrame(int index, ByteArrayInputStream frameInputStream, int delay, ByteArrayOutputStream closeAfterLoading) {
            this.index = index;
            this.frameInputStream = frameInputStream;
            this.delay = delay;
            this.closeAfterLoading = closeAfterLoading;
        }
    }
}

