/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.SNBTNet;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.net.FTBUltimineNet;
import dev.ftb.mods.ftbultimine.net.SyncConfigFromServerPacket;
import dev.ftb.mods.ftbultimine.net.SyncUltimineTimePacket;
import java.nio.file.Path;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SyncConfigToServerPacket
extends BaseC2SMessage {
    private final SNBTCompoundTag config;

    public SyncConfigToServerPacket(SNBTCompoundTag config) {
        this.config = config;
    }

    public SyncConfigToServerPacket(class_2540 buf) {
        this.config = SNBTNet.readCompound((class_2540)buf);
    }

    public MessageType getType() {
        return FTBUltimineNet.SYNC_CONFIG_TO_SERVER;
    }

    public void write(class_2540 buf) {
        SNBTNet.writeCompound((class_2540)buf, (SNBTCompoundTag)this.config);
    }

    public void handle(NetworkManager.PacketContext context) {
        class_3222 sp;
        class_1657 class_16572 = context.getPlayer();
        if (class_16572 instanceof class_3222 && (sp = (class_3222)class_16572).method_5687(2)) {
            MinecraftServer server = sp.method_5682();
            FTBUltimine.LOGGER.info("Server config updated from client by player {}", (Object)sp.method_5477().getString());
            FTBUltimineServerConfig.CONFIG.read(this.config);
            FTBUltimineServerConfig.clearTagCache();
            Path file = server.method_27050(ConfigUtil.SERVER_CONFIG_DIR).resolve(FTBUltimineServerConfig.CONFIG.key + ".snbt");
            FTBUltimineServerConfig.CONFIG.save(file);
            for (class_3222 player : server.method_3760().method_14571()) {
                if (!sp.method_5667().equals(player.method_5667())) {
                    new SyncConfigFromServerPacket(this.config).sendTo(player);
                }
                new SyncUltimineTimePacket(FTBUltimineServerConfig.getUltimineCooldown(player), SyncUltimineTimePacket.TimeType.COOLDOWN).sendTo(player);
            }
        }
    }
}

