/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.dimension;

import earth.terrarium.adastra.client.dimension.ModSkyRenderer;
import earth.terrarium.adastra.client.dimension.PlanetRenderer;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5294;
import net.minecraft.class_638;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ModDimensionSpecialEffects
extends class_5294 {
    private final PlanetRenderer renderer;
    private final ModSkyRenderer skyRenderer;

    public ModDimensionSpecialEffects(PlanetRenderer renderer) {
        super(192.0f, true, class_5294.class_5401.field_25640, false, false);
        this.renderer = renderer;
        this.skyRenderer = new ModSkyRenderer(renderer);
    }

    public boolean renderClouds(class_638 level, int ticks, float partialTick, class_4587 poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
        return this.renderer.customClouds();
    }

    public boolean renderSky(class_638 level, int ticks, float partialTick, class_4587 poseStack, class_4184 camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        this.skyRenderer.render(level, partialTick, poseStack, camera, projectionMatrix, isFoggy, setupFog);
        return this.renderer.customSky();
    }

    public boolean renderSnowAndRain(class_638 level, int ticks, float partialTick, class_765 lightTexture, double camX, double camY, double camZ) {
        return this.renderer.customWeather();
    }

    public class_243 method_28112(class_243 fogColor, float brightness) {
        if (this.renderer.hasFog()) {
            return fogColor.method_18805((double)brightness * 0.94 + 0.06, (double)brightness * 0.94 + 0.06, (double)brightness * 0.91 + 0.09);
        }
        return class_243.field_1353;
    }

    public boolean method_28110(int x, int y) {
        return this.renderer.hasThickFog();
    }

    @Nullable
    public float[] method_28109(float timeOfDay, float partialTicks) {
        if (this.renderer.sunriseAngle() != 0) {
            return null;
        }
        return ModDimensionSpecialEffects.getSunriseColor(timeOfDay, partialTicks, this.renderer.sunriseColor());
    }

    @Nullable
    public static float[] getSunriseColor(float timeOfDay, float partialTicks, int sunColor) {
        float timeCos = class_3532.method_15362((float)(timeOfDay * ((float)Math.PI * 2)));
        if (timeCos >= -0.4f && timeCos <= 0.4f) {
            float time = timeCos / 0.4f * 0.5f + 0.5f;
            float alpha = 1.0f - (1.0f - class_3532.method_15374((float)(time * (float)Math.PI))) * 0.99f;
            alpha *= alpha;
            float[] rgba = new float[]{time * 0.3f + (float)class_5253.class_5254.method_27765((int)sunColor) / 255.0f * 0.7f, time * time * 0.7f + (float)class_5253.class_5254.method_27766((int)sunColor) / 255.0f * 0.5f, (float)class_5253.class_5254.method_27767((int)sunColor) / 255.0f * 0.6f, alpha};
            return rgba;
        }
        return null;
    }

    public PlanetRenderer renderer() {
        return this.renderer;
    }
}

