/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.entities.vehicles;

import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.client.radio.audio.RadioHandler;
import earth.terrarium.adastra.common.entities.vehicles.Vehicle;
import earth.terrarium.adastra.common.menus.vehicles.RoverMenu;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ClientboundPlayStationPacket;
import earth.terrarium.adastra.common.registry.ModDamageSources;
import earth.terrarium.adastra.common.registry.ModItems;
import earth.terrarium.adastra.common.tags.ModFluidTags;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.adastra.common.utils.radio.RadioHolder;
import earth.terrarium.botarium.common.fluid.FluidApi;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_6026;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class Rover
extends Vehicle
implements class_6026,
RadioHolder {
    private static final float MAX_SPEED_KM = 50.0f;
    private static final float ACCELERATION_RATE = 0.02f;
    public static final class_2940<Long> FUEL = class_2945.method_12791(Rover.class, (class_2941)class_2943.field_39965);
    public static final class_2940<String> FUEL_TYPE = class_2945.method_12791(Rover.class, (class_2941)class_2943.field_13326);
    private final SimpleFluidContainer fluidContainer = new SimpleFluidContainer(FluidConstants.fromMillibuckets((long)3000L), 1, (amount, fluid) -> fluid.is(ModFluidTags.TIER_1_ROVER_FUEL));
    private float speed;
    private float angle;
    public float wheelXRot;
    public float wheelYRot;
    private String radioUrl = "";

    public Rover(class_1299<?> type, class_1937 level) {
        super(type, level);
        this.method_49477(1.0f);
        this.addPart(0.6f, 0.7f, new Vector3f(0.6f, 1.0f, 0.5f), (player, hand) -> {
            if (player.method_5854() instanceof Rover) {
                if (player.method_37908().method_8608()) {
                    RadioHandler.open(null);
                }
                return class_1269.method_29236((boolean)player.method_37908().method_8608());
            }
            return class_1269.field_5811;
        });
        this.addPart(1.1f, 0.7f, new Vector3f(0.15f, 0.8f, -1.7f), (player, hand) -> {
            if (!this.method_37908().method_8608()) {
                this.method_6722((class_1657)player);
            }
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        });
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FUEL, (Object)0L);
        this.field_6011.method_12784(FUEL_TYPE, (Object)"air");
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.speed = compound.method_10583("Speed");
        this.angle = compound.method_10583("Angle");
        this.fluidContainer.deserialize(compound);
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10548("Speed", this.speed);
        compound.method_10548("Angle", this.angle);
        this.fluidContainer.serialize(compound);
    }

    public FluidContainer fluidContainer() {
        return this.fluidContainer;
    }

    @Override
    public class_1799 getDropStack() {
        ItemStackHolder stack = new ItemStackHolder(((class_1792)ModItems.ROVER.get()).method_7854());
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)stack);
        if (container == null) {
            return stack.getStack();
        }
        FluidApi.moveFluid((FluidContainer)this.fluidContainer, (FluidContainer)container, (FluidHolder)this.fluidContainer.getFirstFluid(), (boolean)false);
        return stack.getStack();
    }

    protected boolean method_5818(class_1297 passenger) {
        return this.method_5685().size() < 2;
    }

    private void clampRotation(class_1297 entityToUpdate) {
        entityToUpdate.method_5636(this.method_36454());
        float degrees = class_3532.method_15393((float)(entityToUpdate.method_36454() - this.method_36454()));
        float lookAngle = class_3532.method_15363((float)degrees, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_5982 += lookAngle - degrees;
        entityToUpdate.method_36456(entityToUpdate.method_36454() + lookAngle - degrees);
        entityToUpdate.method_5847(entityToUpdate.method_36454());
    }

    public void method_5644(class_1297 entityToUpdate) {
        this.clampRotation(entityToUpdate);
    }

    @NotNull
    public class_243 method_24829(class_1309 passenger) {
        float zOffset = this.method_5642() == passenger ? 1.75f : -1.75f;
        class_243 position = new class_243(-0.5, 0.0, (double)zOffset).method_1024(-this.method_36454() * ((float)Math.PI / 180) - 1.5707964f);
        if (this.method_37908().method_8608()) {
            RadioHandler.stop();
        }
        return new class_243(this.method_23317() + position.field_1352, this.method_23318(), this.method_23321() + position.field_1350);
    }

    @Override
    public boolean isSafeToDismount(class_1657 player) {
        return this.speed() < 0.1f;
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 callback) {
        if (!this.method_5626(passenger)) {
            return;
        }
        float zOffset = this.method_5642() == passenger ? -0.6f : 0.4f;
        float yOffset = (float)((this.method_31481() ? (double)0.01f : this.method_5621()) + passenger.method_5678());
        class_243 position = new class_243(-0.5, 0.0, (double)zOffset).method_1024(-this.method_36454() * ((float)Math.PI / 180) - 1.5707964f);
        this.clampRotation(passenger);
        passenger.method_36456(passenger.method_36454() + this.angle);
        passenger.method_5847(passenger.method_5791() + this.angle);
        callback.accept(passenger, this.method_23317() + position.field_1352, this.method_23318() + (double)yOffset, this.method_23321() + position.field_1350);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.handleVehicleMovementTick();
        this.doEntityCollisionTick();
        if (!this.method_37908().method_8608()) {
            FluidUtils.moveItemToContainer((class_1263)this.inventory, (FluidContainer)this.fluidContainer, 0, 1, 0);
            FluidUtils.moveContainerToItem((class_1263)this.inventory, (FluidContainer)this.fluidContainer, 0, 1, 0);
            FluidHolder fluidHolder = this.fluidContainer.getFirstFluid();
            this.field_6011.method_12778(FUEL, (Object)fluidHolder.getFluidAmount());
            this.field_6011.method_12778(FUEL_TYPE, (Object)class_7923.field_41173.method_10221((Object)fluidHolder.getFluid()).toString());
        }
    }

    private void handleVehicleMovementTick() {
        boolean noPassenger = this.method_5642() == null;
        float xxa = -this.xxa();
        float zza = this.zza();
        if (!this.method_24828()) {
            xxa *= 0.2f;
            zza *= 0.2f;
        }
        if (!this.hasEnoughFuel()) {
            xxa = 0.0f;
            zza = 0.0f;
        }
        this.speed = zza != 0.0f ? (this.speed += 0.02f * zza) : (this.speed *= noPassenger ? 0.98f : 0.96f);
        if (noPassenger && this.speed < 0.1f && this.speed > -0.1f) {
            this.speed *= 0.9f;
        }
        float maxBlocksPerTick = 0.6944445f;
        this.speed = class_3532.method_15363((float)this.speed, (float)(-maxBlocksPerTick / 2.0f), (float)maxBlocksPerTick);
        this.angle = xxa != 0.0f && (this.speed > 0.05f || this.speed < -0.05f) ? (this.angle += xxa * Math.signum(this.speed) * Math.abs(this.speed)) : (this.angle *= noPassenger ? 0.95f : 0.75f);
        this.angle = class_3532.method_15363((float)this.angle, (float)-3.0f, (float)3.0f);
        this.method_36456(this.method_36454() + this.angle);
        float yRot = this.method_36454() * ((float)Math.PI / 180);
        this.method_18800(class_3532.method_15374((float)(-yRot)) * this.speed, this.method_18798().field_1351, class_3532.method_15362((float)yRot) * this.speed);
        if (zza > 0.0f) {
            this.consumeFuel();
        }
    }

    private void doEntityCollisionTick() {
        if (this.method_37908().method_8608()) {
            return;
        }
        if (this.method_18798().method_1033() <= 0.15) {
            return;
        }
        class_238 aabb = this.method_5829().method_1014(1.001);
        List entities = this.method_37908().method_8390(class_1309.class, aabb, entity -> !this.method_5685().contains(entity));
        if (entities.isEmpty()) {
            return;
        }
        double power = this.method_18798().method_1033() * 0.4;
        float damage = (float)(power * 0.5) * 100.0f;
        float yRot = this.method_36454() * ((float)Math.PI / 180);
        for (class_1309 entity2 : entities) {
            entity2.method_18799(entity2.method_18798().method_1031((double)class_3532.method_15374((float)(-yRot)) * 0.1, power, (double)class_3532.method_15362((float)yRot) * 0.1));
            entity2.method_5643(ModDamageSources.ranOver(this.method_37908(), this, (class_1297)this.method_5642()), damage);
        }
    }

    public float speed() {
        return this.speed;
    }

    public float angle() {
        return this.angle;
    }

    @Override
    @NotNull
    public String getRadioUrl() {
        return this.radioUrl;
    }

    @Override
    public void setRadioUrl(@NotNull String url) {
        this.radioUrl = url;
        for (class_1297 passenger : this.method_5685()) {
            if (!(passenger instanceof class_1657)) continue;
            class_1657 player = (class_1657)passenger;
            NetworkHandler.CHANNEL.sendToPlayer((Packet)new ClientboundPlayStationPacket(url), player);
        }
    }

    public void consumeFuel() {
        if (this.method_37908().method_8608() || this.field_6012 % 5 != 0) {
            return;
        }
        this.fluidContainer.extractFluid(this.fluidContainer.getFirstFluid().copyWithAmount(FluidConstants.fromMillibuckets((long)1L)), false);
    }

    public boolean hasEnoughFuel() {
        if (this.method_37908().method_8608()) {
            return (Long)this.field_6011.method_12789(FUEL) > 0L;
        }
        return this.fluidContainer.getFirstFluid().getFluidAmount() > 0L;
    }

    public FluidHolder fluid() {
        return FluidHolder.of((class_3611)((class_3611)class_7923.field_41173.method_10223(new class_2960((String)this.field_6011.method_12789(FUEL_TYPE)))), (long)((Long)this.field_6011.method_12789(FUEL)), null);
    }

    public class_1703 createMenu(int containerId, class_1661 inventory, class_1657 player) {
        return new RoverMenu(containerId, inventory, this);
    }

    @Override
    public int getInventorySize() {
        return 18;
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)ModItems.ROVER.get());
    }
}

