/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.items;

import dev.architectury.injectables.annotations.PlatformOnly;
import earth.terrarium.adastra.api.systems.GravityApi;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.registry.ModFluids;
import earth.terrarium.adastra.common.tags.ModFluidTags;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidItem;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedItemFluidContainer;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipGunItem
extends class_1792
implements BotariumFluidItem<WrappedItemFluidContainer> {
    public ZipGunItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 usedHand) {
        class_1799 stack = player.method_5998(usedHand);
        if (FluidUtils.hasFluid(stack) || player.method_7337()) {
            player.method_6019(usedHand);
        }
        return class_1271.method_22430((Object)stack);
    }

    public void method_7852(@NotNull class_1937 level, @NotNull class_1309 entity, @NotNull class_1799 stack, int remainingUseDuration) {
        super.method_7852(level, entity, stack, remainingUseDuration);
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        class_1799 mainHandItem = entity.method_6047();
        class_1799 offhandItem = entity.method_6079();
        long fuelUsage = 1L;
        boolean mainHandBoost = this.consumeFuel(player, mainHandItem, fuelUsage);
        boolean offHandBoost = this.consumeFuel(player, offhandItem, fuelUsage);
        if (!(mainHandBoost || offHandBoost || player.method_7337())) {
            player.method_6021();
            return;
        }
        double maxSpeed = 0.35;
        double particleSpeed = 1.5;
        double propelForce = 0.2;
        double propelYForce = 0.2;
        int particleChance = 4;
        if (GravityApi.API.getGravity((class_1297)player) <= 0.09f) {
            propelForce *= 0.1;
            propelYForce *= 0.1;
            maxSpeed *= 20.0;
            entity.field_6017 *= 0.9f;
        } else {
            propelYForce *= 0.2;
            propelYForce *= 1.0 - Math.min(1.0, entity.method_23318() / 90.0);
        }
        if (mainHandBoost && offHandBoost) {
            propelForce *= 1.4;
            propelYForce *= 1.25;
            maxSpeed *= 1.5;
            particleSpeed *= 1.5;
            entity.field_6017 *= 0.9f;
            particleChance -= 2;
        }
        class_243 lookAngle = entity.method_5720();
        if (entity.method_18798().method_1033() < maxSpeed) {
            class_243 propelRot = lookAngle.method_18805(propelForce, propelYForce, propelForce);
            entity.method_45319(propelRot);
        }
        if (level.field_9229.method_43048(particleChance) == 0) {
            level.method_8406((class_2394)class_2398.field_28013, entity.method_23317(), entity.method_23318() + 1.0, entity.method_23321(), lookAngle.field_1352 * particleSpeed + level.field_9229.method_43059() * 0.03, lookAngle.field_1351 * particleSpeed + level.field_9229.method_43059() * 0.03, lookAngle.field_1350 * particleSpeed + level.field_9229.method_43059() * 0.03);
        }
    }

    public boolean consumeFuel(class_1657 player, class_1799 stack, long amount) {
        if (!(stack.method_7909() instanceof ZipGunItem)) {
            return false;
        }
        if (player.method_7337()) {
            return true;
        }
        ItemStackHolder holder = new ItemStackHolder(stack);
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)holder);
        if (container == null) {
            return false;
        }
        FluidHolder extracted = container.extractFluid(FluidHolder.ofMillibuckets((class_3611)container.getFirstFluid().getFluid(), (long)FluidConstants.fromMillibuckets((long)amount)), false);
        stack.method_7980(holder.getStack().method_7969());
        return extracted.getFluidAmount() > 0L;
    }

    @NotNull
    public class_1839 method_7853(@NotNull class_1799 stack) {
        return class_1839.field_8949;
    }

    public int method_7881(@NotNull class_1799 stack) {
        return 72000;
    }

    public WrappedItemFluidContainer getFluidContainer(class_1799 holder) {
        return new WrappedItemFluidContainer(holder, (FluidContainer)new SimpleFluidContainer(this.getCapacity(), 1, (t, f) -> f.is(ModFluidTags.ZIP_GUN_PROPELLANTS)){});
    }

    public long getCapacity() {
        return FluidConstants.fromMillibuckets((long)3000L);
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, @NotNull class_1836 isAdvanced) {
        tooltipComponents.add(TooltipUtils.getFluidComponent(FluidUtils.getTank(stack), FluidUtils.getTankCapacity(stack), (class_3611)ModFluids.OXYGEN.get()));
        TooltipUtils.addDescriptionComponent(tooltipComponents, ConstantComponents.ZIP_GUN_INFO);
    }

    public boolean method_31567(@NotNull class_1799 stack) {
        return FluidUtils.hasFluid(stack);
    }

    public int method_31569(@NotNull class_1799 stack) {
        WrappedItemFluidContainer fluidContainer = this.getFluidContainer(stack);
        return (int)((double)fluidContainer.getFirstFluid().getFluidAmount() / (double)fluidContainer.getTankCapacity(0) * 13.0);
    }

    public int method_31571(@NotNull class_1799 stack) {
        return ClientFluidHooks.getFluidColor((FluidHolder)FluidUtils.getTank(stack));
    }

    @PlatformOnly(value={"fabric"})
    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }
}

