/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.systems;

import earth.terrarium.adastra.api.events.AdAstraEvents;
import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.tags.ModBlockTags;
import earth.terrarium.adastra.common.tags.ModFluidTags;
import earth.terrarium.adastra.common.utils.ModUtils;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2372;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3922;
import net.minecraft.class_4076;
import net.minecraft.class_5544;
import net.minecraft.class_5545;

public class EnvironmentEffects {
    public static void tickChunk(class_3218 level, class_2818 chunk) {
        class_2826[] chunkSections = chunk.method_12006();
        class_1923 chunkPos = chunk.method_12004();
        int chunkX = chunkPos.method_8326();
        int chunkZ = chunkPos.method_8328();
        for (int i = 0; i < chunkSections.length; ++i) {
            class_2826 section = chunkSections[i];
            if (!section.method_12262() && !AdAstraConfig.forcePlanetTick) continue;
            int yCord = class_4076.method_18688((int)chunk.method_31604(i));
            for (int j = 0; j < AdAstraConfig.planetRandomTickSpeed; ++j) {
                short temperature;
                class_2338 pos = level.method_8536(chunkX, yCord, chunkZ, 15);
                class_2680 state = section.method_12254(pos.method_10263() - chunkX, pos.method_10264() - yCord, pos.method_10260() - chunkZ);
                if (state.method_26215() || !AdAstraEvents.EnvironmentTickEvent.fire(level, pos, state, temperature = TemperatureApi.API.getTemperature((class_1937)level, pos))) continue;
                if (temperature > 70) {
                    EnvironmentEffects.tickHot(level, pos, state);
                    continue;
                }
                if (temperature < -20) {
                    EnvironmentEffects.tickCold(level, pos, state);
                    continue;
                }
                if (OxygenApi.API.hasOxygen((class_1937)level, pos)) continue;
                EnvironmentEffects.tickBlock(level, pos, state);
            }
        }
    }

    private static void tickBlock(class_3218 level, class_2338 pos, class_2680 state) {
        if (state.method_26164(ModBlockTags.DESTROYED_IN_SPACE) && !EnvironmentEffects.hasOxygenOnAnySide(level, pos)) {
            level.method_22352(pos, true);
        } else if (state.method_26204() instanceof class_2372 && !EnvironmentEffects.hasOxygenOnAnySide(level, pos)) {
            level.method_8501(pos, class_2246.field_10566.method_9564());
        } else if (state.method_26204() instanceof class_2344 && !EnvironmentEffects.hasOxygenOnAnySide(level, pos)) {
            level.method_8501(pos, class_2246.field_10566.method_9564());
        } else if (state.method_26204() instanceof class_3922) {
            level.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_3922.field_17564, (Comparable)((class_2350)state.method_11654((class_2769)class_3922.field_17564))));
        } else if (state.method_26204() instanceof class_5544) {
            level.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)class_5544.field_27174, (Comparable)((Integer)state.method_11654((class_2769)class_5544.field_27174)))).method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(false)));
        } else if (state.method_26204() instanceof class_5545) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_5545.field_27183, (Comparable)Boolean.valueOf(false)));
        }
    }

    private static void tickCold(class_3218 level, class_2338 pos, class_2680 state) {
        class_3610 fluidState = state.method_26227();
        if (state.method_28498((class_2769)class_2741.field_12508)) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
        } else if (fluidState.method_15771() && fluidState.method_15767(ModFluidTags.FREEZES_IN_SPACE)) {
            level.method_8501(pos, class_2246.field_10295.method_9564());
        }
    }

    private static void tickHot(class_3218 level, class_2338 pos, class_2680 state) {
        class_3610 fluidState = state.method_26227();
        if (state.method_28498((class_2769)class_2741.field_12508)) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
        } else if (fluidState.method_15771() && fluidState.method_15767(ModFluidTags.EVAPORATES_IN_SPACE)) {
            level.method_8501(pos, class_2246.field_10124.method_9564());
            level.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.8f);
            ModUtils.sendParticles(level, class_2398.field_11237, pos.method_10263(), pos.method_10264(), pos.method_10260(), 8, 0.5, 0.5, 0.5, 0.0);
        }
    }

    private static boolean hasOxygenOnAnySide(class_3218 level, class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            if (!OxygenApi.API.hasOxygen((class_1937)level, pos.method_10093(direction))) continue;
            return true;
        }
        return false;
    }
}

