/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.mixins.common;

import earth.terrarium.adastra.api.events.AdAstraEvents;
import earth.terrarium.adastra.api.systems.GravityApi;
import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.api.systems.PlanetData;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.client.utils.ClientData;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.entities.vehicles.Lander;
import earth.terrarium.adastra.common.items.armor.SpaceSuitItem;
import earth.terrarium.adastra.common.registry.ModDamageSources;
import earth.terrarium.adastra.common.tags.ModBiomeTags;
import earth.terrarium.adastra.common.tags.ModEntityTypeTags;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.class_8144;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    public LivingEntityMixin(class_1299<?> type, class_1937 level) {
        super(type, level);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void adastra$tick(CallbackInfo ci) {
        class_1657 p;
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)class_19372;
        class_1309 entity = (class_1309)this;
        if (entity instanceof class_1657 && ((p = (class_1657)entity).method_7337() || p.method_7325())) {
            return;
        }
        if (entity.field_6012 % 20 == 0) {
            if (AdAstraEvents.OxygenTickEvent.fire(level, entity)) {
                OxygenApi.API.entityTick(level, entity);
            }
            if (AdAstraEvents.TemperatureTickEvent.fire(level, entity)) {
                TemperatureApi.API.entityTick(level, entity);
            }
        }
        if (entity.field_6012 % 10 == 0 && this.method_37908().method_23753(this.method_24515()).method_40220(ModBiomeTags.HAS_ACID_RAIN) && !this.method_5864().method_20210(ModEntityTypeTags.CAN_SURVIVE_ACID_RAIN) && !this.method_5864().method_20210(ModEntityTypeTags.CAN_SURVIVE_IN_SPACE) && this.adastra$isInRain()) {
            if (this.method_5854() != null && this.method_5854().method_5864().method_20210(ModEntityTypeTags.CAN_SURVIVE_ACID_RAIN)) {
                return;
            }
            if (AdAstraEvents.AcidRainTickEvent.fire(level, entity)) {
                entity.method_5643(ModDamageSources.create(this.method_37908(), ModDamageSources.ACID_RAIN), 3.0f);
                this.method_5783(class_3417.field_14821, 0.4f, 2.0f + this.field_5974.method_43057() * 0.4f);
            }
        }
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")}, cancellable=true)
    public void adastra$travel(class_243 travelVector, CallbackInfo ci) {
        float gravity = GravityApi.API.getGravity(this);
        class_1309 entity = (class_1309)this;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_31549().field_7479) {
                return;
            }
            if (this.method_37908().method_8608()) {
                gravity = ((Float)class_8144.method_49078((Object)ClientData.getLocalData(), PlanetData::gravity, (Object)Float.valueOf(9.807f))).floatValue();
            }
        }
        class_2338 movementAffectingPos = this.method_23314();
        if (gravity <= 0.09f) {
            if (AdAstraEvents.ZeroGravityTickEvent.fire(this.method_37908(), entity, travelVector, movementAffectingPos)) {
                GravityApi.API.entityTick(this.method_37908(), entity, travelVector, movementAffectingPos);
                ci.cancel();
            }
        } else if (AdAstraEvents.GravityTickEvent.fire(this.method_37908(), entity, travelVector, movementAffectingPos)) {
            if (this.method_5799() || this.method_5771() || entity.method_6128() || entity.method_6059(class_1294.field_5906)) {
                return;
            }
            float newGravity = 0.08f * gravity;
            class_243 velocity = this.method_18798();
            this.method_18800(velocity.method_10216(), velocity.method_10214() + (double)0.08f - (double)newGravity, velocity.method_10215());
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void adastra$hurt(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 entity = (class_1309)this;
        if ((source.method_48789(class_8103.field_42246) || source.method_49708(class_8111.field_42339)) && SpaceSuitItem.hasFullNetheriteSet(entity)) {
            entity.method_20803(0);
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(method={"causeFallDamage"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    private float adastra$causeFallDamage(float multiplier) {
        return multiplier * GravityApi.API.getGravity(this);
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void adastra$causeFallDamage(float fallDistance, float multiplier, class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        if (!(fallDistance <= 3.0f / GravityApi.API.getGravity(this))) {
            return;
        }
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"stopRiding"}, at={@At(value="HEAD")}, cancellable=true)
    private void adastra$stopRiding(CallbackInfo ci) {
        Lander lander;
        class_1657 player;
        class_1297 class_12972;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (class_12972 = (player = (class_1657)livingEntityMixin).method_5854()) instanceof Lander && (lander = (Lander)class_12972).method_23318() > (double)(AdAstraConfig.atmosphereLeave - 10)) {
            ci.cancel();
        }
    }

    @Unique
    private boolean adastra$isInRain() {
        class_2338 pos = this.method_24515();
        return this.method_37908().method_8520(pos) || this.method_37908().method_8520(class_2338.method_49637((double)pos.method_10263(), (double)this.method_5829().field_1325, (double)pos.method_10260()));
    }
}

