/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.recipe;

import com.almostreliable.unified.recipe.RecipeLink;
import com.almostreliable.unified.utils.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class ClientRecipeTracker
implements class_1860<class_1263> {
    public static final class_2960 ID = Utils.getRL("client_recipe_tracker");
    public static final String RECIPES = "recipes";
    public static final String NAMESPACE = "namespace";
    public static final int UNIFIED_FLAG = 1;
    public static final int DUPLICATE_FLAG = 2;
    public static final class_1865<ClientRecipeTracker> SERIALIZER = new Serializer();
    public static final class_3956<ClientRecipeTracker> TYPE = new class_3956<ClientRecipeTracker>(){

        public String toString() {
            return ID.method_12832();
        }
    };
    private final class_2960 id;
    private final Map<class_2960, ClientRecipeLink> recipes = new HashMap<class_2960, ClientRecipeLink>();
    private final String namespace;

    protected ClientRecipeTracker(class_2960 id, String namespace) {
        this.id = id;
        this.namespace = namespace;
    }

    private static String createRaw(boolean isUnified, boolean isDuplicate, String idPath) {
        int flag = 0;
        if (isUnified) {
            flag |= 1;
        }
        if (isDuplicate) {
            flag |= 2;
        }
        return flag + "$" + idPath;
    }

    public boolean method_8115(class_1263 container, class_1937 level) {
        return false;
    }

    public class_1799 method_8116(class_1263 container, class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return TYPE;
    }

    private void add(ClientRecipeLink clientRecipeLink) {
        this.recipes.put(clientRecipeLink.id(), clientRecipeLink);
    }

    @Nullable
    public ClientRecipeLink getLink(class_2960 recipeId) {
        return this.recipes.get(recipeId);
    }

    public record ClientRecipeLink(class_2960 id, boolean isUnified, boolean isDuplicate) {
    }

    public static class Serializer
    implements class_1865<ClientRecipeTracker> {
        public ClientRecipeTracker fromJson(class_2960 recipeId, JsonObject json) {
            String namespace = json.get(ClientRecipeTracker.NAMESPACE).getAsString();
            JsonArray recipes = json.get(ClientRecipeTracker.RECIPES).getAsJsonArray();
            ClientRecipeTracker tracker = new ClientRecipeTracker(recipeId, namespace);
            for (JsonElement element : recipes) {
                ClientRecipeLink clientRecipeLink = Serializer.parseRaw(namespace, element.getAsString());
                tracker.add(clientRecipeLink);
            }
            return tracker;
        }

        public ClientRecipeTracker fromNetwork(class_2960 recipeId, class_2540 buffer) {
            int size = buffer.readInt();
            String namespace = buffer.method_19772();
            ClientRecipeTracker recipe = new ClientRecipeTracker(recipeId, namespace);
            for (int i = 0; i < size; ++i) {
                String raw = buffer.method_19772();
                ClientRecipeLink clientRecipeLink = Serializer.parseRaw(namespace, raw);
                recipe.add(clientRecipeLink);
            }
            return recipe;
        }

        public void toNetwork(class_2540 buffer, ClientRecipeTracker recipe) {
            buffer.writeInt(recipe.recipes.size());
            buffer.method_10814(recipe.namespace);
            for (ClientRecipeLink clientRecipeLink : recipe.recipes.values()) {
                String raw = ClientRecipeTracker.createRaw(clientRecipeLink.isUnified(), clientRecipeLink.isDuplicate(), clientRecipeLink.id().method_12832());
                buffer.method_10814(raw);
            }
        }

        private static ClientRecipeLink parseRaw(String namespace, String raw) {
            String[] split = raw.split("\\$", 2);
            int flag = Integer.parseInt(split[0]);
            boolean isUnified = (flag & 1) != 0;
            boolean isDuplicate = (flag & 2) != 0;
            return new ClientRecipeLink(new class_2960(namespace, split[1]), isUnified, isDuplicate);
        }
    }

    public static class RawBuilder {
        private final Map<String, JsonArray> recipesByNamespace = new HashMap<String, JsonArray>();

        public void add(RecipeLink recipe) {
            class_2960 recipeId = recipe.getId();
            JsonArray array = this.recipesByNamespace.computeIfAbsent(recipeId.method_12836(), k -> new JsonArray());
            array.add(ClientRecipeTracker.createRaw(recipe.isUnified(), recipe.hasDuplicateLink(), recipeId.method_12832()));
        }

        public Map<class_2960, JsonObject> compute() {
            HashMap<class_2960, JsonObject> result = new HashMap<class_2960, JsonObject>();
            this.recipesByNamespace.forEach((namespace, recipes) -> {
                JsonObject json = new JsonObject();
                json.addProperty("type", ID.toString());
                json.addProperty(ClientRecipeTracker.NAMESPACE, namespace);
                json.add(ClientRecipeTracker.RECIPES, (JsonElement)recipes);
                result.put(new class_2960("almostunified", namespace), json);
            });
            return result;
        }
    }
}

