/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene;

import appeng.client.guidebook.color.ColorValue;
import appeng.client.guidebook.color.SymbolicColor;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.tags.BlockTagCompiler;
import appeng.client.guidebook.compiler.tags.MdxAttrs;
import appeng.client.guidebook.document.block.LytBlockContainer;
import appeng.client.guidebook.extensions.Extension;
import appeng.client.guidebook.extensions.ExtensionCollection;
import appeng.client.guidebook.scene.CameraSettings;
import appeng.client.guidebook.scene.GuidebookScene;
import appeng.client.guidebook.scene.LytGuidebookScene;
import appeng.client.guidebook.scene.element.SceneElementTagCompiler;
import appeng.client.guidebook.scene.level.GuidebookLevel;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import appeng.libs.mdast.model.MdAstAnyContent;
import appeng.libs.mdast.model.MdAstNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SceneTagCompiler
extends BlockTagCompiler
implements Extension {
    public static final String TAG_NAME = "GameScene";
    private final Map<String, SceneElementTagCompiler> elementTagCompilers = new HashMap<String, SceneElementTagCompiler>();

    @Override
    public Set<String> getTagNames() {
        return Set.of(TAG_NAME);
    }

    @Override
    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        int padding = MdxAttrs.getInt(compiler, parent, el, "padding", 5);
        float zoom = MdxAttrs.getFloat(compiler, parent, el, "zoom", 1.0f);
        ColorValue background = MdxAttrs.getColor(compiler, parent, el, "background", SymbolicColor.SCENE_BACKGROUND);
        GuidebookLevel level = new GuidebookLevel();
        CameraSettings cameraSettings = new CameraSettings();
        cameraSettings.setZoom(zoom);
        GuidebookScene scene = new GuidebookScene(level, cameraSettings);
        for (MdAstAnyContent mdAstAnyContent : el.children()) {
            if (!(mdAstAnyContent instanceof MdxJsxElementFields)) continue;
            MdxJsxElementFields childEl = (MdxJsxElementFields)((Object)mdAstAnyContent);
            String childTagName = childEl.name();
            SceneElementTagCompiler childCompiler = this.elementTagCompilers.get(childTagName);
            if (childCompiler == null) {
                parent.appendError(compiler, "Unknown scene element", mdAstAnyContent);
                continue;
            }
            childCompiler.compile(scene, compiler, parent, childEl);
        }
        scene.getCameraSettings().setRotationCenter(scene.getWorldCenter());
        scene.centerScene();
        LytGuidebookScene lytScene = new LytGuidebookScene(compiler.getExtensions());
        lytScene.setScene(scene);
        lytScene.setBackground(background);
        lytScene.setPadding(padding);
        if (MdxAttrs.getBoolean(compiler, parent, el, "interactive", false)) {
            lytScene.setInteractive(true);
        }
        if (MdxAttrs.getBoolean(compiler, parent, el, "fullWidth", false)) {
            lytScene.setFullWidth(true);
        }
        lytScene.setSourceNode((MdAstNode)((Object)el));
        parent.append(lytScene);
    }

    @Override
    public void onExtensionsBuilt(ExtensionCollection extensions) {
        for (SceneElementTagCompiler sceneElementTag : extensions.get(SceneElementTagCompiler.EXTENSION_POINT)) {
            for (String tagName : sceneElementTag.getTagNames()) {
                this.elementTagCompilers.put(tagName, sceneElementTag);
            }
        }
    }
}

