/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.core.AELog;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.crafting.pattern.ProcessingPatternEncoding;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;

public class ProcessingPatternItem
extends EncodedPatternItem {
    public ProcessingPatternItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    @Nullable
    public AEProcessingPattern decode(class_1799 stack, class_1937 level, boolean tryRecovery) {
        return this.decode(AEItemKey.of(stack), level);
    }

    @Override
    public AEProcessingPattern decode(AEItemKey what, class_1937 level) {
        if (what == null || !what.hasTag()) {
            return null;
        }
        try {
            return new AEProcessingPattern(what);
        }
        catch (Exception e) {
            AELog.warn("Could not decode an invalid processing pattern %s: %s", what.getTag(), e);
            return null;
        }
    }

    public class_1799 encode(GenericStack[] sparseInputs, GenericStack[] sparseOutputs) {
        if (Arrays.stream(sparseInputs).noneMatch(Objects::nonNull)) {
            throw new IllegalArgumentException("At least one input must be non-null.");
        }
        Objects.requireNonNull(sparseOutputs[0], "The first (primary) output must be non-null.");
        class_1799 stack = new class_1799((class_1935)this);
        ProcessingPatternEncoding.encodeProcessingPattern(stack.method_7948(), sparseInputs, sparseOutputs);
        return stack;
    }
}

