/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.api.inventories.InternalInventory;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import java.util.ArrayDeque;
import java.util.Queue;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ItemGenBlockEntity
extends AEBaseBlockEntity
implements InternalInventoryHost {
    private static final Queue<class_1799> SHARED_POSSIBLE_ITEMS = new ArrayDeque<class_1799>();
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 16, 64);
    private class_1792 filter = class_1802.field_8162;
    private final Queue<class_1799> possibleItems = new ArrayDeque<class_1799>();

    public ItemGenBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        if (SHARED_POSSIBLE_ITEMS.isEmpty()) {
            ItemGenBlockEntity.initGlobalPossibleItems();
        }
        this.refillInv();
    }

    private static synchronized void initGlobalPossibleItems() {
        if (SHARED_POSSIBLE_ITEMS.isEmpty()) {
            for (class_1792 item : class_7923.field_41178) {
                ItemGenBlockEntity.addPossibleItem(item, SHARED_POSSIBLE_ITEMS);
            }
        }
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10582("filter", class_7923.field_41178.method_10221((Object)this.filter).toString());
    }

    @Override
    public void loadTag(class_2487 data) {
        if (data.method_10545("filter")) {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(data.method_10558("filter")));
            this.setItem(item);
        }
        super.loadTag(data);
    }

    public Storage<ItemVariant> getItemHandler() {
        return this.inv.toStorage();
    }

    public void setItem(class_1792 item) {
        this.filter = item;
        this.possibleItems.clear();
        ItemGenBlockEntity.addPossibleItem(this.filter, this.possibleItems);
        this.refillInv();
    }

    private Queue<class_1799> getPossibleItems() {
        return this.filter != class_1802.field_8162 ? this.possibleItems : SHARED_POSSIBLE_ITEMS;
    }

    private static void addPossibleItem(class_1792 item, Queue<class_1799> queue) {
        if (item == null || item == class_1802.field_8162) {
            return;
        }
        if (item.method_7846()) {
            class_1799 sampleStack = new class_1799((class_1935)item);
            int maxDamage = sampleStack.method_7936();
            for (int dmg = 0; dmg < maxDamage; ++dmg) {
                class_1799 is = sampleStack.method_7972();
                is.method_7974(dmg);
                queue.add(is);
            }
        } else {
            queue.add(item.method_7854());
        }
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv.getStackInSlot(slot).method_7960()) {
            this.refillSlot(slot);
        }
    }

    private void refillInv() {
        for (int slot = 0; slot < this.inv.size(); ++slot) {
            this.refillSlot(slot);
        }
    }

    private void refillSlot(int slot) {
        class_1799 stack = this.getPossibleItems().poll();
        if (stack != null) {
            class_1799 copy = stack.method_7972();
            copy.method_7939(stack.method_7914());
            this.inv.setItemDirect(slot, copy);
            this.getPossibleItems().add(stack);
        }
    }
}

