/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.config.CondenserOutput;
import appeng.api.features.P2PTunnelAttunementInternal;
import appeng.api.integrations.jei.IngredientConverters;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.StackWithBounds;
import appeng.client.gui.implementations.InscriberScreen;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.FacadeCreativeTab;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.core.localization.ItemModText;
import appeng.integration.abstraction.JEIFacade;
import appeng.integration.modules.jei.AttunementCategory;
import appeng.integration.modules.jei.AttunementDisplay;
import appeng.integration.modules.jei.CertusGrowthCategory;
import appeng.integration.modules.jei.ChargerCategory;
import appeng.integration.modules.jei.CondenserCategory;
import appeng.integration.modules.jei.EntropyManipulatorCategory;
import appeng.integration.modules.jei.FacadeRegistryPlugin;
import appeng.integration.modules.jei.FluidIngredientConverter;
import appeng.integration.modules.jei.GenericEntryStackHelper;
import appeng.integration.modules.jei.GhostIngredientHandler;
import appeng.integration.modules.jei.InscriberRecipeCategory;
import appeng.integration.modules.jei.ItemIngredientConverter;
import appeng.integration.modules.jei.JeiRuntimeAdapter;
import appeng.integration.modules.jei.TransformCategory;
import appeng.integration.modules.jei.transfer.EncodePatternTransferHandler;
import appeng.integration.modules.jei.transfer.UseCraftingRecipeTransfer;
import appeng.items.parts.FacadeItem;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.me.items.WirelessCraftingTermMenu;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.handlers.ChargerRecipe;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.transform.TransformRecipe;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_6862;
import net.minecraft.class_768;
import net.minecraft.class_7923;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final class_2960 TEXTURE = AppEng.makeId("textures/guis/jei.png");
    private static final class_2960 ID = new class_2960("ae2", "core");
    private IJeiRuntime jeiRuntime;

    public JEIPlugin() {
        IngredientConverters.register(new ItemIngredientConverter());
        IngredientConverters.register(new FluidIngredientConverter());
    }

    public class_2960 getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        subtypeRegistry.useNbtForSubtypes(new class_1792[]{AEItems.FACADE.method_8389()});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new TransformCategory(jeiHelpers), new CondenserCategory(jeiHelpers.getGuiHelper()), new InscriberRecipeCategory(jeiHelpers.getGuiHelper()), new ChargerCategory(jeiHelpers), new AttunementCategory(jeiHelpers), new CertusGrowthCategory(jeiHelpers), new EntropyManipulatorCategory(jeiHelpers)});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(new UseCraftingRecipeTransfer<CraftingTermMenu>(CraftingTermMenu.class, CraftingTermMenu.TYPE, registration.getTransferHelper()), RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler(new UseCraftingRecipeTransfer<WirelessCraftingTermMenu>(WirelessCraftingTermMenu.class, WirelessCraftingTermMenu.TYPE, registration.getTransferHelper()), RecipeTypes.CRAFTING);
        registration.addUniversalRecipeTransferHandler(new EncodePatternTransferHandler<PatternEncodingTermMenu>(PatternEncodingTermMenu.TYPE, PatternEncodingTermMenu.class, registration.getTransferHelper()));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        class_1863 recipeManager = class_310.method_1551().field_1687.method_8433();
        registration.addRecipes(InscriberRecipeCategory.RECIPE_TYPE, List.copyOf(recipeManager.method_17717(InscriberRecipe.TYPE).values()));
        registration.addRecipes(ChargerCategory.RECIPE_TYPE, List.copyOf(recipeManager.method_17717(ChargerRecipe.TYPE).values()));
        registration.addRecipes(CondenserCategory.RECIPE_TYPE, (List)ImmutableList.of((Object)((Object)CondenserOutput.MATTER_BALLS), (Object)((Object)CondenserOutput.SINGULARITY)));
        registration.addRecipes(EntropyManipulatorCategory.TYPE, List.copyOf(recipeManager.method_17717(EntropyRecipe.TYPE).values()));
        registration.addRecipes(TransformCategory.RECIPE_TYPE, List.copyOf(recipeManager.method_17717(TransformRecipe.TYPE).values()));
        this.registerP2PAttunement(registration);
        this.registerDescriptions(registration);
        registration.addItemStackInfo(AEBlocks.CRANK.stack(), new class_2561[]{ItemModText.CRANK_DESCRIPTION.text()});
        registration.addRecipes(CertusGrowthCategory.TYPE, List.of(CertusGrowthCategory.Page.values()));
    }

    private void registerP2PAttunement(IRecipeRegistration registration) {
        ArrayList<AttunementDisplay> attunementRecipes = new ArrayList<AttunementDisplay>();
        for (P2PTunnelAttunementInternal.Resultant resultant : P2PTunnelAttunementInternal.getApiTunnels()) {
            attunementRecipes.add(new AttunementDisplay(class_1856.method_8101((class_1799[])((class_1799[])class_7923.field_41178.method_10220().map(class_1799::new).filter(resultant.stackPredicate()).toArray(class_1799[]::new))), resultant.tunnelType(), new class_2561[]{ItemModText.P2P_API_ATTUNEMENT.text(), resultant.description()}));
        }
        for (Map.Entry entry : P2PTunnelAttunementInternal.getTagTunnels().entrySet()) {
            attunementRecipes.add(new AttunementDisplay(class_1856.method_8106((class_6862)((class_6862)entry.getKey())), (class_1792)entry.getValue(), new class_2561[]{ItemModText.P2P_TAG_ATTUNEMENT.text()}));
        }
        attunementRecipes.removeIf(a -> a.inputs().method_8103());
        registration.addRecipes(AttunementCategory.TYPE, attunementRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        class_1799 condenser = AEBlocks.CONDENSER.stack();
        registration.addRecipeCatalyst(condenser, new RecipeType[]{CondenserCategory.RECIPE_TYPE});
        class_1799 inscriber = AEBlocks.INSCRIBER.stack();
        registration.addRecipeCatalyst(inscriber, new RecipeType[]{InscriberRecipeCategory.RECIPE_TYPE});
        class_1799 craftingTerminal = AEParts.CRAFTING_TERMINAL.stack();
        registration.addRecipeCatalyst(craftingTerminal, new RecipeType[]{RecipeTypes.CRAFTING});
        class_1799 wirelessCraftingTerminal = AEItems.WIRELESS_CRAFTING_TERMINAL.stack();
        registration.addRecipeCatalyst(wirelessCraftingTerminal, new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(AEBlocks.CHARGER.stack(), new RecipeType[]{ChargerCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(AEBlocks.CRANK.stack(), new RecipeType[]{ChargerCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(AEItems.ENTROPY_MANIPULATOR.stack(), new RecipeType[]{EntropyManipulatorCategory.TYPE});
    }

    private void registerDescriptions(IRecipeRegistration registry) {
        this.addDescription(registry, AEItems.LOGIC_PROCESSOR_PRESS, new class_2561[]{GuiText.inWorldCraftingPresses.text()});
        this.addDescription(registry, AEItems.CALCULATION_PROCESSOR_PRESS, new class_2561[]{GuiText.inWorldCraftingPresses.text()});
        this.addDescription(registry, AEItems.ENGINEERING_PROCESSOR_PRESS, new class_2561[]{GuiText.inWorldCraftingPresses.text()});
        this.addDescription(registry, AEItems.SILICON_PRESS, new class_2561[]{GuiText.inWorldCraftingPresses.text()});
    }

    private void addDescription(IRecipeRegistration registry, ItemDefinition<?> itemDefinition, class_2561 ... message) {
        registry.addIngredientInfo((Object)itemDefinition.stack(), (IIngredientType)VanillaTypes.ITEM_STACK, message);
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        if (AEConfig.instance().isEnableFacadeRecipesInJEI()) {
            FacadeItem itemFacade = AEItems.FACADE.method_8389();
            class_1799 cableAnchor = AEParts.CABLE_ANCHOR.stack();
            registration.addRecipeManagerPlugin((IRecipeManagerPlugin)new FacadeRegistryPlugin(itemFacade, cableAnchor));
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AEBaseScreen.class, new IGuiContainerHandler<AEBaseScreen<?>>(){

            public List<class_768> getGuiExtraAreas(AEBaseScreen<?> screen) {
                return screen.getExclusionZones();
            }

            public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(AEBaseScreen<?> screen, double mouseX, double mouseY) {
                StackWithBounds stackWithBounds = screen.getStackUnderMouse(mouseX, mouseY);
                if (stackWithBounds != null) {
                    return JEIPlugin.this.makeClickableIngredient(stackWithBounds);
                }
                return Optional.empty();
            }

            public Collection<IGuiClickableArea> getGuiClickableAreas(AEBaseScreen<?> screen, double mouseX, double mouseY) {
                if (screen instanceof InscriberScreen) {
                    return Collections.singletonList(IGuiClickableArea.createBasic((int)82, (int)39, (int)26, (int)16, (RecipeType[])new RecipeType[]{InscriberRecipeCategory.RECIPE_TYPE}));
                }
                return Collections.emptyList();
            }
        });
        registration.addGhostIngredientHandler(AEBaseScreen.class, (IGhostIngredientHandler)new GhostIngredientHandler());
    }

    private Optional<IClickableIngredient<?>> makeClickableIngredient(StackWithBounds stackWithBounds) {
        ITypedIngredient<?> ingredient = GenericEntryStackHelper.stackToIngredient(this.jeiRuntime.getIngredientManager(), stackWithBounds.stack());
        if (ingredient == null) {
            return Optional.empty();
        }
        return Optional.of(new ClickableIngredient(ingredient, stackWithBounds.bounds()));
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        this.jeiRuntime = jeiRuntime;
        JEIFacade.setInstance(new JeiRuntimeAdapter(jeiRuntime));
        this.hideDebugTools(jeiRuntime);
        if (!AEConfig.instance().isEnableFacadesInJEI()) {
            jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, FacadeCreativeTab.getDisplayItems());
        }
    }

    private void hideDebugTools(IJeiRuntime jeiRuntime) {
        if (!AEConfig.instance().isDebugToolsEnabled()) {
            ArrayList<class_1799> toRemove = new ArrayList<class_1799>();
            toRemove.add(AEBlocks.DEBUG_CUBE_GEN.stack());
            toRemove.add(AEBlocks.DEBUG_CHUNK_LOADER.stack());
            toRemove.add(AEBlocks.DEBUG_ENERGY_GEN.stack());
            toRemove.add(AEBlocks.DEBUG_ITEM_GEN.stack());
            toRemove.add(AEBlocks.DEBUG_PHANTOM_NODE.stack());
            toRemove.add(AEItems.DEBUG_CARD.stack());
            toRemove.add(AEItems.DEBUG_ERASER.stack());
            toRemove.add(AEItems.DEBUG_METEORITE_PLACER.stack());
            toRemove.add(AEItems.DEBUG_REPLICATOR_CARD.stack());
            jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, toRemove);
        }
    }

    public static void drawHoveringText(class_332 guiGraphics, List<class_2561> textLines, int x, int y) {
        class_327 font = class_310.method_1551().field_1772;
        guiGraphics.method_51437(font, textLines, Optional.empty(), x, y);
    }

    private record ClickableIngredient<T>(ITypedIngredient<T> ingredient, class_768 area) implements IClickableIngredient<T>
    {
        public ITypedIngredient<T> getTypedIngredient() {
            return this.ingredient;
        }

        public class_768 getArea() {
            return this.area;
        }
    }
}

