/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu;

import appeng.core.AELog;
import appeng.menu.AEBaseMenu;
import appeng.menu.locator.MenuLocator;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_3917;

public final class MenuOpener {
    private static final Map<class_3917<? extends AEBaseMenu>, Opener> registry = new HashMap<class_3917<? extends AEBaseMenu>, Opener>();

    private MenuOpener() {
    }

    public static <T extends AEBaseMenu> void addOpener(class_3917<T> type, Opener opener) {
        registry.put(type, opener);
    }

    public static boolean returnTo(class_3917<?> type, class_1657 player, MenuLocator locator) {
        return MenuOpener.open(type, player, locator, true);
    }

    public static boolean open(class_3917<?> type, class_1657 player, MenuLocator locator) {
        return MenuOpener.open(type, player, locator, false);
    }

    public static boolean open(class_3917<?> type, class_1657 player, MenuLocator locator, boolean fromSubMenu) {
        Preconditions.checkArgument((!player.method_37908().method_8608() ? 1 : 0) != 0, (Object)"Menus must be opened on the server.");
        Opener opener = registry.get(type);
        if (opener == null) {
            AELog.warn("Trying to open menu for unknown menu type {}", type);
            return false;
        }
        return opener.open(player, locator, fromSubMenu);
    }

    @FunctionalInterface
    public static interface Opener {
        public boolean open(class_1657 var1, MenuLocator var2, boolean var3);
    }
}

