/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.api.config.Settings;
import appeng.api.config.ShowPatternProviders;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.IConfigurableObject;
import appeng.core.AELog;
import appeng.core.sync.packets.ClearPatternAccessTerminalPacket;
import appeng.core.sync.packets.PatternAccessTerminalPacket;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.helpers.InventoryAction;
import appeng.helpers.patternprovider.PatternContainer;
import appeng.menu.AEBaseMenu;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.parts.reporting.PatternAccessTerminalPart;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class PatternAccessTermMenu
extends AEBaseMenu {
    private final IConfigurableObject host;
    @GuiSync(value=1)
    public ShowPatternProviders showPatternProviders = ShowPatternProviders.VISIBLE;
    public static final class_3917<PatternAccessTermMenu> TYPE = MenuTypeBuilder.create(PatternAccessTermMenu::new, PatternAccessTerminalPart.class).build("patternaccessterminal");
    private static long inventorySerial = Long.MIN_VALUE;
    private final Map<PatternContainer, ContainerTracker> diList = new IdentityHashMap<PatternContainer, ContainerTracker>();
    private final Long2ObjectOpenHashMap<ContainerTracker> byId = new Long2ObjectOpenHashMap();
    private final Set<PatternContainer> pinnedHosts = Collections.newSetFromMap(new IdentityHashMap());

    public ShowPatternProviders getShownProviders() {
        return this.showPatternProviders;
    }

    public PatternAccessTermMenu(int id, class_1661 ip, PatternAccessTerminalPart anchor) {
        this(TYPE, id, ip, anchor, true);
    }

    public PatternAccessTermMenu(class_3917<?> menuType, int id, class_1661 ip, IConfigurableObject host, boolean bindInventory) {
        super(menuType, id, ip, host);
        this.host = host;
        if (bindInventory) {
            this.createPlayerInventorySlots(ip);
        }
    }

    @Override
    public void method_7623() {
        if (this.isClientSide()) {
            return;
        }
        this.showPatternProviders = this.host.getConfigManager().getSetting(Settings.TERMINAL_SHOW_PATTERN_PROVIDERS);
        super.method_7623();
        if (this.showPatternProviders != ShowPatternProviders.NOT_FULL) {
            this.pinnedHosts.clear();
        }
        IGrid grid = this.getGrid();
        VisitorState state = new VisitorState();
        if (grid != null) {
            for (Class<?> machineClass : grid.getMachineClasses()) {
                if (!PatternContainer.class.isAssignableFrom(machineClass)) continue;
                this.visitPatternProviderHosts(grid, machineClass, state);
            }
            this.pinnedHosts.removeIf(host -> host.getGrid() != grid);
        } else {
            this.pinnedHosts.clear();
        }
        if (state.total != this.diList.size() || state.forceFullUpdate) {
            this.sendFullUpdate(grid);
        } else {
            this.sendIncrementalUpdate();
        }
    }

    @Nullable
    private IGrid getGrid() {
        IGridNode agn;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            return agn.getGrid();
        }
        return null;
    }

    private boolean isFull(PatternContainer logic) {
        for (int i = 0; i < logic.getTerminalPatternInventory().size(); ++i) {
            if (!logic.getTerminalPatternInventory().getStackInSlot(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    private boolean isVisible(PatternContainer container) {
        boolean isVisible = container.isVisibleInTerminal();
        return switch (this.getShownProviders()) {
            default -> throw new IncompatibleClassChangeError();
            case ShowPatternProviders.VISIBLE -> isVisible;
            case ShowPatternProviders.NOT_FULL -> {
                if (isVisible && (this.pinnedHosts.contains(container) || !this.isFull(container))) {
                    yield true;
                }
                yield false;
            }
            case ShowPatternProviders.ALL -> true;
        };
    }

    private <T extends PatternContainer> void visitPatternProviderHosts(IGrid grid, Class<T> machineClass, VisitorState state) {
        for (PatternContainer container : grid.getActiveMachines(machineClass)) {
            ContainerTracker t;
            if (!this.isVisible(container)) continue;
            if (this.getShownProviders() == ShowPatternProviders.NOT_FULL) {
                this.pinnedHosts.add(container);
            }
            if ((t = this.diList.get(container)) == null || !t.group.equals(container.getTerminalGroup())) {
                state.forceFullUpdate = true;
            }
            ++state.total;
        }
    }

    @Override
    public void doAction(class_3222 player, InventoryAction action, int slot, long id) {
        ContainerTracker inv = (ContainerTracker)this.byId.get(id);
        if (inv == null) {
            return;
        }
        if (slot < 0 || slot >= inv.server.size()) {
            AELog.warn("Client refers to invalid slot %d of inventory %s", slot, inv.container);
            return;
        }
        class_1799 is = inv.server.getStackInSlot(slot);
        FilteredInternalInventory patternSlot = new FilteredInternalInventory(inv.server.getSlotInv(slot), new PatternSlotFilter());
        class_1799 carried = this.method_34255();
        switch (action) {
            case PICKUP_OR_SET_DOWN: {
                if (!carried.method_7960()) {
                    class_1799 inSlot = patternSlot.getStackInSlot(0);
                    if (inSlot.method_7960()) {
                        this.method_34254(patternSlot.addItems(carried));
                        break;
                    }
                    inSlot = inSlot.method_7972();
                    class_1799 inHand = carried.method_7972();
                    patternSlot.setItemDirect(0, class_1799.field_8037);
                    this.method_34254(class_1799.field_8037);
                    this.method_34254(patternSlot.addItems(inHand.method_7972()));
                    if (this.method_34255().method_7960()) {
                        this.method_34254(inSlot);
                        break;
                    }
                    this.method_34254(inHand);
                    patternSlot.setItemDirect(0, inSlot);
                    break;
                }
                this.method_34254(patternSlot.getStackInSlot(0));
                patternSlot.setItemDirect(0, class_1799.field_8037);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (!carried.method_7960()) {
                    class_1799 extra = carried.method_7971(1);
                    if (!extra.method_7960()) {
                        extra = patternSlot.addItems(extra);
                    }
                    if (extra.method_7960()) break;
                    carried.method_7933(extra.method_7947());
                    break;
                }
                if (is.method_7960()) break;
                this.method_34254(patternSlot.extractItem(0, (is.method_7947() + 1) / 2, false));
                break;
            }
            case SHIFT_CLICK: {
                class_1799 stack = patternSlot.getStackInSlot(0).method_7972();
                if (!player.method_31548().method_7394(stack)) {
                    patternSlot.setItemDirect(0, stack);
                    break;
                }
                patternSlot.setItemDirect(0, class_1799.field_8037);
                break;
            }
            case MOVE_REGION: {
                for (int x = 0; x < inv.server.size(); ++x) {
                    class_1799 stack = inv.server.getStackInSlot(x);
                    if (!player.method_31548().method_7394(stack)) {
                        patternSlot.setItemDirect(0, stack);
                        continue;
                    }
                    patternSlot.setItemDirect(0, class_1799.field_8037);
                }
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.method_31549().field_7477 || !carried.method_7960()) break;
                this.method_34254(is.method_7960() ? class_1799.field_8037 : is.method_7972());
            }
        }
    }

    private void sendFullUpdate(@Nullable IGrid grid) {
        this.byId.clear();
        this.diList.clear();
        this.sendPacketToClient(new ClearPatternAccessTerminalPacket());
        if (grid == null) {
            return;
        }
        for (Class<?> machineClass : grid.getMachineClasses()) {
            Class<? extends PatternContainer> containerClass = PatternAccessTermMenu.tryCastMachineToContainer(machineClass);
            if (containerClass == null) continue;
            for (PatternContainer patternContainer : grid.getActiveMachines(containerClass)) {
                if (!this.isVisible(patternContainer)) continue;
                this.diList.put(patternContainer, new ContainerTracker(patternContainer, patternContainer.getTerminalPatternInventory(), patternContainer.getTerminalGroup()));
            }
        }
        for (ContainerTracker inv : this.diList.values()) {
            this.byId.put(inv.serverId, (Object)inv);
            this.sendPacketToClient(inv.createFullPacket());
        }
    }

    private void sendIncrementalUpdate() {
        for (ContainerTracker inv : this.diList.values()) {
            PatternAccessTerminalPacket packet = inv.createUpdatePacket();
            if (packet == null) continue;
            this.sendPacketToClient(packet);
        }
    }

    private static Class<? extends PatternContainer> tryCastMachineToContainer(Class<?> machineClass) {
        if (PatternContainer.class.isAssignableFrom(machineClass)) {
            return machineClass.asSubclass(PatternContainer.class);
        }
        return null;
    }

    private static class VisitorState {
        int total;
        boolean forceFullUpdate;

        private VisitorState() {
        }
    }

    private static class ContainerTracker {
        private final PatternContainer container;
        private final long sortBy;
        private final long serverId = inventorySerial++;
        private final PatternContainerGroup group;
        private final InternalInventory client;
        private final InternalInventory server;

        public ContainerTracker(PatternContainer container, InternalInventory patterns, PatternContainerGroup group) {
            this.container = container;
            this.server = patterns;
            this.client = new AppEngInternalInventory(this.server.size());
            this.group = group;
            this.sortBy = container.getTerminalSortOrder();
        }

        public PatternAccessTerminalPacket createFullPacket() {
            Int2ObjectArrayMap slots = new Int2ObjectArrayMap(this.server.size());
            for (int i = 0; i < this.server.size(); ++i) {
                class_1799 stack = this.server.getStackInSlot(i);
                if (stack.method_7960()) continue;
                slots.put(i, (Object)stack);
            }
            return PatternAccessTerminalPacket.fullUpdate(this.serverId, this.server.size(), this.sortBy, this.group, (Int2ObjectMap<class_1799>)slots);
        }

        @Nullable
        public PatternAccessTerminalPacket createUpdatePacket() {
            IntList changedSlots = this.detectChangedSlots();
            if (changedSlots == null) {
                return null;
            }
            Int2ObjectArrayMap slots = new Int2ObjectArrayMap(changedSlots.size());
            for (int i = 0; i < changedSlots.size(); ++i) {
                int slot;
                class_1799 stack = this.server.getStackInSlot(slot = changedSlots.getInt(i));
                this.client.setItemDirect(slot, stack.method_7960() ? class_1799.field_8037 : stack.method_7972());
                slots.put(slot, (Object)stack);
            }
            return PatternAccessTerminalPacket.incrementalUpdate(this.serverId, (Int2ObjectMap<class_1799>)slots);
        }

        @Nullable
        private IntList detectChangedSlots() {
            IntArrayList changedSlots = null;
            for (int x = 0; x < this.server.size(); ++x) {
                if (!ContainerTracker.isDifferent(this.server.getStackInSlot(x), this.client.getStackInSlot(x))) continue;
                if (changedSlots == null) {
                    changedSlots = new IntArrayList();
                }
                changedSlots.add(x);
            }
            return changedSlots;
        }

        private static boolean isDifferent(class_1799 a, class_1799 b) {
            if (a.method_7960() && b.method_7960()) {
                return false;
            }
            if (a.method_7960() || b.method_7960()) {
                return true;
            }
            return !class_1799.method_7973((class_1799)a, (class_1799)b);
        }
    }

    private static class PatternSlotFilter
    implements IAEItemFilter {
        private PatternSlotFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            return !stack.method_7960() && stack.method_7909() instanceof EncodedPatternItem;
        }
    }
}

