/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.parts.IMonitorPart;
import appeng.api.networking.GridFlags;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.parts.AEBasePart;
import appeng.parts.reporting.ReportingModelData;
import appeng.util.InteractionUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3532;

public abstract class AbstractReportingPart
extends AEBasePart
implements IMonitorPart {
    private byte spin = 0;
    private int opacity = -1;

    protected AbstractReportingPart(IPartItem<?> partItem, boolean requireChannel) {
        super(partItem);
        if (requireChannel) {
            this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL);
            this.getMainNode().setIdlePowerUsage(0.5);
        } else {
            this.getMainNode().setIdlePowerUsage(0.0625);
        }
    }

    @Override
    public final void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
    }

    @Override
    public void onNeighborChanged(class_1922 level, class_2338 pos, class_2338 neighbor) {
        if (pos.method_10093(this.getSide()).equals((Object)neighbor)) {
            this.opacity = -1;
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.spin = data.method_10571("spin");
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10567("spin", this.getSpin());
    }

    @Override
    public void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeByte((int)this.getSpin());
    }

    @Override
    public boolean readFromStream(class_2540 data) {
        boolean changed = super.readFromStream(data);
        byte oldSpin = this.spin;
        this.spin = data.readByte();
        return changed || oldSpin != this.spin;
    }

    @Override
    public final int getLightLevel() {
        return this.blockLight(this.isPowered() ? (this.isLightSource() ? 15 : 9) : 0);
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (InteractionUtil.canWrenchRotate(player.method_31548().method_7391())) {
            if (!this.isClientSide()) {
                this.spin = (byte)((this.spin + 1) % 4);
                this.getHost().markForUpdate();
                this.getHost().markForSave();
            }
            return true;
        }
        return super.onPartActivate(player, hand, pos);
    }

    @Override
    public final void onPlacement(class_1657 player) {
        super.onPlacement(player);
        byte rotation = (byte)(class_3532.method_15357((double)((double)(player.method_36454() * 4.0f / 360.0f) + 2.5)) & 3);
        if (this.getSide() == class_2350.field_11036 || this.getSide() == class_2350.field_11033) {
            this.spin = rotation;
        }
    }

    private int blockLight(int emit) {
        if (this.opacity == -1) {
            class_2586 te = this.getHost().getBlockEntity();
            class_1937 level = te.method_10997();
            class_2338 pos = te.method_11016().method_10093(this.getSide());
            this.opacity = level.method_8320(pos).method_26193((class_1922)level, pos);
        }
        return Math.max(0, emit - this.opacity);
    }

    protected IPartModel selectModel(IPartModel offModels, IPartModel onModels, IPartModel hasChannelModels) {
        if (this.isActive()) {
            return hasChannelModels;
        }
        if (this.isPowered()) {
            return onModels;
        }
        return offModels;
    }

    @Override
    public Object getRenderAttachmentData() {
        return new ReportingModelData(this.getSpin());
    }

    public final byte getSpin() {
        return this.spin;
    }

    public abstract boolean isLightSource();
}

