/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.pathing.ChannelMode;
import appeng.api.orientation.BlockOrientation;
import appeng.api.parts.PartHelper;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.StorageCell;
import appeng.api.util.AEColor;
import appeng.blockentity.crafting.MolecularAssemblerBlockEntity;
import appeng.blockentity.misc.InterfaceBlockEntity;
import appeng.blockentity.storage.ChestBlockEntity;
import appeng.blockentity.storage.DriveBlockEntity;
import appeng.blockentity.storage.SkyStoneTankBlockEntity;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.items.storage.CreativeCellItem;
import appeng.items.tools.powered.MatterCannonItem;
import appeng.me.cells.BasicCellInventory;
import appeng.me.helpers.BaseActionSource;
import appeng.me.service.PathingService;
import appeng.menu.AutoCraftingMenu;
import appeng.parts.automation.ImportBusPart;
import appeng.parts.crafting.PatternProviderPart;
import appeng.server.testplots.AnnihilationPlaneTests;
import appeng.server.testplots.AutoCraftingTestPlots;
import appeng.server.testplots.GuidebookPlot;
import appeng.server.testplots.InscriberTestPlots;
import appeng.server.testplots.ItemP2PTestPlots;
import appeng.server.testplots.MemoryCardTestPlots;
import appeng.server.testplots.P2PTestPlots;
import appeng.server.testplots.PatternProviderLockModePlots;
import appeng.server.testplots.QnbTestPlots;
import appeng.server.testplots.SpatialTestPlots;
import appeng.server.testplots.SubnetPlots;
import appeng.server.testplots.TestPlot;
import appeng.server.testplots.TestPlotCollection;
import appeng.server.testplots.TestPlotGenerator;
import appeng.server.testworld.DriveBuilder;
import appeng.server.testworld.Plot;
import appeng.server.testworld.PlotBuilder;
import appeng.server.testworld.PlotTestHelper;
import appeng.server.testworld.TestCraftingJob;
import appeng.util.ConfigInventory;
import appeng.util.CraftingRecipeUtil;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class TestPlots {
    private static final List<Class<?>> PLOT_CLASSES = new ArrayList();
    @Nullable
    private static Map<class_2960, Consumer<PlotBuilder>> plots;

    private TestPlots() {
    }

    private static synchronized Map<class_2960, Consumer<PlotBuilder>> getPlots() {
        if (plots == null) {
            plots = TestPlots.scanForPlots();
        }
        return plots;
    }

    private static Map<class_2960, Consumer<PlotBuilder>> scanForPlots() {
        HashMap<class_2960, Consumer<PlotBuilder>> plots = new HashMap<class_2960, Consumer<PlotBuilder>>();
        try {
            for (Class<?> clazz : PLOT_CLASSES) {
                AELog.info("Scanning %s for plots", clazz);
                for (Method method : clazz.getMethods()) {
                    TestPlot annotation = method.getAnnotation(TestPlot.class);
                    TestPlotGenerator generatorAnnotation = method.getAnnotation(TestPlotGenerator.class);
                    if (annotation == null && generatorAnnotation == null) continue;
                    if (annotation != null && generatorAnnotation != null) {
                        throw new IllegalStateException("Cannot annotate method " + method + " with both @TestPlot and @TestPlotGenerator");
                    }
                    if (!Modifier.isPublic(method.getModifiers())) {
                        throw new IllegalStateException("Method " + method + " must be public");
                    }
                    if (!Modifier.isStatic(method.getModifiers())) {
                        throw new IllegalStateException("Method " + method + " must be static");
                    }
                    if (!Void.TYPE.equals(method.getReturnType())) {
                        throw new IllegalStateException("Method " + method + " must return void");
                    }
                    if (annotation != null) {
                        if (!Arrays.asList(method.getParameterTypes()).equals(List.of(PlotBuilder.class))) {
                            throw new IllegalStateException("Method " + method + " must take a single PlotBuilder argument");
                        }
                        class_2960 id = AppEng.makeId(annotation.value());
                        plots.put(id, builder -> {
                            try {
                                method.invoke(null, builder);
                            }
                            catch (InvocationTargetException e) {
                                throw new RuntimeException("Failed building " + id, e.getCause());
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException("Failed to access " + method, e);
                            }
                        });
                        continue;
                    }
                    if (generatorAnnotation == null) continue;
                    if (!Arrays.asList(method.getParameterTypes()).equals(List.of(TestPlotCollection.class))) {
                        throw new IllegalStateException("Method " + method + " must take a single TestPlotCollection argument");
                    }
                    TestPlotCollection tpc = new TestPlotCollection(plots);
                    try {
                        method.invoke(null, tpc);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException("Failed building " + method, e.getCause());
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Failed to access " + method, e);
                    }
                }
            }
        }
        catch (Exception e) {
            AELog.warn("Failed to scan for plots: %s", e);
        }
        return plots;
    }

    public static synchronized void addPlotClass(Class<?> clazz) {
        PLOT_CLASSES.add(clazz);
        plots = null;
    }

    public static List<class_2960> getPlotIds() {
        ArrayList<class_2960> list = new ArrayList<class_2960>(TestPlots.getPlots().keySet());
        list.sort(Comparator.comparing(class_2960::toString));
        return list;
    }

    public static List<Plot> createPlots() {
        ArrayList<Plot> plots = new ArrayList<Plot>();
        for (Map.Entry<class_2960, Consumer<PlotBuilder>> entry : TestPlots.getPlots().entrySet()) {
            Plot plot = new Plot(entry.getKey());
            entry.getValue().accept(plot);
            plots.add(plot);
        }
        return plots;
    }

    @Nullable
    public static Plot getById(class_2960 name) {
        Consumer<PlotBuilder> factory = TestPlots.getPlots().get(name);
        if (factory == null) {
            return null;
        }
        Plot plot = new Plot(name);
        factory.accept(plot);
        return plot;
    }

    @TestPlot(value="all_terminals")
    public static void allTerminals(PlotBuilder plot) {
        class_1799 enchantedPickaxe = new class_1799((class_1935)class_1802.field_8377);
        enchantedPickaxe.method_7978(class_1893.field_9130, 3);
        AEItemKey enchantedPickaxeKey = AEItemKey.of(enchantedPickaxe);
        plot.creativeEnergyCell("0 -1 0");
        plot.cable("[-1,0] [0,8] 0", AEParts.COVERED_DENSE_CABLE);
        plot.part("0 [0,8] 0", class_2350.field_11039, AEParts.CABLE_ANCHOR);
        plot.block("[-1,0] 5 0", AEBlocks.CONTROLLER);
        plot.storageDrive(new class_2338(0, 5, 1));
        plot.afterGridInitAt("0 5 1", (grid, gridNode) -> {
            MEStorage storage = grid.getStorageService().getInventory();
            BaseActionSource src = new BaseActionSource();
            storage.insert(AEItemKey.of((class_1935)class_1802.field_8377), 10L, Actionable.MODULATE, src);
            storage.insert(enchantedPickaxeKey, 1234L, Actionable.MODULATE, src);
            storage.insert(AEItemKey.of((class_1935)class_1802.field_8820), Integer.MAX_VALUE, Actionable.MODULATE, src);
        });
        int y = 0;
        for (AEColor color : TestPlots.getColorsTransparentFirst()) {
            PlotBuilder line = y >= 9 ? plot.transform(bb -> new class_3341(-1 - bb.method_35418(), bb.method_35416(), bb.method_35417(), -1 - bb.method_35415(), bb.method_35419(), bb.method_35420())).offset(0, y - 9, 0) : plot.offset(0, y, 0);
            ++y;
            line.cable("[1,9] 0 0", AEParts.GLASS_CABLE, color);
            if (color == AEColor.TRANSPARENT) {
                line.part("[1,9] 0 0", class_2350.field_11036, AEParts.CABLE_ANCHOR);
            }
            line.part("1 0 0", class_2350.field_11043, AEParts.TERMINAL);
            line.part("2 0 0", class_2350.field_11043, AEParts.CRAFTING_TERMINAL);
            line.part("3 0 0", class_2350.field_11043, AEParts.PATTERN_ENCODING_TERMINAL);
            line.part("4 0 0", class_2350.field_11043, AEParts.PATTERN_ACCESS_TERMINAL);
            line.part("5 0 0", class_2350.field_11043, AEParts.STORAGE_MONITOR, monitor -> {
                monitor.setConfiguredItem(enchantedPickaxeKey);
                monitor.setLocked(true);
            });
            line.part("6 0 0", class_2350.field_11043, AEParts.CONVERSION_MONITOR, monitor -> {
                monitor.setConfiguredItem(AEItemKey.of((class_1935)class_1802.field_8820));
                monitor.setLocked(true);
            });
            line.part("7 0 0", class_2350.field_11043, AEParts.MONITOR);
            line.part("8 0 0", class_2350.field_11043, AEParts.SEMI_DARK_MONITOR);
            line.part("9 0 0", class_2350.field_11043, AEParts.DARK_MONITOR);
        }
    }

    public static ArrayList<AEColor> getColorsTransparentFirst() {
        ArrayList<AEColor> colors = new ArrayList<AEColor>();
        Collections.addAll(colors, AEColor.values());
        colors.remove((Object)AEColor.TRANSPARENT);
        colors.add(0, AEColor.TRANSPARENT);
        return colors;
    }

    @TestPlot(value="item_chest")
    public static void itemChest(PlotBuilder plot) {
        plot.blockEntity("0 0 0", AEBlocks.CHEST, chest -> {
            class_1792 item;
            class_1799 cellItem = AEItems.ITEM_CELL_1K.stack();
            StorageCell cellInv = StorageCells.getCellInventory(cellItem, null);
            class_5819 r = class_5819.method_43047();
            for (int i = 0; i < 100 && cellInv.insert(AEItemKey.of((class_1935)(item = class_7923.field_41178.method_10240(r).map(class_6880::comp_349).get())), 64L, Actionable.MODULATE, new BaseActionSource()) != 0L; ++i) {
            }
            chest.setCell(cellItem);
        });
        plot.creativeEnergyCell("0 -1 0");
    }

    @TestPlot(value="fluid_chest")
    public static void fluidChest(PlotBuilder plot) {
        plot.blockEntity("0 0 0", AEBlocks.CHEST, chest -> {
            class_3611 fluid;
            class_1799 cellItem = AEItems.FLUID_CELL_1K.stack();
            StorageCell cellInv = StorageCells.getCellInventory(cellItem, null);
            class_5819 r = class_5819.method_43047();
            for (int i = 0; i < 100 && ((fluid = class_7923.field_41173.method_10240(r).map(class_6880::comp_349).get()).method_15780(class_3612.field_15906) || !fluid.method_15793(fluid.method_15785()) || cellInv.insert(AEFluidKey.of(fluid), 5184000L, Actionable.MODULATE, new BaseActionSource()) != 0L); ++i) {
            }
            chest.setCell(cellItem);
        });
        plot.creativeEnergyCell("0 -1 0");
    }

    @TestPlot(value="import_exportbus")
    public static void importExportBus(PlotBuilder plot) {
        plot.chest("1 0 1", new class_1799((class_1935)class_1802.field_8820, 16), new class_1799((class_1935)class_1802.field_8634, 6));
        plot.block("1 1 1", class_2246.field_10312);
        plot.creativeEnergyCell("3 -1 1");
        plot.cable("3 0 1").part(class_2350.field_11043, AEParts.TERMINAL);
        plot.cable("2 0 1").part(class_2350.field_11039, AEParts.IMPORT_BUS);
        plot.cable("2 1 1").part(class_2350.field_11039, AEParts.EXPORT_BUS, bus -> bus.getConfig().setStack(0, new GenericStack(AEItemKey.of((class_1935)class_1802.field_8634), 1L)));
        plot.blockEntity("3 -1 0", AEBlocks.DRIVE, drive -> drive.getInternalInventory().addItems(AEItems.ITEM_CELL_64K.stack()));
    }

    @TestPlot(value="inscriber")
    public static void inscriber(PlotBuilder plot) {
        TestPlots.processorInscriber(plot.offset(0, 1, 2), AEItems.LOGIC_PROCESSOR_PRESS, (class_1935)class_1802.field_8695);
        TestPlots.processorInscriber(plot.offset(5, 1, 2), AEItems.ENGINEERING_PROCESSOR_PRESS, (class_1935)class_1802.field_8477);
        TestPlots.processorInscriber(plot.offset(10, 1, 2), AEItems.CALCULATION_PROCESSOR_PRESS, AEItems.CERTUS_QUARTZ_CRYSTAL);
    }

    public static void processorInscriber(PlotBuilder plot, class_1935 processorPress, class_1935 processorMaterial) {
        plot.filledHopper("-1 3 0", class_2350.field_11033, processorMaterial);
        plot.creativeEnergyCell("-1 2 1");
        plot.blockEntity("-1 2 0", AEBlocks.INSCRIBER, inscriber -> {
            inscriber.getInternalInventory().setItemDirect(0, new class_1799(processorPress));
            BlockOrientation.NORTH_WEST.setOn((class_2586)inscriber);
        });
        plot.filledHopper("1 3 0", class_2350.field_11033, AEItems.SILICON);
        plot.creativeEnergyCell("1 2 1");
        plot.blockEntity("1 2 0", AEBlocks.INSCRIBER, inscriber -> {
            inscriber.getInternalInventory().setItemDirect(0, AEItems.SILICON_PRESS.stack());
            BlockOrientation.NORTH_WEST.setOn((class_2586)inscriber);
        });
        plot.hopper("1 1 0", class_2350.field_11039, new class_1799[0]);
        plot.hopper("-1 1 0", class_2350.field_11034, new class_1799[0]);
        plot.filledHopper("0 2 0", class_2350.field_11033, (class_1935)class_1802.field_8725);
        plot.creativeEnergyCell("0 1 1");
        plot.blockEntity("0 1 0", AEBlocks.INSCRIBER, BlockOrientation.NORTH_WEST::setOn);
        plot.hopper("0 0 0", class_2350.field_11033, new class_1799[0]);
    }

    @TestPlot(value="import_and_export_in_one_tick")
    public static void importAndExportInOneTick(PlotBuilder plot) {
        plot.creativeEnergyCell("-1 0 0");
        plot.chest("0 0 1", new class_1799[0]);
        plot.cable("0 0 0").part(class_2350.field_11035, AEParts.EXPORT_BUS, exportBus -> {
            exportBus.getUpgrades().addItems(AEItems.CRAFTING_CARD.stack());
            exportBus.getConfig().addFilter((class_1935)class_1802.field_8118);
        });
        plot.cable("0 1 0");
        plot.cable("0 1 -1").craftingEmitter(class_2350.field_11033, (class_1935)class_1802.field_8118);
        plot.cable("0 0 -1").part(class_2350.field_11043, AEParts.IMPORT_BUS, part -> {
            part.getUpgrades().addItems(AEItems.REDSTONE_CARD.stack());
            part.getConfigManager().putSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.HIGH_SIGNAL);
        });
        plot.block("1 0 0", AEBlocks.CRAFTING_STORAGE_1K);
        plot.chest("0 0 -2", new class_1799((class_1935)class_1802.field_8118, 1));
        plot.test(helper -> helper.method_36018(() -> {
            helper.method_35983(new class_2338(0, 0, 1), class_1802.field_8118);
            helper.method_36047(new class_2338(0, 0, -2));
        }));
    }

    @TestPlot(value="export_from_storagebus")
    public static void exportFromStorageBus(PlotBuilder plot) {
        plot.creativeEnergyCell("1 0 0");
        plot.cable("0 0 0").part(class_2350.field_11035, AEParts.EXPORT_BUS, part -> part.getConfig().addFilter((class_1935)class_1802.field_8118)).part(class_2350.field_11043, AEParts.STORAGE_BUS);
        plot.chest("0 0 1", new class_1799[0]);
        plot.chest("0 0 -1", new class_1799((class_1935)class_1802.field_8118));
        plot.test(helper -> helper.method_36018(() -> {
            helper.method_35983(new class_2338(0, 0, 1), class_1802.field_8118);
            helper.method_36047(new class_2338(0, 0, -1));
        }));
    }

    @TestPlot(value="import_into_storagebus")
    public static void importIntoStorageBus(PlotBuilder plot) {
        plot.creativeEnergyCell("1 0 0");
        plot.cable("0 0 0").part(class_2350.field_11043, AEParts.IMPORT_BUS).part(class_2350.field_11035, AEParts.STORAGE_BUS);
        plot.chest("0 0 1", new class_1799[0]);
        plot.chest("0 0 -1", new class_1799((class_1935)class_1802.field_8118));
        plot.test(helper -> {
            helper.method_36018(() -> {
                helper.method_35983(new class_2338(0, 0, 1), class_1802.field_8118);
                helper.method_36047(new class_2338(0, 0, -1));
            });
            helper.method_36041().method_36076(10).method_36075();
        });
    }

    @TestPlot(value="import_on_pulse")
    public static void importOnPulse(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        class_2338 inputPos = origin.method_10072();
        plot.creativeEnergyCell(origin.method_10067().method_10067());
        plot.storageDrive(origin.method_10067());
        plot.cable(origin).part(class_2350.field_11035, AEParts.IMPORT_BUS, bus -> {
            bus.getUpgrades().addItems(AEItems.REDSTONE_CARD.stack());
            bus.getConfigManager().putSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.SIGNAL_PULSE);
        }).part(class_2350.field_11043, AEParts.TERMINAL);
        plot.chest(inputPos, new class_1799((class_1935)class_1802.field_8118));
        plot.block(origin.method_10078(), class_2246.field_10340);
        class_2338 leverPos = plot.leverOn(origin.method_10078(), class_2350.field_11043);
        plot.test(helper -> {
            class_2595 inputChest = (class_2595)helper.method_36014(inputPos);
            IGrid grid = helper.getGrid(origin);
            Runnable assertNothingMoved = () -> helper.method_35983(inputPos, class_1802.field_8118);
            Runnable assertMoved = () -> {
                helper.method_36047(inputPos);
                helper.assertContains(grid, class_1802.field_8118);
            };
            Runnable reset = () -> {
                inputChest.method_5448();
                helper.clearStorage(grid);
                inputChest.method_5447(0, new class_1799((class_1935)class_1802.field_8118));
            };
            Runnable toggleSignal = () -> helper.method_36039(leverPos);
            helper.method_36041().method_36077(1, assertNothingMoved).method_36085(toggleSignal).method_36085(assertNothingMoved).method_36077(1, assertMoved).method_36085(reset).method_36085(toggleSignal).method_36084(30, assertNothingMoved).method_36075();
        });
    }

    @TestPlot(value="import_on_pulse_transactioncrash")
    public static void importOnPulseTransactionCrash(PlotBuilder plot) {
        plot.creativeEnergyCell("1 0 0");
        plot.chest("0 0 -1", new class_1799((class_1935)class_1802.field_8118));
        plot.chest("0 0 1", new class_1799[0]);
        plot.block("0 1 0", class_2246.field_10002);
        plot.cable("-1 0 0");
        plot.cable("-1 0 -1").part(class_2350.field_11034, AEParts.STORAGE_BUS, storageBus -> storageBus.getConfigManager().putSetting(Settings.ACCESS, AccessRestriction.READ));
        plot.cable("0 0 0").part(class_2350.field_11035, AEParts.STORAGE_BUS);
        plot.test(helper -> helper.method_36041().method_36077(1, () -> {
            class_2338 pos = helper.method_36052(class_2338.field_10980);
            ImportBusPart importBus = (ImportBusPart)PartHelper.setPart(helper.method_35943(), pos, class_2350.field_11043, null, AEParts.IMPORT_BUS.method_8389());
            importBus.getUpgrades().addItems(AEItems.REDSTONE_CARD.stack());
            importBus.getConfigManager().putSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.SIGNAL_PULSE);
        }).method_36084(100, () -> helper.method_36047(new class_2338(0, 0, 1))).method_36075()).setupTicks(20).maxTicks(150);
    }

    @TestPlot(value="mattercannon_range")
    public static void matterCannonRange(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        plot.fencedEntity(origin.method_10069(0, 0, 5), class_1299.field_6085, entity -> entity.method_5803(true));
        plot.creativeEnergyCell(origin.method_10074());
        plot.blockEntity(origin, AEBlocks.CHEST, chest -> chest.setCell(TestPlots.createMatterCannon(class_1802.field_8675)));
        plot.block("-2 [0,1] 5", class_2246.field_10340);
        plot.block("2 [0,1] 5", class_2246.field_10340);
        plot.creativeEnergyCell(origin.method_10067().method_10074());
        plot.block(origin.method_10067(), AEBlocks.CHARGER);
        TestPlots.matterCannonDispenser(plot.offset(-2, 1, 1), AEItems.COLORED_LUMEN_PAINT_BALL.item(AEColor.PURPLE));
        TestPlots.matterCannonDispenser(plot.offset(0, 1, 1), class_1802.field_8675);
        TestPlots.matterCannonDispenser(plot.offset(2, 1, 1), new class_1792[0]);
    }

    private static void matterCannonDispenser(PlotBuilder plot, class_1792 ... ammos) {
        plot.blockState(class_2338.field_10980, (class_2680)class_2246.field_10200.method_9564().method_11657((class_2769)class_2315.field_10918, (Comparable)class_2350.field_11035));
        plot.customizeBlockEntity(class_2338.field_10980, class_2591.field_11887, dispenser -> dispenser.method_11075(TestPlots.createMatterCannon(ammos)));
        plot.buttonOn(class_2338.field_10980, class_2350.field_11043);
    }

    private static class_1799 createMatterCannon(class_1792 ... ammo) {
        class_1799 cannon = AEItems.MATTER_CANNON.stack();
        ((MatterCannonItem)cannon.method_7909()).injectAEPower(cannon, Double.MAX_VALUE, Actionable.MODULATE);
        BasicCellInventory cannonInv = BasicCellInventory.createInventory(cannon, null);
        for (class_1792 item : ammo) {
            cannonInv.insert(AEItemKey.of((class_1935)item), item.method_7882(), Actionable.MODULATE, new BaseActionSource());
        }
        return cannon;
    }

    @TestPlot(value="insert_fluid_into_mechest")
    public static void testInsertFluidIntoMEChest(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        plot.creativeEnergyCell(origin.method_10074());
        plot.blockEntity(origin, AEBlocks.CHEST, chest -> chest.setCell(AEItems.FLUID_CELL_4K.stack()));
        plot.cable(origin.method_10078()).part(class_2350.field_11039, AEParts.EXPORT_BUS, bus -> bus.getConfig().addFilter((class_3611)class_3612.field_15910));
        plot.blockEntity(origin.method_10078().method_10095(), AEBlocks.DRIVE, drive -> drive.getInternalInventory().addItems(CreativeCellItem.ofFluids(new class_3611[]{class_3612.field_15910})));
        plot.creativeEnergyCell(origin.method_10078().method_10095().method_10074());
        plot.test(helper -> helper.method_36018(() -> {
            ChestBlockEntity meChest = (ChestBlockEntity)helper.method_36014(origin);
            helper.assertContains(meChest.getInventory(), AEFluidKey.of((class_3611)class_3612.field_15910));
        }));
    }

    @TestPlot(value="insert_item_into_mechest")
    public static void testInsertItemsIntoMEChest(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        plot.creativeEnergyCell(origin.method_10074());
        plot.blockEntity(origin, AEBlocks.CHEST, chest -> {
            class_1799 cell = AEItems.ITEM_CELL_1K.stack();
            AEItems.ITEM_CELL_1K.method_8389().getConfigInventory(cell).addFilter((class_1935)class_1802.field_8725);
            chest.setCell(cell);
        });
        plot.hopper(origin.method_10084(), class_2350.field_11033, new class_1935[]{class_1802.field_8600, class_1802.field_8725});
        plot.test(helper -> helper.method_36018(() -> {
            ChestBlockEntity meChest = (ChestBlockEntity)helper.method_36014(origin);
            helper.assertContains(meChest.getInventory(), AEItemKey.of((class_1935)class_1802.field_8725));
            helper.method_35983(origin.method_10084(), class_1802.field_8600);
        }));
    }

    @TestPlot(value="maxchannels_adhoctest")
    public static void maxChannelsAdHocTest(PlotBuilder plot) {
        plot.creativeEnergyCell("0 -1 0");
        plot.block("[-3,3] -2 [-3,3]", AEBlocks.DRIVE);
        plot.cable("[-3,3] 0 [-3,3]", AEParts.SMART_DENSE_CABLE);
        plot.cable("[-3,3] [1,64] [-3,2]").part(class_2350.field_11034, AEParts.TERMINAL).part(class_2350.field_11043, AEParts.TERMINAL).part(class_2350.field_11039, AEParts.TERMINAL).part(class_2350.field_11039, AEParts.TERMINAL);
        plot.cable("[-3,3] [1,64] 3").part(class_2350.field_11043, AEParts.PATTERN_PROVIDER).part(class_2350.field_11035, AEParts.PATTERN_PROVIDER).part(class_2350.field_11034, AEParts.PATTERN_PROVIDER).part(class_2350.field_11039, AEParts.PATTERN_PROVIDER);
        plot.afterGridExistsAt("0 0 0", (grid, node) -> {
            ((PathingService)grid.getPathingService()).setForcedChannelMode(ChannelMode.INFINITE);
            Iterator<PatternProviderPart> patternProviders = grid.getMachines(PatternProviderPart.class).iterator();
            PatternProviderPart current = patternProviders.next();
            List craftingRecipes = node.getLevel().method_8433().method_30027(class_3956.field_17545);
            HashSet<AEItemKey> neededIngredients = new HashSet<AEItemKey>();
            HashSet<AEItemKey> providedResults = new HashSet<AEItemKey>();
            for (class_3955 recipe : craftingRecipes) {
                class_1799 craftingPattern;
                block8: {
                    if (recipe.method_8118()) continue;
                    try {
                        class_1799[] ingredients = (class_1799[])CraftingRecipeUtil.ensure3by3CraftingMatrix(recipe).stream().map(i -> {
                            if (i.method_8103()) {
                                return class_1799.field_8037;
                            }
                            return i.method_8105()[0];
                        }).toArray(class_1799[]::new);
                        craftingPattern = PatternDetailsHelper.encodeCraftingPattern(recipe, ingredients, recipe.method_8110(node.getLevel().method_30349()), false, false);
                        for (class_1799 ingredient : ingredients) {
                            AEItemKey key = AEItemKey.of(ingredient);
                            if (key == null) continue;
                            neededIngredients.add(key);
                        }
                        if (recipe.method_8110(node.getLevel().method_30349()).method_7960()) break block8;
                        providedResults.add(AEItemKey.of(recipe.method_8110(node.getLevel().method_30349())));
                    }
                    catch (Exception e) {
                        AELog.warn(e);
                        continue;
                    }
                }
                if (current.getLogic().getPatternInv().addItems(craftingPattern).method_7960()) continue;
                if (!patternProviders.hasNext()) break;
                current = patternProviders.next();
                current.getLogic().getPatternInv().addItems(craftingPattern);
            }
            UnmodifiableIterator keysToAdd = Sets.difference(neededIngredients, providedResults).iterator();
            block4: for (DriveBlockEntity drive : grid.getMachines(DriveBlockEntity.class)) {
                InternalInventory cellInv = drive.getInternalInventory();
                for (int i2 = 0; i2 < cellInv.size(); ++i2) {
                    class_1799 creativeCell = AEItems.ITEM_CELL_CREATIVE.stack();
                    ConfigInventory configInv = AEItems.ITEM_CELL_CREATIVE.method_8389().getConfigInventory(creativeCell);
                    for (int j = 0; j < configInv.size(); ++j) {
                        if (!keysToAdd.hasNext()) {
                            cellInv.addItems(creativeCell);
                            break block4;
                        }
                        AEItemKey keyToAdd = (AEItemKey)keysToAdd.next();
                        configInv.setStack(j, new GenericStack(keyToAdd, 1L));
                    }
                    cellInv.addItems(creativeCell);
                }
            }
        });
    }

    @TestPlot(value="blockingmode_subnetwork_chesttest")
    public static void blockingModeSubnetworkChestTest(PlotBuilder plot) {
        plot.creativeEnergyCell("0 -1 0");
        plot.block("[0,1] [0,1] [0,1]", AEBlocks.CRAFTING_ACCELERATOR);
        plot.block("0 0 0", AEBlocks.CRAFTING_STORAGE_64K);
        GenericStack input = GenericStack.fromItemStack(new class_1799((class_1935)class_1802.field_8695));
        GenericStack output = GenericStack.fromItemStack(new class_1799((class_1935)class_1802.field_8477));
        plot.cable("2 0 0").part(class_2350.field_11034, AEParts.PATTERN_PROVIDER, pp -> {
            pp.getLogic().getPatternInv().addItems(PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{input}, new GenericStack[]{output}));
            pp.getLogic().getConfigManager().putSetting(Settings.BLOCKING_MODE, YesNo.YES);
        });
        plot.drive(new class_2338(2, 0, -1)).addCreativeCell().add(input);
        plot.creativeEnergyCell("3 -1 0");
        plot.cable("3 0 0").part(class_2350.field_11039, AEParts.INTERFACE).part(class_2350.field_11034, AEParts.STORAGE_BUS);
        plot.block("4 0 0", class_2246.field_10034);
        plot.test(helper -> {
            TestCraftingJob craftingJob = new TestCraftingJob((PlotTestHelper)((Object)helper), class_2338.field_10980, output.what(), 64L);
            helper.method_36041().method_36079(craftingJob::tickUntilStarted).method_36079(() -> {
                IGrid grid = helper.getGrid(class_2338.field_10980);
                long requesting = grid.getCraftingService().getRequestedAmount(output.what());
                helper.check(requesting > 0L, "not yet requesting items");
                if (requesting != 1L) {
                    helper.method_35995("blocking mode failed, requesting: " + requesting);
                }
            }).method_36075();
        });
    }

    @TestPlot(value="canceling_jobs_from_interfacecrash")
    public static void cancelingJobsFromInterfaceCrash(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        plot.creativeEnergyCell(origin);
        plot.blockEntity(origin.method_10084(), AEBlocks.INTERFACE, iface -> {
            iface.getUpgrades().addItems(AEItems.CRAFTING_CARD.stack());
            iface.getConfig().setStack(0, new GenericStack(AEItemKey.of((class_1935)class_1802.field_8118), 1L));
        });
        plot.block(origin.method_10078(), AEBlocks.CRAFTING_STORAGE_1K);
        plot.cable(origin.method_10067()).craftingEmitter(class_2350.field_11039, (class_1935)class_1802.field_8118);
        plot.test(helper -> helper.method_36041().method_36079(() -> {
            IGrid grid = helper.getGrid(origin);
            helper.check(grid.getCraftingService().isRequesting(AEItemKey.of((class_1935)class_1802.field_8118)), "Interface is not crafting oak planks");
        }).method_36085(() -> {
            InterfaceBlockEntity iface = (InterfaceBlockEntity)helper.method_36014(origin.method_10084());
            iface.getUpgrades().removeItems(1, class_1799.field_8037, null);
            IGrid grid = helper.getGrid(origin);
            long inserted = grid.getStorageService().getInventory().insert(AEItemKey.of((class_1935)class_1802.field_8118), 1L, Actionable.MODULATE, new BaseActionSource());
            helper.check(inserted == 0L, "Nothing should have been inserted into the network");
            helper.check(iface.getInterfaceLogic().getStorage().isEmpty(), "Nothing should have been inserted into the interface");
        }).method_36075()).maxTicks(300);
    }

    @TestPlot(value="terminal_fullof_enchanteditems")
    public static void terminalFullOfEnchantedItems(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        plot.creativeEnergyCell(origin.method_10074());
        plot.cable(origin).part(class_2350.field_11043, AEParts.TERMINAL);
        DriveBuilder drive = plot.drive(origin.method_10078());
        class_1799 pickaxe = new class_1799((class_1935)class_1802.field_8377);
        pickaxe.method_7978(class_1893.field_9130, 1);
        for (int i = 0; i < 10; ++i) {
            DriveBuilder.ItemCellBuilder cell = drive.addItemCell64k();
            for (int j = 0; j < 63; ++j) {
                pickaxe.method_7974(pickaxe.method_7919() + 1);
                cell.add(AEItemKey.of(pickaxe), 2L);
            }
        }
    }

    @TestPlot(value="import_from_cauldron")
    public static void importLavaFromCauldron(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        plot.creativeEnergyCell(origin.method_10074());
        plot.cable(origin).part(class_2350.field_11034, AEParts.IMPORT_BUS, importBus -> importBus.getUpgrades().addItems(AEItems.SPEED_CARD.stack())).part(class_2350.field_11039, AEParts.STORAGE_BUS);
        plot.block(origin.method_10067(), AEBlocks.SKY_STONE_TANK);
        plot.block(origin.method_10078(), class_2246.field_27098);
        plot.test(helper -> helper.method_36018(() -> {
            helper.method_35972(class_2246.field_10593, origin.method_10078());
            SkyStoneTankBlockEntity tank = (SkyStoneTankBlockEntity)helper.method_36014(origin.method_10067());
            helper.check(tank.getStorage().amount == 81000L, "Less than a bucket stored");
            helper.check(((FluidVariant)tank.getStorage().variant).getFluid() == class_3612.field_15908, "Something other than lava stored");
        }));
    }

    @TestPlot(value="tool_repair_recipe")
    public static void toolRepairRecipe(PlotBuilder plot) {
        AEItemKey undamaged = AEItemKey.of((class_1935)class_1802.field_8377);
        int maxDamage = undamaged.getFuzzySearchMaxValue();
        AEItemKey damaged = (AEItemKey)class_156.method_656(() -> {
            class_1799 is = undamaged.toStack();
            is.method_7974(maxDamage - 1);
            return AEItemKey.of(is);
        });
        AEItemKey correctResult = (AEItemKey)class_156.method_656(() -> {
            class_1799 is = undamaged.toStack();
            int usesLeft = 2 + maxDamage * 5 / 100;
            is.method_7974(maxDamage - usesLeft);
            return AEItemKey.of(is);
        });
        plot.creativeEnergyCell("0 0 0");
        class_2338 molecularAssemblerPos = new class_2338(0, 1, 0);
        plot.blockEntity(molecularAssemblerPos, AEBlocks.MOLECULAR_ASSEMBLER, molecularAssembler -> {
            class_1715 craftingContainer = new class_1715((class_1703)new AutoCraftingMenu(), 3, 3);
            craftingContainer.method_5447(0, undamaged.toStack());
            craftingContainer.method_5447(1, undamaged.toStack());
            class_1937 level = molecularAssembler.method_10997();
            class_3955 recipe = (class_3955)level.method_8433().method_8132(class_3956.field_17545, (class_1263)craftingContainer, level).get();
            class_1799[] sparseInputs = new class_1799[9];
            sparseInputs[0] = undamaged.toStack();
            sparseInputs[1] = undamaged.toStack();
            for (int i = 2; i < 9; ++i) {
                sparseInputs[i] = class_1799.field_8037;
            }
            class_1799 encodedPattern = PatternDetailsHelper.encodeCraftingPattern(recipe, sparseInputs, undamaged.toStack(), true, false);
            IPatternDetails patternDetails = PatternDetailsHelper.decodePattern(encodedPattern, level);
            KeyCounter[] table = new KeyCounter[]{new KeyCounter()};
            table[0].add(damaged, 2L);
            molecularAssembler.pushPattern(patternDetails, table, class_2350.field_11036);
        });
        plot.test(helper -> helper.method_36003(40L, () -> {
            MolecularAssemblerBlockEntity molecularAssembler = (MolecularAssemblerBlockEntity)helper.method_36014(molecularAssemblerPos);
            class_1799 outputItem = molecularAssembler.getInternalInventory().getStackInSlot(9);
            if (correctResult.matches(outputItem)) {
                helper.method_36036();
            } else if (undamaged.matches(outputItem)) {
                helper.method_35995("created undamaged item");
            }
        }));
    }

    @TestPlot(value="double_chest_storage_bus")
    private static void doubleChestStorageBus(PlotBuilder plot) {
        class_2338 o = class_2338.field_10980;
        plot.chest(o.method_10095(), new class_1799((class_1935)class_1802.field_8600));
        plot.chest(o.method_10095().method_10067(), new class_1799((class_1935)class_1802.field_8600));
        plot.blockState(o.method_10095(), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12571));
        plot.blockState(o.method_10095().method_10067(), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12574));
        plot.cable(o).part(class_2350.field_11043, AEParts.STORAGE_BUS);
        plot.creativeEnergyCell(o.method_10074());
        plot.test(helper -> helper.method_36018(() -> {
            IGrid grid = helper.getGrid(o);
            KeyCounter stacks = grid.getStorageService().getInventory().getAvailableStacks();
            long stickCount = stacks.get(AEItemKey.of((class_1935)class_1802.field_8600));
            helper.check(2L == stickCount, "Stick count wasn't 2: " + stickCount);
        }));
    }

    @TestPlot(value="export_bus_dupe_regression")
    private static void exportBusDupeRegression(PlotBuilder plot) {
        class_2338 o = class_2338.field_10980;
        plot.chest(o.method_10095(), new class_1799((class_1935)class_1802.field_8600, 64));
        plot.blockState(o.method_10095(), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12571));
        plot.blockState(o.method_10095().method_10067(), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12574));
        plot.cable(o).part(class_2350.field_11043, AEParts.STORAGE_BUS).part(class_2350.field_11035, AEParts.EXPORT_BUS, part -> {
            part.getConfig().addFilter((class_1935)class_1802.field_8600);
            part.getUpgrades().addItems(AEItems.SPEED_CARD.stack(1));
            part.getUpgrades().addItems(AEItems.SPEED_CARD.stack(1));
            part.getUpgrades().addItems(AEItems.SPEED_CARD.stack(1));
            part.getUpgrades().addItems(AEItems.SPEED_CARD.stack(1));
        });
        plot.chest(o.method_10072(), new class_1799[0]);
        plot.cable(o.method_10067()).part(class_2350.field_11043, AEParts.STORAGE_BUS);
        plot.creativeEnergyCell(o.method_10074());
        plot.test(helper -> helper.method_36018(() -> {
            helper.method_36047(o.method_10095());
            helper.method_36047(o.method_10095().method_10067());
            KeyCounter counter = helper.countContainerContentAt(o.method_10072());
            long stickCount = counter.get(AEItemKey.of((class_1935)class_1802.field_8600));
            helper.check(stickCount == 64L, "Expected 64 sticks total, but found: " + stickCount);
        }));
    }

    @TestPlot(value="interface_restock_dupe_test")
    private static void interfaceRestockDupeTest(PlotBuilder plot) {
        class_2338 o = class_2338.field_10980;
        plot.chest(o.method_10095(), new class_1799((class_1935)class_1802.field_8600, 64));
        plot.blockState(o.method_10095(), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12571));
        plot.cable(o).part(class_2350.field_11043, AEParts.STORAGE_BUS);
        plot.blockState(o.method_10095().method_10067(), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12574));
        plot.cable(o.method_10067()).part(class_2350.field_11043, AEParts.STORAGE_BUS);
        plot.blockEntity(o.method_10084(), AEBlocks.INTERFACE, iface -> {
            iface.getConfig().setStack(0, GenericStack.fromItemStack(new class_1799((class_1935)class_1802.field_8600, 64)));
            iface.getConfig().setStack(1, GenericStack.fromItemStack(new class_1799((class_1935)class_1802.field_8600, 64)));
        });
        plot.creativeEnergyCell(o.method_10074());
        plot.test(helper -> helper.method_36018(() -> {
            helper.method_36047(o.method_10095());
            helper.method_36047(o.method_10095().method_10067());
            InterfaceBlockEntity iface = (InterfaceBlockEntity)helper.method_36014(o.method_10084());
            KeyCounter counter = new KeyCounter();
            iface.getInterfaceLogic().getStorage().getAvailableStacks(counter);
            long stickCount = counter.get(AEItemKey.of((class_1935)class_1802.field_8600));
            helper.check(stickCount == 64L, "Expected 64 sticks total, but found: " + stickCount);
        }));
    }

    @TestPlot(value="interface_to_interface_different_networks")
    public static void interfaceToInterfaceDifferentNetworks(PlotBuilder plot) {
        class_2338 o = class_2338.field_10980;
        plot.cable(o).part(class_2350.field_11043, AEParts.STORAGE_BUS);
        plot.blockEntity(o.method_10095(), AEBlocks.INTERFACE, iface -> {
            iface.getConfig().setStack(0, GenericStack.fromItemStack(new class_1799((class_1935)class_1802.field_8279)));
            iface.getStorage().setStack(0, GenericStack.fromItemStack(new class_1799((class_1935)class_1802.field_8279, 64)));
        });
        plot.block(o.method_10095().method_10095(), AEBlocks.CREATIVE_ENERGY_CELL);
        plot.block(o.method_10078(), AEBlocks.CREATIVE_ENERGY_CELL);
        plot.blockEntity(o.method_10072(), AEBlocks.INTERFACE, iface -> iface.getConfig().setStack(0, GenericStack.fromItemStack(new class_1799((class_1935)class_1802.field_8279))));
        plot.test(helper -> helper.method_36041().method_36079(() -> {
            InterfaceBlockEntity iface = (InterfaceBlockEntity)helper.method_36014(o.method_10072());
            GenericStack apples = iface.getStorage().getStack(0);
            helper.check(apples != null && apples.amount() == 1L, "Expected 1 apple", o.method_10072());
        }).method_36085(() -> {
            InterfaceBlockEntity iface = (InterfaceBlockEntity)helper.method_36014(o.method_10072());
            iface.getStorage().setStack(1, GenericStack.fromItemStack(new class_1799((class_1935)class_1802.field_8477)));
        }).method_36079(() -> {
            InterfaceBlockEntity iface = (InterfaceBlockEntity)helper.method_36014(o.method_10095());
            GenericStack diamonds = iface.getStorage().getStack(1);
            helper.check(diamonds != null && diamonds.amount() == 1L, "Expected 1 diamond", o.method_10095());
        }).method_36075());
    }

    static {
        PLOT_CLASSES.addAll(List.of(TestPlots.class, AutoCraftingTestPlots.class, InscriberTestPlots.class, P2PTestPlots.class, ItemP2PTestPlots.class, MemoryCardTestPlots.class, PatternProviderLockModePlots.class, SpatialTestPlots.class, QnbTestPlots.class, GuidebookPlot.class, SubnetPlots.class, AnnihilationPlaneTests.class));
    }
}

