/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.integration.abstraction.JEIFacade;
import appeng.integration.abstraction.REIFacade;
import com.google.common.base.Strings;

public final class ExternalSearch {
    private ExternalSearch() {
    }

    public static boolean isExternalSearchAvailable() {
        return JEIFacade.instance().isEnabled() || REIFacade.instance().isEnabled();
    }

    public static String getExternalSearchText() {
        if (JEIFacade.instance().isEnabled()) {
            return Strings.nullToEmpty((String)JEIFacade.instance().getSearchText());
        }
        if (REIFacade.instance().isEnabled()) {
            return Strings.nullToEmpty((String)REIFacade.instance().getSearchText());
        }
        return "";
    }

    public static void setExternalSearchText(String text) {
        JEIFacade.instance().setSearchText(Strings.nullToEmpty((String)text));
        REIFacade.instance().setSearchText(Strings.nullToEmpty((String)text));
    }

    public static void clearExternalSearchText() {
        JEIFacade.instance().setSearchText("");
        REIFacade.instance().setSearchText("");
    }

    public static boolean isExternalSearchFocused() {
        return JEIFacade.instance().hasSearchFocus() || REIFacade.instance().hasSearchFocus();
    }
}

