/*
 * Decompiled with CFR 0.152.
 */
package com.herobrinemod.herobrine.savedata;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.herobrinemod.herobrine.HerobrineMod;
import com.herobrinemod.herobrine.savedata.Config;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public class ConfigHandler {
    private static Config herobrineConfig;

    public static void registerHerobrineConfig(String fileName) {
        boolean fixedConfig = false;
        herobrineConfig = new Config(fileName);
        byte[] defaultJson = new byte[]{};
        try {
            defaultJson = Files.readAllBytes(Path.of(Objects.requireNonNull(HerobrineMod.class.getClassLoader().getResource("data/herobrine/default_config/herobrine.json")).toURI()));
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        if (herobrineConfig.getJson() == null) {
            herobrineConfig.setFile(defaultJson);
            return;
        }
        JsonObject defaultJsonObject = JsonParser.parseString((String)new String(defaultJson)).getAsJsonObject();
        for (String key : defaultJsonObject.keySet()) {
            if (herobrineConfig.getJson().has(key)) continue;
            herobrineConfig.getJson().addProperty(key, String.valueOf(defaultJsonObject.get(key)));
            fixedConfig = true;
        }
        if (fixedConfig) {
            try {
                Files.write(Paths.get(herobrineConfig.getPath(), new String[0]), herobrineConfig.getJson().toString().getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Config getHerobrineConfig() {
        return herobrineConfig;
    }
}

