/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.immediate;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import me.jellysquid.mods.sodium.client.util.MathUtil;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ColorVertex;
import net.minecraft.class_1011;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_4063;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5636;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_6854;
import net.minecraft.class_746;
import net.minecraft.class_758;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;

public class CloudRenderer {
    private static final class_2960 CLOUDS_TEXTURE_ID = new class_2960("textures/environment/clouds.png");
    private static final int CLOUD_COLOR_NEG_Y = ColorABGR.pack(0.7f, 0.7f, 0.7f, 1.0f);
    private static final int CLOUD_COLOR_POS_Y = ColorABGR.pack(1.0f, 1.0f, 1.0f, 1.0f);
    private static final int CLOUD_COLOR_NEG_X = ColorABGR.pack(0.9f, 0.9f, 0.9f, 1.0f);
    private static final int CLOUD_COLOR_POS_X = ColorABGR.pack(0.9f, 0.9f, 0.9f, 1.0f);
    private static final int CLOUD_COLOR_NEG_Z = ColorABGR.pack(0.8f, 0.8f, 0.8f, 1.0f);
    private static final int CLOUD_COLOR_POS_Z = ColorABGR.pack(0.8f, 0.8f, 0.8f, 1.0f);
    private static final int DIR_NEG_Y = 1;
    private static final int DIR_POS_Y = 2;
    private static final int DIR_NEG_X = 4;
    private static final int DIR_POS_X = 8;
    private static final int DIR_NEG_Z = 16;
    private static final int DIR_POS_Z = 32;
    private class_291 vertexBuffer;
    private CloudEdges edges;
    private class_5944 shader;
    private final class_758.class_7285 fogData = new class_758.class_7285(class_758.class_4596.field_20946);
    private int prevCenterCellX;
    private int prevCenterCellY;
    private int cachedRenderDistance;
    private class_4063 cloudRenderMode;

    public CloudRenderer(class_5912 factory) {
        this.reloadTextures(factory);
    }

    public void render(@Nullable class_638 world, class_746 player, class_4587 matrices, Matrix4f projectionMatrix, float ticks, float tickDelta, double cameraX, double cameraY, double cameraZ) {
        boolean fastClouds;
        if (world == null) {
            return;
        }
        float cloudHeight = world.method_28103().method_28108();
        if (Float.isNaN(cloudHeight)) {
            return;
        }
        class_243 color = world.method_23785(tickDelta);
        double cloudTime = (ticks + tickDelta) * 0.03f;
        double cloudCenterX = cameraX + cloudTime;
        double cloudCenterZ = cameraZ + 0.33;
        int renderDistance = class_310.method_1551().field_1690.method_38521();
        int cloudDistance = Math.max(32, renderDistance * 2 + 9);
        int centerCellX = (int)Math.floor(cloudCenterX / 12.0);
        int centerCellZ = (int)Math.floor(cloudCenterZ / 12.0);
        if (this.vertexBuffer == null || this.prevCenterCellX != centerCellX || this.prevCenterCellY != centerCellZ || this.cachedRenderDistance != renderDistance || this.cloudRenderMode != class_310.method_1551().field_1690.method_1632()) {
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            this.cloudRenderMode = class_310.method_1551().field_1690.method_1632();
            this.rebuildGeometry(bufferBuilder, cloudDistance, centerCellX, centerCellZ);
            if (this.vertexBuffer == null) {
                this.vertexBuffer = new class_291(class_291.class_8555.field_44794);
            }
            this.vertexBuffer.method_1353();
            this.vertexBuffer.method_1352(bufferBuilder.method_1326());
            class_291.method_1354();
            this.prevCenterCellX = centerCellX;
            this.prevCenterCellY = centerCellZ;
            this.cachedRenderDistance = renderDistance;
        }
        float previousEnd = RenderSystem.getShaderFogEnd();
        float previousStart = RenderSystem.getShaderFogStart();
        this.fogData.field_38341 = cloudDistance * 8;
        this.fogData.field_38340 = cloudDistance * 8 - 16;
        this.applyFogModifiers(world, this.fogData, player, cloudDistance * 8, tickDelta);
        RenderSystem.setShaderFogEnd((float)this.fogData.field_38341);
        RenderSystem.setShaderFogStart((float)this.fogData.field_38340);
        float translateX = (float)(cloudCenterX - (double)(centerCellX * 12));
        float translateZ = (float)(cloudCenterZ - (double)(centerCellZ * 12));
        RenderSystem.enableDepthTest();
        this.vertexBuffer.method_1353();
        boolean insideClouds = cameraY < (double)(cloudHeight + 4.5f) && cameraY > (double)(cloudHeight - 0.5f);
        boolean bl = fastClouds = this.cloudRenderMode == class_4063.field_18163;
        if (insideClouds || fastClouds) {
            RenderSystem.disableCull();
        } else {
            RenderSystem.enableCull();
        }
        RenderSystem.setShaderColor((float)((float)color.field_1352), (float)((float)color.field_1351), (float)((float)color.field_1350), (float)0.8f);
        matrices.method_22903();
        Matrix4f modelViewMatrix = matrices.method_23760().method_23761();
        modelViewMatrix.translate(-translateX, cloudHeight - (float)cameraY + 0.33f, -translateZ);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.vertexBuffer.method_34427(modelViewMatrix, projectionMatrix, this.shader);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)514);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.vertexBuffer.method_34427(modelViewMatrix, projectionMatrix, this.shader);
        matrices.method_22909();
        class_291.method_1354();
        RenderSystem.disableBlend();
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableCull();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderFogEnd((float)previousEnd);
        RenderSystem.setShaderFogStart((float)previousStart);
    }

    private void applyFogModifiers(class_638 world, class_758.class_7285 fogData, class_746 player, int cloudDistance, float tickDelta) {
        class_1293 statusEffectInstance;
        if (class_310.method_1551().field_1773 == null || class_310.method_1551().field_1773.method_19418() == null) {
            return;
        }
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_5636 cameraSubmersionType = camera.method_19334();
        if (cameraSubmersionType == class_5636.field_27885) {
            if (player.method_7325()) {
                fogData.field_38340 = -8.0f;
                fogData.field_38341 = (float)cloudDistance * 0.5f;
            } else if (player.method_6059(class_1294.field_5918)) {
                fogData.field_38340 = 0.0f;
                fogData.field_38341 = 3.0f;
            } else {
                fogData.field_38340 = 0.25f;
                fogData.field_38341 = 1.0f;
            }
        } else if (cameraSubmersionType == class_5636.field_27887) {
            if (player.method_7325()) {
                fogData.field_38340 = -8.0f;
                fogData.field_38341 = (float)cloudDistance * 0.5f;
            } else {
                fogData.field_38340 = 0.0f;
                fogData.field_38341 = 2.0f;
            }
        } else if (cameraSubmersionType == class_5636.field_27886) {
            fogData.field_38340 = -8.0f;
            fogData.field_38341 = 96.0f;
            fogData.field_38341 *= Math.max(0.25f, player.method_3140());
            if (fogData.field_38341 > (float)cloudDistance) {
                fogData.field_38341 = cloudDistance;
                fogData.field_38342 = class_6854.field_36351;
            }
        } else if (world.method_28103().method_28110(class_3532.method_15357((double)camera.method_19326().field_1352), class_3532.method_15357((double)camera.method_19326().field_1350)) || class_310.method_1551().field_1705.method_1740().method_1800()) {
            fogData.field_38340 = (float)cloudDistance * 0.05f;
            fogData.field_38341 = Math.min((float)cloudDistance, 192.0f) * 0.5f;
        }
        class_758.class_7286 fogModifier = class_758.method_42588((class_1297)player, (float)tickDelta);
        if (fogModifier != null && (statusEffectInstance = player.method_6112(fogModifier.method_42590())) != null) {
            fogModifier.method_42591(fogData, (class_1309)player, statusEffectInstance, (float)(cloudDistance * 8), tickDelta);
        }
    }

    private void rebuildGeometry(class_287 bufferBuilder, int cloudDistance, int centerCellX, int centerCellZ) {
        VertexBufferWriter writer = VertexBufferWriter.of((class_4588)bufferBuilder);
        boolean fastClouds = this.cloudRenderMode == class_4063.field_18163;
        for (int offsetX = -cloudDistance; offsetX < cloudDistance; ++offsetX) {
            for (int offsetZ = -cloudDistance; offsetZ < cloudDistance; ++offsetZ) {
                int connectedEdges = this.edges.getEdges(centerCellX + offsetX, centerCellZ + offsetZ);
                if (connectedEdges == 0) continue;
                int texel = this.edges.getColor(centerCellX + offsetX, centerCellZ + offsetZ);
                float x = offsetX * 12;
                float z = offsetZ * 12;
                try (MemoryStack stack = MemoryStack.stackPush();){
                    int mixedColor;
                    long buffer;
                    long ptr = buffer = stack.nmalloc((fastClouds ? 4 : 24) * 16);
                    int count = 0;
                    if ((connectedEdges & 1) != 0) {
                        mixedColor = ColorMixer.mul(texel, fastClouds ? CLOUD_COLOR_POS_Y : CLOUD_COLOR_NEG_Y);
                        ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 0.0f, z + 12.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 12.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 0.0f, z + 0.0f, mixedColor);
                        count += 4;
                    }
                    if (fastClouds) {
                        writer.push(stack, buffer, count, ColorVertex.FORMAT);
                        continue;
                    }
                    if ((connectedEdges & 2) != 0) {
                        mixedColor = ColorMixer.mul(texel, CLOUD_COLOR_POS_Y);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + 12.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 4.0f, z + 12.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 4.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + 0.0f, mixedColor);
                        count += 4;
                    }
                    if ((connectedEdges & 4) != 0) {
                        mixedColor = ColorMixer.mul(texel, CLOUD_COLOR_NEG_X);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 12.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + 12.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 0.0f, mixedColor);
                        count += 4;
                    }
                    if ((connectedEdges & 8) != 0) {
                        mixedColor = ColorMixer.mul(texel, CLOUD_COLOR_POS_X);
                        ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 4.0f, z + 12.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 0.0f, z + 12.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 0.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 4.0f, z + 0.0f, mixedColor);
                        count += 4;
                    }
                    if ((connectedEdges & 0x10) != 0) {
                        mixedColor = ColorMixer.mul(texel, CLOUD_COLOR_NEG_Z);
                        ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 4.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 0.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + 0.0f, mixedColor);
                        count += 4;
                    }
                    if ((connectedEdges & 0x20) != 0) {
                        mixedColor = ColorMixer.mul(texel, CLOUD_COLOR_POS_Z);
                        ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 0.0f, z + 12.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 4.0f, z + 12.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + 12.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 12.0f, mixedColor);
                        count += 4;
                    }
                    if (count <= 0) continue;
                    writer.push(stack, buffer, count, ColorVertex.FORMAT);
                    continue;
                }
            }
        }
    }

    private static long writeVertex(long buffer, float x, float y, float z, int color) {
        ColorVertex.put(buffer, x, y, z, color);
        return buffer + 16L;
    }

    public void reloadTextures(class_5912 factory) {
        this.destroy();
        this.edges = CloudRenderer.createCloudEdges();
        try {
            this.shader = new class_5944(factory, "clouds", class_290.field_1576);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        if (this.shader != null) {
            this.shader.close();
            this.shader = null;
        }
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static CloudEdges createCloudEdges() {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        class_3298 resource = (class_3298)resourceManager.method_14486(CLOUDS_TEXTURE_ID).orElseThrow();
        try (InputStream inputStream = resource.method_14482();){
            CloudEdges cloudEdges;
            block14: {
                class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);
                try {
                    cloudEdges = new CloudEdges(nativeImage);
                    if (nativeImage == null) break block14;
                }
                catch (Throwable throwable) {
                    if (nativeImage != null) {
                        try {
                            nativeImage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                nativeImage.close();
            }
            return cloudEdges;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to load texture data", ex);
        }
    }

    private static class CloudEdges {
        private final byte[] edges;
        private final int[] colors;
        private final int width;
        private final int height;

        public CloudEdges(class_1011 texture) {
            int width = texture.method_4307();
            int height = texture.method_4323();
            Validate.isTrue((boolean)MathUtil.isPowerOfTwo(width), (String)"Texture width must be power-of-two", (Object[])new Object[0]);
            Validate.isTrue((boolean)MathUtil.isPowerOfTwo(height), (String)"Texture height must be power-of-two", (Object[])new Object[0]);
            this.edges = new byte[width * height];
            this.colors = new int[width * height];
            this.width = width;
            this.height = height;
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < height; ++z) {
                    int cell;
                    int index = CloudEdges.index(x, z, width, height);
                    this.colors[index] = cell = texture.method_4315(x, z);
                    int edges = 0;
                    if (CloudEdges.isOpaqueCell(cell)) {
                        int posZ;
                        int negZ;
                        int posX;
                        edges |= 3;
                        int negX = texture.method_4315(CloudEdges.wrap(x - 1, width), CloudEdges.wrap(z, height));
                        if (cell != negX) {
                            edges |= 4;
                        }
                        if (!CloudEdges.isOpaqueCell(posX = texture.method_4315(CloudEdges.wrap(x + 1, width), CloudEdges.wrap(z, height))) && cell != posX) {
                            edges |= 8;
                        }
                        if (cell != (negZ = texture.method_4315(CloudEdges.wrap(x, width), CloudEdges.wrap(z - 1, height)))) {
                            edges |= 0x10;
                        }
                        if (!CloudEdges.isOpaqueCell(posZ = texture.method_4315(CloudEdges.wrap(x, width), CloudEdges.wrap(z + 1, height))) && cell != posZ) {
                            edges |= 0x20;
                        }
                    }
                    this.edges[index] = (byte)edges;
                }
            }
        }

        private static boolean isOpaqueCell(int color) {
            return ColorARGB.unpackAlpha(color) > 1;
        }

        public int getEdges(int x, int z) {
            return this.edges[CloudEdges.index(x, z, this.width, this.height)];
        }

        public int getColor(int x, int z) {
            return this.colors[CloudEdges.index(x, z, this.width, this.height)];
        }

        private static int index(int posX, int posZ, int width, int height) {
            return CloudEdges.wrap(posX, width) * width + CloudEdges.wrap(posZ, height);
        }

        private static int wrap(int pos, int dim) {
            return pos & dim - 1;
        }
    }
}

