/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark.elements;

import dev.dediamondpro.resourcify.libs.minemark.LayoutData;
import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.elements.Element;
import dev.dediamondpro.resourcify.libs.minemark.elements.Inline;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public abstract class ChildBasedElement<S extends Style, R>
extends Element<S, R> {
    public ChildBasedElement(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes) {
        super(style, layoutStyle, parent, qName, attributes);
    }

    @Override
    @ApiStatus.Internal
    public void generateLayout(LayoutData layoutData, R renderData) {
        if (!(this instanceof Inline) && layoutData.isLineOccupied()) {
            layoutData.nextLine();
        }
        float padding = this.getPadding(layoutData, renderData);
        layoutData.updateTopSpacing(padding);
        for (Element child : this.children) {
            child.generateLayout(layoutData, renderData);
        }
        layoutData.updateBottomSpacing(padding);
        if (!(this instanceof Inline)) {
            layoutData.nextLine();
        }
    }

    protected float getPadding(LayoutData layoutData, R renderData) {
        return 0.0f;
    }
}

