/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark.elements;

import dev.dediamondpro.resourcify.libs.minemark.LayoutData;
import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.elements.ChildBasedElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.Element;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import dev.dediamondpro.resourcify.libs.minemark.utils.MouseButton;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.xml.sax.Attributes;

public class MineMarkElement<S extends Style, R>
extends ChildBasedElement<S, R> {
    private final ArrayList<Consumer<Float>> layoutCallbacks = new ArrayList();
    private float lastWidth = -1.0f;
    private float height;

    public MineMarkElement(S style, LayoutStyle layoutStyle, Attributes attributes) {
        super(style, layoutStyle, null, null, attributes);
    }

    public void draw(float x, float y, float width, float mouseX, float mouseY, R renderData) {
        if (width <= 0.0f) {
            throw new IllegalArgumentException("Width cannot be zero or negative!");
        }
        if (width != this.lastWidth) {
            this.beforeDraw(x, y, width, mouseX, mouseY, renderData);
        }
        this.drawInternal(x, y, mouseX - x, mouseY - y, renderData);
    }

    public void beforeDraw(float x, float y, float width, float mouseX, float mouseY, R renderData) {
        if (width <= 0.0f) {
            throw new IllegalArgumentException("Width cannot be zero or negative!");
        }
        if (width != this.lastWidth) {
            this.generateLayout(new LayoutData(width), renderData);
            this.lastWidth = width;
        }
        this.beforeDrawInternal(x, y, mouseX - x, mouseY - y, renderData);
    }

    public void onMouseClicked(float x, float y, MouseButton button, float mouseX, float mouseY) {
        this.onMouseClickedInternal(button, mouseX - x, mouseY - y);
    }

    @Override
    public void regenerateLayout() {
        this.lastWidth = -1.0f;
    }

    @Override
    @ApiStatus.Internal
    public void generateLayout(LayoutData layoutData, R renderData) {
        layoutData.lockTopSpacing();
        super.generateLayout(layoutData, renderData);
        float bottomSpacing = layoutData.getCurrentLine().getBottomSpacing();
        if (bottomSpacing == 0.0f && layoutData.isLineEmpty() && layoutData.getPreviousLine() != null) {
            bottomSpacing = layoutData.getPreviousLine().getBottomSpacing();
        }
        this.height = layoutData.getY() + layoutData.getLineHeight() - bottomSpacing;
        for (Consumer<Float> callback : this.layoutCallbacks) {
            callback.accept(Float.valueOf(this.height));
        }
    }

    public void addLayoutCallback(Consumer<Float> callback) {
        this.layoutCallbacks.add(callback);
    }

    public float getHeight() {
        return this.height;
    }

    public String getTree() {
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            builder.append("+ ");
            builder.append(((Element)this.children.get(i2)).buildTree(1));
            if (i2 + 1 == this.children.size()) continue;
            builder.append("\n");
        }
        return builder.toString();
    }
}

