/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\b\"\u0004\b\u0000\u0010\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Ldev/dediamondpro/resourcify/util/MultiThreading;", "", "Ljava/lang/Runnable;", "r", "Ljava/lang/Thread;", "createThread", "(Ljava/lang/Runnable;)Ljava/lang/Thread;", "runnable", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "runAsync", "(Ljava/lang/Runnable;)Ljava/util/concurrent/CompletableFuture;", "U", "Ljava/util/function/Supplier;", "supplier", "supplyAsync", "(Ljava/util/function/Supplier;)Ljava/util/concurrent/CompletableFuture;", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "pool", "Ljava/util/concurrent/ExecutorService;", "<init>", "()V", "resourcify"})
public final class MultiThreading {
    @NotNull
    public static final MultiThreading INSTANCE = new MultiThreading();
    private static final ExecutorService pool = Executors.newCachedThreadPool(INSTANCE::createThread);

    private MultiThreading() {
    }

    @NotNull
    public final <U> CompletableFuture<U> supplyAsync(@NotNull Supplier<U> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        CompletableFuture<U> completableFuture = CompletableFuture.supplyAsync(supplier, pool);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(supplier, pool)");
        return completableFuture;
    }

    @NotNull
    public final CompletableFuture<Void> runAsync(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(runnable, pool);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"runAsync(runnable, pool)");
        return completableFuture;
    }

    private final Thread createThread(Runnable r) {
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"thread");
        return thread;
    }
}

