/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3611;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_4730;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import org.jetbrains.annotations.Nullable;
import reborncore.api.blockentity.IUpgradeable;
import reborncore.client.gui.GuiBuilder;
import reborncore.client.gui.config.GuiTab;
import reborncore.client.gui.config.elements.GuiSpriteAtlasHolder;
import reborncore.client.gui.widget.GuiButtonHologram;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.slot.PlayerInventorySlot;

@Environment(value=EnvType.CLIENT)
public class GuiBase<T extends class_1703>
extends class_465<T> {
    public static FluidCellProvider fluidCellProvider = fluid -> class_1799.field_8037;
    public static class_1799 wrenchStack = class_1799.field_8037;
    public GuiBuilder builder = new GuiBuilder();
    public class_2586 be;
    @Nullable
    public BuiltScreenHandler builtScreenHandler;
    private final int xSize = 176;
    private final int ySize = 176;
    @Nullable
    private GuiTab selectedTab = null;
    private final List<GuiTab> tabs;
    public boolean upgrades;

    public GuiBase(class_1657 player, class_2586 blockEntity, T screenHandler) {
        super(screenHandler, player.method_31548(), (class_2561)class_2561.method_43470((String)class_1074.method_4662((String)blockEntity.method_11010().method_26204().method_9539(), (Object[])new Object[0])));
        this.be = blockEntity;
        this.builtScreenHandler = (BuiltScreenHandler)((Object)screenHandler);
        this.tabs = GuiTab.TABS.stream().map(factory -> factory.create(this)).filter(GuiTab::enabled).toList();
    }

    public int getScreenWidth() {
        return this.field_2792;
    }

    public void drawSlot(class_332 drawContext, int x, int y, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.field_2776;
            y += this.field_2800;
        }
        this.builder.drawSlot(drawContext, x - 1, y - 1);
    }

    public void drawOutputSlotBar(class_332 drawContext, int x, int y, int count, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.field_2776;
            y += this.field_2800;
        }
        this.builder.drawOutputSlotBar(drawContext, x - 4, y - 4, count);
    }

    public void drawArmourSlots(class_332 drawContext, int x, int y, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.field_2776;
            y += this.field_2800;
        }
        this.builder.drawSlot(drawContext, x - 1, y - 1);
        this.builder.drawSlot(drawContext, x - 1, y - 1 + 18);
        this.builder.drawSlot(drawContext, x - 1, y - 1 + 18 + 18);
        this.builder.drawSlot(drawContext, x - 1, y - 1 + 18 + 18 + 18);
    }

    public void drawOutputSlot(class_332 drawContext, int x, int y, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.field_2776;
            y += this.field_2800;
        }
        this.builder.drawOutputSlot(drawContext, x - 5, y - 5);
    }

    public void method_25426() {
        super.method_25426();
        for (GuiTab tab : this.tabs) {
            tab.open();
        }
    }

    protected void method_2389(class_332 drawContext, float lastFrameDuration, int mouseX, int mouseY) {
        IUpgradeable upgradeable;
        Object object;
        this.method_25420(drawContext);
        boolean drawPlayerSlots = this.selectedTab == null && this.drawPlayerSlots();
        this.updateSlotDraw(drawPlayerSlots);
        this.builder.drawDefaultBackground(drawContext, this.field_2776, this.field_2800, 176, 176);
        if (drawPlayerSlots) {
            this.builder.drawPlayerSlots(drawContext, (class_437)this, this.field_2776 + this.field_2792 / 2, this.field_2800 + 93, true);
        }
        if (this.tryAddUpgrades() && (object = this.be) instanceof IUpgradeable && (upgradeable = (IUpgradeable)object).canBeUpgraded()) {
            this.builder.drawUpgrades(drawContext, this, this.field_2776 - 24, this.field_2800 + 6);
            this.upgrades = true;
        }
        int offset = this.upgrades ? 86 : 6;
        for (GuiTab slot : this.tabs) {
            if (!slot.enabled()) continue;
            this.builder.drawSlotTab(drawContext, this, this.field_2776 - 24, this.field_2800 + offset, slot.stack());
            offset += 24;
        }
        GuiBase gui = this;
        this.getTab().ifPresent(guiTab -> this.builder.drawSlotConfigTips(drawContext, gui, this.field_2776 + this.field_2792 / 2, this.field_2800 + 93, mouseX, mouseY, (GuiTab)guiTab));
    }

    private void updateSlotDraw(boolean doDraw) {
        if (this.builtScreenHandler == null) {
            return;
        }
        for (class_1735 slot : this.builtScreenHandler.field_7761) {
            if (!(slot instanceof PlayerInventorySlot)) continue;
            ((PlayerInventorySlot)slot).doDraw = doDraw;
        }
    }

    public boolean drawPlayerSlots() {
        return true;
    }

    public boolean tryAddUpgrades() {
        return true;
    }

    protected void method_2388(class_332 drawContext, int mouseX, int mouseY) {
        this.drawTitle(drawContext);
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(drawContext, mouseX, mouseY, partialTicks);
        this.method_2380(drawContext, mouseX, mouseY);
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_46416((float)this.field_2776, (float)this.field_2800, 900.0f);
        this.getTab().ifPresent(guiTab -> guiTab.draw(drawContext, mouseX, mouseY));
        drawContext.method_51448().method_22909();
    }

    protected void method_2380(class_332 drawContext, int mouseX, int mouseY) {
        class_339 clickable;
        class_6379 selectable;
        if (this.method_2378(-25, 6, 24, 80, mouseX, mouseY) && this.upgrades && this.field_2787 != null && !this.field_2787.method_7681()) {
            ArrayList<class_5250> list = new ArrayList<class_5250>();
            list.add(class_2561.method_43471((String)"reborncore.gui.tooltip.upgrades"));
            drawContext.method_51434(class_310.method_1551().field_1772, list, mouseX, mouseY);
        }
        int offset = this.upgrades ? 82 : 0;
        for (GuiTab tab : this.tabs) {
            if (this.method_2378(-26, 6 + offset, 24, 23, mouseX, mouseY)) {
                drawContext.method_51434(class_310.method_1551().field_1772, Collections.singletonList(class_2561.method_43471((String)tab.name())), mouseX, mouseY);
            }
            offset += 24;
        }
        Iterator<GuiTab> iterator = this.field_33815.iterator();
        while (!(!iterator.hasNext() || (selectable = (class_6379)iterator.next()) instanceof class_339 && (clickable = (class_339)selectable).method_49606())) {
        }
        super.method_2380(drawContext, mouseX, mouseY);
    }

    protected void drawTitle(class_332 drawContext) {
        this.drawCentredText(drawContext, (class_2561)class_2561.method_43471((String)this.be.method_11010().method_26204().method_9539()), 6, 0x404040, Layer.FOREGROUND);
    }

    public void drawCentredText(class_332 drawContext, class_2561 text, int y, int colour, Layer layer) {
        this.drawText(drawContext, text, this.field_2792 / 2 - this.getTextRenderer().method_27525((class_5348)text) / 2, y, colour, layer);
    }

    public void drawCentredText(class_332 drawContext, class_2561 text, int y, int colour, int modifier, Layer layer) {
        this.drawText(drawContext, text, this.field_2792 / 2 - this.getTextRenderer().method_27525((class_5348)text) / 2 + modifier, y, colour, layer);
    }

    public void drawText(class_332 drawContext, class_2561 text, int x, int y, int colour, Layer layer) {
        int factorX = 0;
        int factorY = 0;
        if (layer == Layer.BACKGROUND) {
            factorX = this.field_2776;
            factorY = this.field_2800;
        }
        drawContext.method_51439(class_310.method_1551().field_1772, text, x + factorX, y + factorY, colour, false);
    }

    public GuiButtonHologram addHologramButton(int x, int y, int id, Layer layer) {
        GuiButtonHologram buttonHologram = new GuiButtonHologram(x + this.field_2776, y + this.field_2800, var1 -> {});
        this.method_25429((class_364)buttonHologram);
        return buttonHologram;
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.getTab().map(guiTab -> guiTab.click(mouseX, mouseY, mouseButton)).orElse(false).booleanValue()) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25406(double mouseX, double mouseY, int state) {
        int offset = 0;
        if (!this.upgrades) {
            offset = 80;
        }
        for (GuiTab tab : this.tabs) {
            if (this.method_2378(-26, 84 - offset, 30, 23, mouseX, mouseY)) {
                if (this.selectedTab == tab) {
                    this.closeSelectedTab();
                    break;
                }
                this.setSelectedTab(tab);
                break;
            }
            offset -= 24;
        }
        return super.method_25406(mouseX, mouseY, state);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.getTab().map(guiTab -> guiTab.keyPress(keyCode, scanCode, modifiers)).orElse(false).booleanValue()) {
            return true;
        }
        if (this.selectedTab != null && keyCode == 256) {
            this.closeSelectedTab();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        this.closeSelectedTab();
        super.method_25419();
    }

    public MachineBaseBlockEntity getMachine() {
        return (MachineBaseBlockEntity)this.be;
    }

    public boolean isPointInRect(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY) {
        return super.method_2378(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    public boolean isConfigEnabled() {
        return this.be instanceof MachineBaseBlockEntity && this.builtScreenHandler != null;
    }

    public int getGuiLeft() {
        return this.field_2776;
    }

    public int getGuiTop() {
        return this.field_2800;
    }

    public class_310 getMinecraft() {
        if (this.field_22787 == null) {
            throw new NullPointerException("Minecraft client is null.");
        }
        return this.field_22787;
    }

    public class_327 getTextRenderer() {
        return this.field_22793;
    }

    public Optional<GuiTab> getTab() {
        if (!this.isConfigEnabled()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.selectedTab);
    }

    public boolean isTabOpen() {
        return this.selectedTab != null;
    }

    public boolean hideGuiElements() {
        return this.selectedTab != null && this.selectedTab.hideGuiElements();
    }

    private void setSelectedTab(GuiTab tab) {
        Objects.requireNonNull(tab);
        this.selectedTab = tab;
        this.selectedTab.open();
    }

    public void closeSelectedTab() {
        if (this.selectedTab != null) {
            this.selectedTab.close();
        }
        this.selectedTab = null;
    }

    public GuiTab getSelectedTab() {
        return this.selectedTab;
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top, int mouseButton) {
        return this.method_2386(mouseX, mouseY) == null && super.method_2381(mouseX, mouseY, left, top, mouseButton);
    }

    public List<GuiTab> getTabs() {
        return this.tabs;
    }

    public static class_1058 getSprite(class_4730 spriteIdentifier) {
        return GuiSpriteAtlasHolder.INSTANCE.method_18667(spriteIdentifier.method_24147());
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Layer {
        BACKGROUND,
        FOREGROUND;

    }

    @Environment(value=EnvType.CLIENT)
    public static interface FluidCellProvider {
        public class_1799 provide(class_3611 var1);
    }
}

