/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.config.elements;

import java.util.Arrays;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.GuiSprites;
import reborncore.client.gui.config.elements.ButtonElement;
import reborncore.client.gui.config.elements.CheckBoxElement;
import reborncore.client.gui.config.elements.ParentElement;
import reborncore.client.gui.config.elements.SlotConfigPopupElement;
import reborncore.client.gui.config.elements.SlotType;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.screen.slot.BaseSlot;

@Environment(value=EnvType.CLIENT)
public class ConfigSlotElement
extends ParentElement {
    private final SlotType type;
    private final class_1263 inventory;
    private final int id;
    private final boolean filter;

    public ConfigSlotElement(class_1263 slotInventory, int slotId, SlotType type, int x, int y, GuiBase<?> gui, Runnable closeConfig) {
        super(x, y, type.getButtonSprite());
        SlotConfiguration.SlotFilter slotFilter;
        this.type = type;
        this.inventory = slotInventory;
        this.id = slotId;
        this.filter = gui.getMachine() instanceof SlotConfiguration.SlotFilter;
        boolean inputEnabled = gui.builtScreenHandler.field_7761.stream().filter(Objects::nonNull).filter(slot -> slot.field_7871 == this.inventory).filter(slot -> slot instanceof BaseSlot).map(slot -> (BaseSlot)((Object)slot)).filter(baseSlot -> baseSlot.method_34266() == slotId).allMatch(BaseSlot::canWorldBlockInsert);
        SlotConfigPopupElement popupElement = new SlotConfigPopupElement(this.id, x - 22, y - 22, inputEnabled);
        this.elements.add(popupElement);
        this.elements.add(new ButtonElement(x + 37, y - 25, GuiSprites.EXIT_BUTTON, closeConfig));
        if (inputEnabled) {
            this.elements.add(new CheckBoxElement((class_2561)class_2561.method_43471((String)"reborncore.gui.slotconfig.autoinput"), x - 26, y + 42, checkBoxElement -> gui.getMachine().getSlotConfiguration().getSlotDetails(slotId).autoInput(), () -> popupElement.updateCheckBox("input", gui)));
        }
        this.elements.add(new CheckBoxElement((class_2561)class_2561.method_43471((String)"reborncore.gui.slotconfig.autooutput"), x - 26, y + 57, checkBoxElement -> gui.getMachine().getSlotConfiguration().getSlotDetails(slotId).autoOutput(), () -> popupElement.updateCheckBox("output", gui)));
        MachineBaseBlockEntity machineBaseBlockEntity = gui.getMachine();
        if (machineBaseBlockEntity instanceof SlotConfiguration.SlotFilter && Arrays.stream((slotFilter = (SlotConfiguration.SlotFilter)((Object)machineBaseBlockEntity)).getInputSlots()).anyMatch(value -> value == slotId)) {
            this.elements.add(new CheckBoxElement((class_2561)class_2561.method_43471((String)"reborncore.gui.slotconfig.filter_input"), x - 26, y + 72, checkBoxElement -> gui.getMachine().getSlotConfiguration().getSlotDetails(slotId).filter(), () -> popupElement.updateCheckBox("filter", gui)));
            popupElement.filter = true;
        }
    }

    @Override
    public int getWidth() {
        return 85;
    }

    @Override
    public int getHeight() {
        return 105 + (this.filter ? 15 : 0);
    }

    @Override
    public void draw(class_332 drawContext, GuiBase<?> gui, int mouseX, int mouseY) {
        class_1799 stack = this.inventory.method_5438(this.id);
        int xPos = this.getX() + 1 + gui.getGuiLeft();
        int yPos = this.getY() + 1 + gui.getGuiTop();
        drawContext.method_51431(gui.getTextRenderer(), stack, xPos, yPos);
        if (this.isMouseWithinRect(gui, mouseX, mouseY)) {
            this.drawSprite(drawContext, gui, this.type.getButtonHoverOverlay(), this.getX(), this.getY());
        }
        super.draw(drawContext, gui, mouseX, mouseY);
    }

    public int getId() {
        return this.id;
    }
}

